/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.profiler;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class ProfilerTaskRegistry {
    private Map<String, ProfilerTask> table;

    public Option<ProfilerTask> get(String key) {
        ProfilerTask profilerTask;
        Option result = Options.newNone();
        if (key != null && (profilerTask = this.getTable().get(key)) != null) {
            result = Options.newSome((Object)profilerTask);
        }
        return result;
    }

    public void put(String key, ProfilerTask value) throws IllegalArgumentException {
        if (this.getTable().get(key) != null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ProfilerTaskRegistry_keyConflict, key));
        }
        if (this.getTable().values().contains(value)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ProfilerTaskRegistry_valueConflict, value));
        }
        this.getTable().put(key, value);
    }

    private Map<String, ProfilerTask> getTable() {
        if (this.table == null) {
            this.table = new HashMap<String, ProfilerTask>();
        }
        return this.table;
    }
}

