/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateFieldCreator;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameFieldProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IDelegateUpdating {
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final GroupCategorySet CATEGORY_LOCAL_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.local", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables_description));
    protected IField fField;
    private boolean fIsRecordComponent = false;
    private RenameLocalVariableProcessor fRenameLocalVariableProcessor;
    private ILocalVariable fLocalVariable;
    private boolean fIsCompactConstructor;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    protected boolean fUpdateReferences;
    protected boolean fUpdateTextualMatches;
    private boolean fRenameGetter;
    private boolean fRenameSetter;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    private CompilationUnit fCompUnit;

    public RenameFieldProcessor(IField field) {
        this(field, new TextChangeManager(true), null);
        this.fIsComposite = false;
    }

    public RenameFieldProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public RenameFieldProcessor(IField field, TextChangeManager manager, GroupCategorySet categorySet) {
        this.initialize(field);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        this.fIsComposite = true;
        this.fIsRecordComponent = false;
    }

    private void initialize(IField field) {
        this.assignField(field);
        if (this.fField != null) {
            this.setNewElementName(this.fField.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameGetter = false;
        this.fRenameSetter = false;
    }

    @Override
    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        this.setLocalVariableProcessor();
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameFieldProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isRenameFieldAvailable(this.fField);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameFieldRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fField);
    }

    public IField getField() {
        return this.fField;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fField};
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        IMethod setter;
        IMethod getter;
        RenameModifications result = new RenameModifications();
        result.rename(this.fField, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameGetter && (getter = this.getGetter()) != null) {
            result.rename(getter, new RenameArguments(this.getNewGetterName(), this.getUpdateReferences()));
        }
        if (this.fRenameSetter && (setter = this.getSetter()) != null) {
            result.rename(setter, new RenameArguments(this.getNewSetterName(), this.getUpdateReferences()));
        }
        if (this.fIsRecordComponent) {
            IMethod accessor = this.getAccessor();
            if (accessor != null) {
                result.rename(accessor, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
            }
            if (this.fLocalVariable != null) {
                result.rename(this.fLocalVariable, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
            }
        }
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    @Override
    public final String getCurrentElementName() {
        return this.fField.getElementName();
    }

    @Override
    public final String getCurrentElementQualifier() {
        return this.fField.getDeclaringType().getFullyQualifiedName('.');
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkFieldName(newName, (IJavaElement)this.fField);
        if (RenameFieldProcessor.isInstanceField(this.fField) && !Checks.startsWithLowerCase(newName)) {
            result.addWarning(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_should_start_lowercase2, new String[]{BasicElementLabels.getJavaElementName(newName), this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameFieldRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fField, newName)) {
            result.addError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_another_name2, new String[]{BasicElementLabels.getJavaElementName(newName), this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameFieldRefactoring_another_name, JavaStatusContext.create((IMember)this.fField));
        }
        if (this.fField.getDeclaringType().getField(newName).exists()) {
            result.addError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined2, new String[]{BasicElementLabels.getJavaElementName(newName), this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined, JavaStatusContext.create((IMember)this.fField.getDeclaringType().getField(newName)));
        }
        return result;
    }

    private String getDeclaringTypeLabel() {
        return JavaElementLabelsCore.getElementLabel((IJavaElement)this.fField.getDeclaringType(), 0x200009L);
    }

    @Override
    public Object getNewElement() {
        return this.fField.getDeclaringType().getField(this.getNewElementName());
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String canEnableGetterRenaming() throws CoreException {
        ITypeHierarchy hierarchy;
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getGetter() == null ? "" : null;
        }
        IMethod getter = this.getGetter();
        if (getter == null) {
            return "";
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (MethodChecks.isVirtual(getter) && (MethodChecks.isDeclaredInInterface(getter, hierarchy = getter.getDeclaringType().newTypeHierarchy((IProgressMonitor)monitor), (IProgressMonitor)monitor) != null || MethodChecks.overridesAnotherMethod(getter, hierarchy) != null)) {
            return RefactoringCoreMessages.RenameFieldRefactoring_declared_in_supertype;
        }
        return null;
    }

    public String canEnableSetterRenaming() throws CoreException {
        ITypeHierarchy hierarchy;
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getSetter() == null ? "" : null;
        }
        IMethod setter = this.getSetter();
        if (setter == null) {
            return "";
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (MethodChecks.isVirtual(setter) && (MethodChecks.isDeclaredInInterface(setter, hierarchy = setter.getDeclaringType().newTypeHierarchy((IProgressMonitor)monitor), (IProgressMonitor)monitor) != null || MethodChecks.overridesAnotherMethod(setter, hierarchy) != null)) {
            return RefactoringCoreMessages.RenameFieldRefactoring_declared_in_supertype;
        }
        return null;
    }

    public boolean getRenameGetter() {
        return this.fRenameGetter;
    }

    public void setRenameGetter(boolean renameGetter) {
        this.fRenameGetter = renameGetter;
    }

    public boolean getRenameSetter() {
        return this.fRenameSetter;
    }

    public void setRenameSetter(boolean renameSetter) {
        this.fRenameSetter = renameSetter;
    }

    public IMethod getGetter() throws CoreException {
        return GetterSetterUtil.getGetter(this.fField);
    }

    public IMethod getSetter() throws CoreException {
        return GetterSetterUtil.getSetter(this.fField);
    }

    private IMethod getAccessor() throws CoreException {
        return JavaModelUtil.findMethod(this.fField.getElementName(), new String[0], false, this.fField.getDeclaringType());
    }

    private void setLocalVariableProcessor() {
        if (this.fIsRecordComponent && this.fField != null) {
            IType parent = this.fField.getDeclaringType();
            try {
                if (parent != null && parent.isRecord()) {
                    this.fCompUnit = SharedASTProviderCore.getAST((ITypeRoot)this.fField.getCompilationUnit(), SharedASTProviderCore.WAIT_YES, null);
                    IJavaElement[] iJavaElementArray = parent.getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethodBinding mBinding;
                        IMethod method;
                        MethodDeclaration mDecl;
                        IJavaElement elem = iJavaElementArray[n2];
                        if (elem instanceof IMethod && ((IMethod)elem).isConstructor() && (mDecl = ASTNodeSearchUtil.getMethodDeclarationNode(method = (IMethod)elem, this.fCompUnit)) != null && (mBinding = mDecl.resolveBinding()) != null && mBinding.isCanonicalConstructor()) {
                            ILocalVariable[] localVars;
                            ILocalVariable[] iLocalVariableArray = localVars = method.getParameters();
                            int n3 = localVars.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ILocalVariable lVar = iLocalVariableArray[n4];
                                if (lVar.getElementName().equals(this.fField.getElementName())) {
                                    this.fLocalVariable = lVar;
                                    this.fIsCompactConstructor = mBinding.isCompactConstructor();
                                    this.fRenameLocalVariableProcessor = this.createLocalRenameProcessor(lVar, this.getNewElementName(), this.fCompUnit);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public String getNewGetterName() throws CoreException {
        IMethod primaryGetterCandidate = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(this.fField, new String[0]), new String[0], false, this.fField.getDeclaringType());
        if (!JavaModelUtil.isBoolean(this.fField) || primaryGetterCandidate != null && primaryGetterCandidate.exists()) {
            return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
        }
        return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), false, null);
    }

    public String getNewSetterName() throws CoreException {
        return GetterSetterUtil.getSetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
    }

    @Override
    public boolean canEnableDelegateUpdating() {
        return this.getDelegateCount() > 0;
    }

    @Override
    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    @Override
    public void setDelegateUpdating(boolean update) {
        this.fDelegateUpdating = update;
    }

    @Override
    public void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    @Override
    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public int getDelegateCount() {
        int count = 0;
        try {
            if (RefactoringAvailabilityTesterCore.isDelegateCreationAvailable(this.getField())) {
                ++count;
            }
            if (this.fRenameGetter && this.getGetter() != null) {
                ++count;
            }
            if (this.fRenameSetter && this.getSetter() != null) {
                ++count;
            }
            if (this.fIsRecordComponent && this.getAccessor() != null) {
                ++count;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return count;
    }

    @Override
    public int getSaveMode() {
        return 4;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IField primary = (IField)this.fField.getPrimaryElement();
        if (primary == null || !primary.exists()) {
            String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_deleted, BasicElementLabels.getFileName((ITypeRoot)this.fField.getCompilationUnit()));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.assignField(primary);
        return Checks.checkIfCuBroken((IMember)this.fField);
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            pm.beginTask("", 18);
            pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(Checks.checkIfCuBroken((IMember)this.fField));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            result.merge(this.checkEnclosingHierarchy());
            pm.worked(1);
            result.merge(this.checkNestedHierarchy(this.fField.getDeclaringType()));
            pm.worked(1);
            if (this.fUpdateReferences) {
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_searching);
                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            } else {
                this.fReferences = new SearchResultGroup[0];
                pm.worked(3);
            }
            if (this.fUpdateReferences) {
                result.merge(this.analyzeAffectedCompilationUnits());
            } else {
                Checks.checkCompileErrorsInAffectedFile(result, this.fField.getResource());
            }
            if (this.getGetter() != null && this.fRenameGetter) {
                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getGetter(), this.getNewGetterName()));
                result.merge(Checks.checkIfConstructorName(this.getGetter(), this.getNewGetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            if (this.getSetter() != null && this.fRenameSetter) {
                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getSetter(), this.getNewSetterName()));
                result.merge(Checks.checkIfConstructorName(this.getSetter(), this.getNewSetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            if (this.fIsRecordComponent) {
                result.merge(this.checkRecordComponentAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getAccessor(), this.getNewElementName()));
                result.merge(Checks.checkIfConstructorName(this.getAccessor(), this.getNewElementName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            if (this.fRenameLocalVariableProcessor != null && this.fIsRecordComponent) {
                result.merge(this.fRenameLocalVariableProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                result.merge(this.fRenameLocalVariableProcessor.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            }
            result.merge(this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 10)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkAccessor(IProgressMonitor pm, IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessorDeclarations(pm, existingAccessor));
        result.merge(this.checkNewAccessor(existingAccessor, newAccessorName));
        return result;
    }

    private RefactoringStatus checkRecordComponentAccessor(IProgressMonitor pm, IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (existingAccessor != null) {
            result.merge(this.checkAccessorDeclarations(pm, existingAccessor));
        }
        result.merge(this.checkNewRecordComponentAccessor(newAccessorName));
        return result;
    }

    private RefactoringStatus checkNewAccessor(IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod accessor = JavaModelUtil.findMethod(newAccessorName, existingAccessor.getParameterTypes(), false, this.fField.getDeclaringType());
        if (accessor == null || !accessor.exists()) {
            return null;
        }
        String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_already_exists, new String[]{JavaElementUtil.createMethodSignature(accessor), BasicElementLabels.getJavaElementName(this.fField.getDeclaringType().getFullyQualifiedName('.'))});
        result.addError(message, JavaStatusContext.create((IMember)accessor));
        return result;
    }

    private RefactoringStatus checkNewRecordComponentAccessor(String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod accessor = JavaModelUtil.findMethod(newAccessorName, new String[0], false, this.fField.getDeclaringType());
        if (accessor == null || !accessor.exists()) {
            return null;
        }
        String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_recordromponent_accessor_method_already_exists, new String[]{JavaElementUtil.createMethodSignature(accessor), BasicElementLabels.getJavaElementName(this.fField.getDeclaringType().getFullyQualifiedName('.'))});
        result.addError(message, JavaStatusContext.create((IMember)accessor));
        return result;
    }

    private RefactoringStatus checkAccessorDeclarations(IProgressMonitor pm, IMethod existingAccessor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)existingAccessor, (int)0, (int)24);
        if (pattern == null) {
            return result;
        }
        IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)this.fField.getDeclaringType());
        SearchResultGroup[] groupDeclarations = RefactoringSearchEngine.search(pattern, scope, pm, result);
        Assert.isTrue((groupDeclarations.length > 0 ? 1 : 0) != 0);
        if (groupDeclarations.length != 1) {
            String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_overridden, JavaElementUtil.createMethodSignature(existingAccessor));
            result.addError(message);
        } else {
            SearchResultGroup group = groupDeclarations[0];
            Assert.isTrue((group.getSearchResults().length > 0 ? 1 : 0) != 0);
            if (group.getSearchResults().length != 1) {
                String message = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_overridden_or_overrides, JavaElementUtil.createMethodSignature(existingAccessor));
                result.addError(message);
            }
        }
        return result;
    }

    private static boolean isInstanceField(IField field) throws CoreException {
        if (JavaModelUtil.isInterfaceOrAnnotation(field.getDeclaringType())) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)field);
    }

    private RefactoringStatus checkNestedHierarchy(IType type) throws CoreException {
        IType[] nestedTypes = type.getTypes();
        if (nestedTypes == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        IType[] iTypeArray = nestedTypes;
        int n = nestedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType nestedType = iTypeArray[n2];
            IField otherField = nestedType.getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_hiding, new String[]{BasicElementLabels.getJavaElementName(this.fField.getElementName()), BasicElementLabels.getJavaElementName(this.getNewElementName()), BasicElementLabels.getJavaElementName(nestedType.getFullyQualifiedName('.'))});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            result.merge(this.checkNestedHierarchy(nestedType));
            ++n2;
        }
        return result;
    }

    private RefactoringStatus checkEnclosingHierarchy() {
        IType current = this.fField.getDeclaringType();
        if (Checks.isTopLevel(current)) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        while (current != null) {
            IField otherField = current.getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_hiding2, new String[]{BasicElementLabels.getJavaElementName(this.getNewElementName()), BasicElementLabels.getJavaElementName(current.getFullyQualifiedName('.')), BasicElementLabels.getJavaElementName(otherField.getElementName())});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            current = current.getDeclaringType();
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return result;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.fField, (int)2);
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fField, true, false);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.getCurrentElementName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        SearchPattern searchPattern = this.createSearchPattern();
        if (searchPattern == null) {
            return new SearchResultGroup[0];
        }
        SearchResultGroup[] result = RefactoringSearchEngine.search(searchPattern, this.createRefactoringScope(), new CuCollectingSearchRequestor(binaryRefs), pm, status);
        binaryRefs.addErrorIfNecessary(status);
        result = this.filterAccessorMethods(result, true);
        return result;
    }

    private SearchResultGroup[] filterAccessorMethods(SearchResultGroup[] grouped, boolean filterOut) {
        if (this.fIsRecordComponent) {
            ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
            SearchResultGroup[] searchResultGroupArray = grouped;
            int n = grouped.length;
            int n2 = 0;
            while (n2 < n) {
                SearchResultGroup g = searchResultGroupArray[n2];
                SearchMatch[] matches = g.getSearchResults();
                ArrayList<SearchMatch> newList = new ArrayList<SearchMatch>();
                SearchMatch[] searchMatchArray = matches;
                int n3 = matches.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch match = searchMatchArray[n4];
                    if (match instanceof MethodReferenceMatch) {
                        if (!filterOut) {
                            newList.add(match);
                        }
                    } else if (filterOut) {
                        newList.add(match);
                    }
                    ++n4;
                }
                if (newList.size() != matches.length) {
                    result.add(new SearchResultGroup(g.getResource(), newList.toArray(new SearchMatch[newList.size()])));
                } else {
                    result.add(g);
                }
                ++n2;
            }
            return result.toArray(new SearchResultGroup[result.size()]);
        }
        return grouped;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 1);
            TextChange[] changes = this.fChangeManager.getAllChanges();
            RenameJavaElementDescriptor descriptor = this.createRefactoringDescriptor();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, this.getProcessorName(), (Change[])changes);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    protected RenameJavaElementDescriptor createRefactoringDescriptor() {
        String project = null;
        IJavaProject javaProject = this.fField.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589826;
        try {
            if (!Flags.isPrivate((int)this.fField.getFlags())) {
                flags |= 4;
            }
        }
        catch (JavaModelException exception) {
            JavaManipulationPlugin.log(exception);
        }
        IType declaring = this.fField.getDeclaringType();
        try {
            if (declaring.isAnonymous() || declaring.isLocal()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaManipulationPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fField.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.RenameFieldProcessor_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fField.getElementName()), JavaElementLabelsCore.getElementLabel(this.fField.getParent(), 2235681801344L), this.getNewElementName()});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        if (this.fRenameGetter) {
            comment.addSetting(RefactoringCoreMessages.RenameFieldRefactoring_setting_rename_getter);
        }
        if (this.fRenameSetter) {
            comment.addSetting(RefactoringCoreMessages.RenameFieldRefactoring_setting_rename_settter);
        }
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.field");
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment.asString());
        descriptor.setFlags(flags);
        descriptor.setJavaElement((IJavaElement)this.fField);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
        descriptor.setRenameGetters(this.fRenameGetter);
        descriptor.setRenameSetters(this.fRenameSetter);
        descriptor.setKeepOriginal(this.fDelegateUpdating);
        descriptor.setDeprecateDelegate(this.fDelegateDeprecation);
        return descriptor;
    }

    private RefactoringStatus createChanges(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 10);
        RefactoringStatus result = new RefactoringStatus();
        if (!this.fIsComposite) {
            this.fChangeManager.clear();
        }
        if (this.fDelegateUpdating) {
            result.merge(this.addDelegates());
        }
        this.addDeclarationUpdate();
        if (this.fUpdateReferences) {
            this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 2)));
            if (result.hasFatalError()) {
                return result;
            }
        } else {
            pm.worked(3);
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addGetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        } else {
            pm.worked(1);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addSetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        } else {
            pm.worked(1);
        }
        if (this.fIsRecordComponent) {
            this.addAccessorOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            if (this.fRenameLocalVariableProcessor != null) {
                this.addLocalVariableOccurrences(this.getNewElementName(), result);
            }
        } else {
            pm.worked(1);
        }
        if (this.fUpdateTextualMatches) {
            this.addTextMatches((IProgressMonitor)new SubProgressMonitor(pm, 5));
        } else {
            pm.worked(5);
        }
        pm.done();
        return result;
    }

    private void addDeclarationUpdate() throws CoreException {
        ISourceRange nameRange = this.fField.getNameRange();
        ReplaceEdit textEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        ICompilationUnit cu = this.fField.getCompilationUnit();
        String groupName = RefactoringCoreMessages.RenameFieldRefactoring_Update_field_declaration;
        this.addTextEdit(this.fChangeManager.get(cu), groupName, (TextEdit)textEdit);
    }

    private RefactoringStatus addDelegates() throws JavaModelException, CoreException {
        CompilationUnitChange change;
        RefactoringStatus status = new RefactoringStatus();
        CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fField.getCompilationUnit());
        rewrite.setResolveBindings(true);
        if (RefactoringAvailabilityTesterCore.isDelegateCreationAvailable(this.fField)) {
            FieldDeclaration fieldDeclaration = ASTNodeSearchUtil.getFieldDeclarationNode(this.fField, rewrite.getRoot());
            if (fieldDeclaration.fragments().size() > 1) {
                status.addWarning(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_more_than_one_fragment, BasicElementLabels.getJavaElementName(this.fField.getElementName())), JavaStatusContext.create((IMember)this.fField));
            } else if (((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getInitializer() == null) {
                status.addWarning(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_no_initializer, BasicElementLabels.getJavaElementName(this.fField.getElementName())), JavaStatusContext.create((IMember)this.fField));
            } else {
                DelegateFieldCreator creator = new DelegateFieldCreator();
                creator.setDeclareDeprecated(this.fDelegateDeprecation);
                creator.setDeclaration((BodyDeclaration)fieldDeclaration);
                creator.setNewElementName(this.getNewElementName());
                creator.setSourceRewrite(rewrite);
                creator.prepareDelegate();
                creator.createEdit();
            }
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addMethodDelegate(this.getGetter(), this.getNewGetterName(), rewrite);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addMethodDelegate(this.getSetter(), this.getNewSetterName(), rewrite);
        }
        if (this.fIsRecordComponent && this.getAccessor() != null) {
            this.addMethodDelegate(this.getAccessor(), this.getNewElementName(), rewrite);
        }
        if ((change = rewrite.createChange(true)) != null) {
            change.setKeepPreviewEdits(true);
            this.fChangeManager.manage(this.fField.getCompilationUnit(), (TextChange)change);
        }
        return status;
    }

    private void addMethodDelegate(IMethod getter, String newName, CompilationUnitRewrite rewrite) throws JavaModelException {
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(getter, rewrite.getRoot());
        DelegateMethodCreator creator = new DelegateMethodCreator();
        creator.setDeclareDeprecated(this.fDelegateDeprecation);
        creator.setDeclaration((BodyDeclaration)declaration);
        creator.setNewElementName(newName);
        creator.setSourceRewrite(rewrite);
        creator.prepareDelegate();
        creator.createEdit();
    }

    private void addTextEdit(TextChange change, String groupName, TextEdit textEdit) {
        if (this.fIsComposite) {
            TextChangeCompatibility.addTextEdit(change, groupName, textEdit, this.fCategorySet);
        } else {
            TextChangeCompatibility.addTextEdit(change, groupName, textEdit);
        }
    }

    private void addReferenceUpdates(IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        String editName = RefactoringCoreMessages.RenameFieldRefactoring_Update_field_reference;
        SearchResultGroup[] searchResultGroupArray = this.fReferences;
        int n = this.fReferences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup reference = searchResultGroupArray[n2];
            ICompilationUnit cu = reference.getCompilationUnit();
            if (cu != null) {
                SearchMatch[] searchMatchArray = reference.getSearchResults();
                int n3 = searchMatchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch result = searchMatchArray[n4];
                    this.addTextEdit(this.fChangeManager.get(cu), editName, this.createTextChange(result));
                    ++n4;
                }
                pm.worked(1);
            }
            ++n2;
        }
    }

    private TextEdit createTextChange(SearchMatch match) {
        return new ReplaceEdit(match.getOffset(), match.getLength(), this.getNewElementName());
    }

    private void addGetterOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        this.addAccessorOccurrences(pm, this.getGetter(), RefactoringCoreMessages.RenameFieldRefactoring_Update_getter_occurrence, this.getNewGetterName(), status);
    }

    private void addSetterOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        this.addAccessorOccurrences(pm, this.getSetter(), RefactoringCoreMessages.RenameFieldRefactoring_Update_setter_occurrence, this.getNewSetterName(), status);
    }

    private void addAccessorOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        if (this.getAccessor() != null) {
            this.addAccessorOccurrences(pm, this.getAccessor(), RefactoringCoreMessages.RenameFieldRefactoring_Update_getter_occurrence, this.getNewElementName(), status);
        } else {
            this.addFieldAccessorOccurrences(pm, RefactoringCoreMessages.RenameFieldRefactoring_Update_getter_occurrence, this.getNewElementName(), status);
        }
    }

    private void addAccessorOccurrences(IProgressMonitor pm, IMethod accessor, String editName, String newAccessorName, RefactoringStatus status) throws CoreException {
        SearchResultGroup[] groupedResults;
        Assert.isTrue((boolean)accessor.exists());
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)accessor);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)accessor, (int)3, (int)24);
        if (pattern == null) {
            return;
        }
        SearchResultGroup[] searchResultGroupArray = groupedResults = RefactoringSearchEngine.search(pattern, scope, new MethodOccurenceCollector(accessor.getElementName()), pm, status);
        int n = groupedResults.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup groupedResult = searchResultGroupArray[n2];
            ICompilationUnit cu = groupedResult.getCompilationUnit();
            if (cu != null) {
                SearchMatch[] results;
                SearchMatch[] searchMatchArray = results = groupedResult.getSearchResults();
                int n3 = results.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch searchResult = searchMatchArray[n4];
                    ReplaceEdit edit = new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), newAccessorName);
                    this.addTextEdit(this.fChangeManager.get(cu), editName, (TextEdit)edit);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addLocalVariableOccurrences(String newName, RefactoringStatus status) throws CoreException {
        RenameAnalyzeUtil.LocalAnalyzePackage analyzePackage;
        Assert.isTrue((this.fRenameLocalVariableProcessor != null ? 1 : 0) != 0);
        int current = 0;
        ICompilationUnit cu = this.fField.getCompilationUnit();
        RenameAnalyzeUtil.LocalAnalyzePackage[] analyzePackages = new RenameAnalyzeUtil.LocalAnalyzePackage[1];
        analyzePackages[current] = analyzePackage = this.fRenameLocalVariableProcessor.getLocalAnalyzePackage();
        TextEdit[] textEditArray = analyzePackage.fOccurenceEdits;
        int n = analyzePackage.fOccurenceEdits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit occurenceEdit = textEditArray[n2];
            this.addTextEdit(this.fChangeManager.get(cu), newName, occurenceEdit);
            ++n2;
        }
        if (!this.fIsCompactConstructor) {
            status.merge(RenameAnalyzeUtil.analyzeLocalRenames(analyzePackages, this.fChangeManager.get(cu), this.fCompUnit, false));
        } else {
            status.merge(RenameAnalyzeUtil.analyzeCompactConstructorLocalRenames(analyzePackages, this.fChangeManager.get(cu), this.fCompUnit, false));
        }
    }

    private void addFieldAccessorOccurrences(IProgressMonitor pm, String editName, String newAccessorName, RefactoringStatus status) throws CoreException {
        Assert.isTrue((boolean)this.fField.exists());
        String fieldName = this.fField.getElementName();
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fField.getDeclaringType());
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.getCurrentElementName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        SearchPattern searchPattern = this.createSearchPattern();
        if (searchPattern == null) {
            return;
        }
        SearchResultGroup[] result = RefactoringSearchEngine.search(searchPattern, scope, new CuCollectingSearchRequestor(binaryRefs), pm, status);
        binaryRefs.addErrorIfNecessary(status);
        SearchResultGroup[] searchResultGroupArray = result = this.filterAccessorMethods(result, false);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup groupedResult = searchResultGroupArray[n2];
            ICompilationUnit cu = groupedResult.getCompilationUnit();
            if (cu != null) {
                SearchMatch[] results;
                SearchMatch[] searchMatchArray = results = groupedResult.getSearchResults();
                int n3 = results.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch searchResult = searchMatchArray[n4];
                    ReplaceEdit edit = new ReplaceEdit(searchResult.getOffset(), fieldName.length(), newAccessorName);
                    this.addTextEdit(this.fChangeManager.get(cu), editName, (TextEdit)edit);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addTextMatches(IProgressMonitor pm) throws CoreException {
        TextMatchUpdater.perform(pm, this.createRefactoringScope(), this, this.fChangeManager, this.fReferences);
    }

    private void assignField(IField field) {
        this.fField = field;
        this.fIsRecordComponent = false;
        if (this.fField != null) {
            IType parent = this.fField.getDeclaringType();
            try {
                if (parent != null && parent.isRecord() && !Flags.isStatic((int)this.fField.getFlags())) {
                    this.fIsRecordComponent = true;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        newWorkingCopies = null;
        newWCOwner = new WorkingCopyOwner(){};
        try {
            block6: {
                block5: {
                    pm.beginTask("", 2);
                    result = new RefactoringStatus();
                    oldReferences = this.fReferences;
                    compilationUnitsToModify = new ArrayList<ICompilationUnit>();
                    if (!this.fIsComposite) break block5;
                    var10_7 = oldReferences;
                    var9_8 = oldReferences.length;
                    var8_9 = 0;
                    if (true) ** GOTO lbl22
                }
                compilationUnitsToModify.addAll(Arrays.asList(this.fChangeManager.getAllCompilationUnits()));
                break block6;
                do {
                    oldReference = var10_7[var8_9];
                    compilationUnitsToModify.add(oldReference.getCompilationUnit());
                    ++var8_9;
lbl22:
                    // 2 sources

                } while (var8_9 < var9_8);
                compilationUnitsToModify.add(this.fField.getCompilationUnit());
            }
            newWorkingCopies = RenameAnalyzeUtil.createNewWorkingCopies(compilationUnitsToModify.toArray(new ICompilationUnit[compilationUnitsToModify.size()]), this.fChangeManager, newWCOwner, new SubProgressMonitor(pm, 1));
            newReferences = this.getNewReferences((IProgressMonitor)new SubProgressMonitor(pm, 1), result, newWCOwner, newWorkingCopies);
            result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, oldReferences, newReferences, this.getNewElementName()));
            var12_11 = result;
            return var12_11;
        }
        finally {
            pm.done();
            if (newWorkingCopies == null) return var12_11;
            var16_12 = newWorkingCopies;
            var15_14 = newWorkingCopies.length;
            var14_16 = 0;
            ** while (var14_16 < var15_14)
        }
lbl-1000:
        // 1 sources

        {
            newWorkingCopy = var16_12[var14_16];
            newWorkingCopy.discardWorkingCopy();
            ++var14_16;
            continue;
        }
lbl42:
        // 1 sources

        return var12_11;
    }

    private SearchResultGroup[] getNewReferences(IProgressMonitor pm, RefactoringStatus status, WorkingCopyOwner owner, ICompilationUnit[] newWorkingCopies) throws CoreException {
        pm.beginTask("", 2);
        ICompilationUnit declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(newWorkingCopies, this.fField.getCompilationUnit());
        if (declaringCuWorkingCopy == null) {
            return new SearchResultGroup[0];
        }
        IField field = this.getFieldInWorkingCopy(declaringCuWorkingCopy, this.getNewElementName());
        if (field == null || !field.exists()) {
            return new SearchResultGroup[0];
        }
        CollectingSearchRequestor requestor = null;
        if (this.fDelegateUpdating && RefactoringAvailabilityTesterCore.isDelegateCreationAvailable(this.getField())) {
            final IField oldField = this.getFieldInWorkingCopy(declaringCuWorkingCopy, this.getCurrentElementName());
            requestor = new CollectingSearchRequestor(){

                @Override
                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!oldField.equals(match.getElement())) {
                        super.acceptSearchMatch(match);
                    }
                }
            };
        } else {
            requestor = new CollectingSearchRequestor();
        }
        SearchPattern newPattern = SearchPattern.createPattern((IJavaElement)field, (int)2);
        if (newPattern == null) {
            return new SearchResultGroup[0];
        }
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fField, true, true);
        return RefactoringSearchEngine.search(newPattern, owner, scope, requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
    }

    private IField getFieldInWorkingCopy(ICompilationUnit newWorkingCopyOfDeclaringCu, String elementName) {
        IType type = this.fField.getDeclaringType();
        IType typeWc = (IType)JavaModelUtil.findInCompilationUnit(newWorkingCopyOfDeclaringCu, (IJavaElement)type);
        if (typeWc == null) {
            return null;
        }
        return typeWc.getField(elementName);
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 8) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.field");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.assignField((IField)element);
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.parseBoolean(references);
        String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.parseBoolean(matches);
        String getters = extended.getAttribute(ATTRIBUTE_RENAME_GETTER);
        this.fRenameGetter = getters != null ? Boolean.parseBoolean(getters) : false;
        String setters = extended.getAttribute(ATTRIBUTE_RENAME_SETTER);
        this.fRenameSetter = setters != null ? Boolean.parseBoolean(setters) : false;
        String delegate = extended.getAttribute(ATTRIBUTE_DELEGATE);
        this.fDelegateUpdating = delegate != null ? Boolean.parseBoolean(delegate) : false;
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        this.fDelegateDeprecation = deprecate != null ? Boolean.parseBoolean(deprecate) : false;
        return new RefactoringStatus();
    }

    @Override
    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateFieldCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateFieldCreator_keep_original_renamed_singular;
    }

    private RenameLocalVariableProcessor createLocalRenameProcessor(ILocalVariable local, String newName, CompilationUnit compilationUnit) {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(local, this.fChangeManager, compilationUnit, CATEGORY_LOCAL_RENAME);
        processor.setNewElementName(newName);
        processor.setUpdateReferences(this.getUpdateReferences());
        return processor;
    }
}

