/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.binary;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;

public class StubCreator {
    protected StringBuffer fBuffer;
    protected final boolean fStubInvisible;

    public StubCreator(boolean stubInvisible) {
        this.fStubInvisible = stubInvisible;
    }

    protected void appendEnumConstants(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        ArrayList<IField> list = new ArrayList<IField>(fields.length);
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (Flags.isEnum((int)field.getFlags())) {
                list.add(field);
            }
            ++n2;
        }
        int index = 0;
        while (index < list.size()) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(((IField)list.get(index)).getElementName());
            ++index;
        }
        this.fBuffer.append(";");
    }

    protected void appendExpression(String signature) {
        this.appendExpression(signature, false);
    }

    protected void appendExpression(String signature, boolean castNull) {
        switch (signature.charAt(0)) {
            case 'Z': {
                this.fBuffer.append("false");
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                this.fBuffer.append("0");
                break;
            }
            default: {
                if (castNull) {
                    this.fBuffer.append("(");
                    this.fBuffer.append(Signature.toString((String)signature));
                    this.fBuffer.append(")");
                }
                this.fBuffer.append("null");
            }
        }
    }

    protected void appendFieldDeclaration(IField field) throws JavaModelException {
        this.appendFlags((IMember)field);
        this.fBuffer.append(" ");
        String signature = field.getTypeSignature();
        this.fBuffer.append(Signature.toString((String)signature));
        this.fBuffer.append(" ");
        this.fBuffer.append(field.getElementName());
        if (Flags.isFinal((int)field.getFlags())) {
            this.fBuffer.append("=");
            this.appendExpression(signature);
        }
        this.fBuffer.append(";");
    }

    protected void appendFlags(IMember member) throws JavaModelException {
        if (member instanceof IAnnotatable) {
            IAnnotation[] annotations = ((IAnnotatable)member).getAnnotations();
            HashSet<IAnnotation> annotationSet = new HashSet<IAnnotation>();
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (!annotationSet.contains(annotation)) {
                    this.appendAnnotation(annotation);
                    annotationSet.add(annotation);
                }
                ++n2;
            }
            annotationSet.clear();
            annotationSet = null;
        }
        int flags = member.getFlags();
        int kind = member.getElementType();
        if (kind == 7) {
            flags &= 0xFFFFFFDF;
            IType type = (IType)member;
            if (!type.isMember()) {
                flags &= 0xFFFFFFFD;
            }
            if (Flags.isEnum((int)flags)) {
                flags &= 0xFFFFFBFF;
            }
        }
        if (Flags.isEnum((int)flags)) {
            flags &= 0xFFFFFFEF;
        }
        if (kind == 9) {
            flags &= 0xFFFFFF7F;
            flags &= 0xFFFFFFBF;
        }
        if (flags != 0) {
            this.fBuffer.append(Flags.toString((int)flags));
        }
    }

    private void appendAnnotation(IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] memberValuePairs;
        String name = annotation.getElementName();
        if (!this.fStubInvisible && name.startsWith("sun.") || name.startsWith("jdk.internal.")) {
            return;
        }
        this.fBuffer.append('@');
        this.fBuffer.append(name.replace('$', '.'));
        this.fBuffer.append('(');
        IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
        int n = memberValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            this.fBuffer.append(pair.getMemberName());
            this.fBuffer.append('=');
            this.appendAnnotationValue(pair.getValue(), pair.getValueKind());
            this.fBuffer.append(',');
            ++n2;
        }
        if (memberValuePairs.length > 0) {
            this.fBuffer.deleteCharAt(this.fBuffer.length() - 1);
        }
        this.fBuffer.append(')').append('\n');
    }

    private void appendAnnotationValue(Object value, int valueKind) throws JavaModelException {
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            this.fBuffer.append('{');
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.appendAnnotationValue(object, valueKind);
                this.fBuffer.append(',');
                ++n2;
            }
            if (objects.length > 0) {
                this.fBuffer.deleteCharAt(this.fBuffer.length() - 1);
            }
            this.fBuffer.append('}');
        } else {
            switch (valueKind) {
                case 10: {
                    this.appendAnnotation((IAnnotation)value);
                    break;
                }
                case 9: {
                    this.fBuffer.append('\"').append(value).append('\"');
                    break;
                }
                default: {
                    this.fBuffer.append(value);
                }
            }
        }
    }

    protected void appendMembers(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            IJavaElement[] iJavaElementArray = type.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    block14: {
                        boolean skip;
                        int count;
                        boolean stub;
                        int flags;
                        IMember child;
                        block15: {
                            block13: {
                                IJavaElement childJavaElement = iJavaElementArray[n2];
                                child = (IMember)childJavaElement;
                                flags = child.getFlags();
                                boolean isPrivate = Flags.isPrivate((int)flags);
                                boolean isDefault = !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !isPrivate;
                                boolean bl = stub = this.fStubInvisible || !isPrivate && !isDefault;
                                if (!(child instanceof IType)) break block13;
                                if (stub || "java.lang.invoke.MethodHandle".equals(type.getFullyQualifiedName()) || "java.util.concurrent.ConcurrentHashMap$CollectionView".equals(((IType)child).getFullyQualifiedName())) {
                                    this.appendTypeDeclaration((IType)child, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                break block14;
                            }
                            if (!(child instanceof IField)) break block15;
                            if (stub && !Flags.isEnum((int)flags) && !Flags.isSynthetic((int)flags)) {
                                this.appendFieldDeclaration((IField)child);
                            }
                            break block14;
                        }
                        if (!(child instanceof IMethod)) break block14;
                        IMethod method = (IMethod)child;
                        String name = method.getElementName();
                        if (method.getDeclaringType().isEnum() && ((count = method.getNumberOfParameters()) == 0 && "values".equals(name) || count == 1 && "valueOf".equals(name) && "Ljava.lang.String;".equals(method.getParameterTypes()[0]) || method.isConstructor())) break block16;
                        boolean bl = skip = !stub || "<clinit>".equals(name);
                        if (method.isConstructor()) {
                            skip = false;
                        }
                        boolean bl2 = skip = skip || Flags.isSynthetic((int)flags) || Flags.isBridge((int)flags);
                        if (!skip) {
                            this.appendMethodDeclaration(method);
                        }
                    }
                    this.fBuffer.append("\n");
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void appendMethodBody(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            IType declaringType = method.getDeclaringType();
            String superSignature = declaringType.getSuperclassTypeSignature();
            if (superSignature != null) {
                superSignature = Signature.getTypeErasure((String)superSignature);
                IType superclass = declaringType.getJavaProject().findType(Signature.getSignatureQualifier((String)superSignature), Signature.getSignatureSimpleName((String)superSignature));
                if (superclass != null) {
                    IMethod[] superMethods = superclass.getMethods();
                    TreeMap<Integer, ArrayList<IMethod>> superConstructorsByParamCount = new TreeMap<Integer, ArrayList<IMethod>>();
                    boolean multi = false;
                    IMethod superConstructor = null;
                    IMethod[] iMethodArray = superMethods;
                    int n = superMethods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod superMethod = iMethodArray[n2];
                        if (superMethod.isConstructor() && !Flags.isPrivate((int)superMethod.getFlags()) && (!Flags.isPackageDefault((int)superMethod.getFlags()) || declaringType.getPackageFragment().equals(superclass.getPackageFragment()))) {
                            int paramCount = superMethod.getNumberOfParameters();
                            if (paramCount == 0) {
                                superConstructor = superMethod;
                                break;
                            }
                            ArrayList<IMethod> constructors = (ArrayList<IMethod>)superConstructorsByParamCount.get(paramCount);
                            if (constructors == null) {
                                constructors = new ArrayList<IMethod>();
                                superConstructorsByParamCount.put(paramCount, constructors);
                            }
                            constructors.add(superMethod);
                        }
                        ++n2;
                    }
                    if (superConstructor == null && superConstructorsByParamCount.size() > 0) {
                        block1: for (List constructors : superConstructorsByParamCount.values()) {
                            for (IMethod constructor : constructors) {
                                if (constructor.getExceptionTypes().length == 0) {
                                    superConstructor = constructor;
                                    boolean bl = multi = constructors.size() != 1;
                                    if (!multi) break block1;
                                    continue block1;
                                }
                                if (superConstructor != null) continue;
                                superConstructor = constructor;
                                boolean bl = multi = constructors.size() != 1;
                            }
                        }
                        if (superConstructor == null) {
                            superConstructor = (IMethod)((List)superConstructorsByParamCount.values().iterator().next()).get(0);
                            multi = true;
                        }
                    }
                    if (superConstructor != null) {
                        String[] superParameters = superConstructor.getParameterTypes();
                        int paramLength = superParameters.length;
                        this.fBuffer.append("super(");
                        if (paramLength != 0) {
                            int index = 0;
                            while (index < paramLength) {
                                if (index > 0) {
                                    this.fBuffer.append(",");
                                }
                                this.appendExpression(superParameters[index], multi);
                                ++index;
                            }
                        }
                        this.fBuffer.append(");");
                    }
                }
            }
        } else {
            String returnType = method.getReturnType();
            if (!"V".equals(returnType)) {
                this.fBuffer.append("return ");
                this.appendExpression(returnType);
                this.fBuffer.append(";");
            }
        }
    }

    protected void appendMethodDeclaration(IMethod method) throws JavaModelException {
        this.appendFlags((IMember)method);
        this.fBuffer.append(" ");
        ITypeParameter[] parameters = method.getTypeParameters();
        if (parameters.length > 0) {
            this.appendTypeParameters(parameters);
            this.fBuffer.append(" ");
        }
        String returnType = method.getReturnType();
        if (!method.isConstructor()) {
            this.fBuffer.append(Signature.toString((String)returnType));
            this.fBuffer.append(" ");
        }
        this.fBuffer.append(method.getElementName());
        this.fBuffer.append("(");
        String[] parameterTypes = method.getParameterTypes();
        int flags = method.getFlags();
        boolean varargs = Flags.isVarargs((int)flags);
        int parameterLength = parameterTypes.length;
        int index = 0;
        while (index < parameterLength) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)parameterTypes[index]));
            if (varargs && index == parameterLength - 1) {
                int length = this.fBuffer.length();
                if (length >= 2 && this.fBuffer.indexOf("[]", length - 2) >= 0) {
                    this.fBuffer.setLength(length - 2);
                }
                this.fBuffer.append("...");
            }
            this.fBuffer.append(" ");
            this.appendMethodParameterName(method, index);
            ++index;
        }
        this.fBuffer.append(")");
        String[] exceptionTypes = method.getExceptionTypes();
        int exceptionLength = exceptionTypes.length;
        if (exceptionLength > 0) {
            this.fBuffer.append(" throws ");
        }
        int index2 = 0;
        while (index2 < exceptionLength) {
            if (index2 > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)exceptionTypes[index2]));
            ++index2;
        }
        if (Flags.isAnnnotationDefault((int)flags)) {
            this.fBuffer.append(" default ");
            IMemberValuePair pair = method.getDefaultValue();
            this.appendAnnotationValue(pair.getValue(), pair.getValueKind());
        }
        if (Flags.isAbstract((int)flags) || Flags.isNative((int)flags)) {
            this.fBuffer.append(";");
        } else {
            this.fBuffer.append("{\n");
            this.appendMethodBody(method);
            this.fBuffer.append("}");
        }
    }

    protected void appendMethodParameterName(IMethod method, int index) {
        this.fBuffer.append("a");
        this.fBuffer.append(index);
    }

    protected void appendSuperInterfaceTypes(IType type) throws JavaModelException {
        String[] signatures = type.getSuperInterfaceTypeSignatures();
        if (signatures.length > 0) {
            if (type.isInterface()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" implements ");
            }
        }
        int index = 0;
        while (index < signatures.length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)signatures[index]));
            ++index;
        }
    }

    protected void appendTopLevelType(IType type, IProgressMonitor subProgressMonitor) throws JavaModelException {
        String packageName = type.getPackageFragment().getElementName();
        if (packageName.length() > 0) {
            this.fBuffer.append("package ");
            this.fBuffer.append(packageName);
            this.fBuffer.append(";\n");
        }
        this.appendTypeDeclaration(type, subProgressMonitor);
    }

    protected void appendTypeDeclaration(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            if (type.isAnnotation()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" @interface ");
                this.fBuffer.append(type.getElementName());
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isInterface()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" interface ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isClass()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" class ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                String signature = type.getSuperclassTypeSignature();
                if (signature != null) {
                    this.fBuffer.append(" extends ");
                    this.fBuffer.append(Signature.toString((String)signature));
                }
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isEnum()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" enum ");
                this.fBuffer.append(type.getElementName());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendEnumConstants(type);
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void appendTypeParameters(ITypeParameter[] parameters) throws JavaModelException {
        int length = parameters.length;
        if (length > 0) {
            this.fBuffer.append("<");
        }
        int index = 0;
        while (index < length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            ITypeParameter parameter = parameters[index];
            this.fBuffer.append(parameter.getElementName());
            String[] bounds = parameter.getBounds();
            int size = bounds.length;
            if (size > 0) {
                this.fBuffer.append(" extends ");
            }
            int offset = 0;
            while (offset < size) {
                if (offset > 0) {
                    this.fBuffer.append(" & ");
                }
                this.fBuffer.append(bounds[offset]);
                ++offset;
            }
            ++index;
        }
        if (length > 0) {
            this.fBuffer.append(">");
        }
    }

    public String createStub(IType topLevelType, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue((boolean)Checks.isTopLevel(topLevelType));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fBuffer = new StringBuffer(2046);
        this.appendTopLevelType(topLevelType, monitor);
        String result = this.fBuffer.toString();
        this.fBuffer = null;
        return result;
    }
}

