/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class ReturnExpressionFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        ReturnExpressionFinder finder = new ReturnExpressionFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new ReturnExpressionFixCore(FixMessages.ReturnExpressionFix_description, compilationUnit, ops);
    }

    protected ReturnExpressionFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class ReturnExpressionCStyleArrayOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ReturnStatement visited;
        private final VariableDeclarationStatement variableDeclarationStatement;
        private final ArrayInitializer returnExpression;
        private final VariableDeclarationFragment varDeclFrag;

        public ReturnExpressionCStyleArrayOperation(ReturnStatement visited, VariableDeclarationStatement variableDeclarationStatement, ArrayInitializer returnExpression, VariableDeclarationFragment varDeclFrag) {
            this.visited = visited;
            this.variableDeclarationStatement = variableDeclarationStatement;
            this.returnExpression = returnExpression;
            this.varDeclFrag = varDeclFrag;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ReturnExpressionCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            ArrayType newArrayType = this.visited.getAST().newArrayType((Type)rewrite.createCopyTarget((ASTNode)this.variableDeclarationStatement.getType()), this.varDeclFrag.getExtraDimensions());
            ArrayCreation newArrayCreation = ast.newArrayCreation();
            newArrayCreation.setType(newArrayType);
            newArrayCreation.setInitializer(ASTNodes.createMoveTarget(rewrite, this.returnExpression));
            ReturnStatement newReturnStatement = ast.newReturnStatement();
            newReturnStatement.setExpression((Expression)newArrayCreation);
            rewrite.remove((ASTNode)this.variableDeclarationStatement, group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newReturnStatement, group);
        }
    }

    public static final class ReturnExpressionFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public ReturnExpressionFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(Block visited) {
            ReturnStatementVisitor returnStatementVisitor = new ReturnStatementVisitor(visited);
            visited.accept((ASTVisitor)returnStatementVisitor);
            return returnStatementVisitor.result;
        }

        final class ReturnStatementVisitor
        extends ASTVisitor {
            private final Block startNode;
            private boolean result = true;

            public ReturnStatementVisitor(Block startNode) {
                this.startNode = startNode;
            }

            public boolean visit(Block visited) {
                return this.startNode == visited;
            }

            public boolean visit(ReturnStatement visited) {
                if (this.result) {
                    Statement previousSibling = ASTNodes.getPreviousSibling((Statement)visited);
                    if (previousSibling instanceof VariableDeclarationStatement) {
                        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)previousSibling;
                        VariableDeclarationFragment fragment = ASTNodes.getUniqueFragment((Statement)variableDeclarationStatement);
                        if (fragment != null && ASTNodes.isSameLocalVariable(visited.getExpression(), (Expression)fragment.getName())) {
                            Expression returnExpression = fragment.getInitializer();
                            if (returnExpression instanceof ArrayInitializer) {
                                return this.maybeRemoveArrayVariable(visited, variableDeclarationStatement, (ArrayInitializer)returnExpression);
                            }
                            ReturnExpressionFinder.this.fResult.add(new ReturnExpressionOperation(visited, (Statement)variableDeclarationStatement, returnExpression));
                            this.result = false;
                            return false;
                        }
                    } else {
                        Assignment assignment = ASTNodes.asExpression(previousSibling, Assignment.class);
                        if (ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && assignment.getLeftHandSide() instanceof Name && ASTNodes.isSameLocalVariable(visited.getExpression(), assignment.getLeftHandSide()) && !this.isUsedAfterReturn((IVariableBinding)((Name)assignment.getLeftHandSide()).resolveBinding(), (ASTNode)visited)) {
                            ReturnExpressionFinder.this.fResult.add(new ReturnExpressionOperation(visited, previousSibling, assignment.getRightHandSide()));
                            this.result = false;
                            return false;
                        }
                    }
                }
                return true;
            }

            private boolean isUsedAfterReturn(IVariableBinding varToSearch, ASTNode scopeNode) {
                TryStatement tryStatement = ASTNodes.getTypedAncestor(scopeNode, TryStatement.class);
                if (tryStatement == null) {
                    return false;
                }
                if (tryStatement.getFinally() != null) {
                    VarDefinitionsUsesVisitor variableUseVisitor;
                    try {
                        variableUseVisitor = new VarDefinitionsUsesVisitor(varToSearch, (ASTNode)tryStatement.getFinally(), true);
                    }
                    catch (Exception e) {
                        return true;
                    }
                    if (!variableUseVisitor.getReads().isEmpty()) {
                        return true;
                    }
                }
                return this.isUsedAfterReturn(varToSearch, (ASTNode)tryStatement);
            }

            private boolean maybeRemoveArrayVariable(ReturnStatement visited, VariableDeclarationStatement variableDeclarationStatement, ArrayInitializer returnExpression) {
                Type varType = variableDeclarationStatement.getType();
                VariableDeclarationFragment varDeclFrag = (VariableDeclarationFragment)variableDeclarationStatement.fragments().get(0);
                if (varType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)varType;
                    if (varDeclFrag.getExtraDimensions() > 0) {
                        return true;
                    }
                    ReturnExpressionFinder.this.fResult.add(new ReturnExpressionJavaStyleArrayOperation(visited, variableDeclarationStatement, returnExpression, arrayType));
                } else {
                    ReturnExpressionFinder.this.fResult.add(new ReturnExpressionCStyleArrayOperation(visited, variableDeclarationStatement, returnExpression, varDeclFrag));
                }
                this.result = false;
                return false;
            }
        }
    }

    private static class ReturnExpressionJavaStyleArrayOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ReturnStatement visited;
        private final VariableDeclarationStatement variableDeclarationStatement;
        private final ArrayInitializer returnExpression;
        private final ArrayType arrayType;

        public ReturnExpressionJavaStyleArrayOperation(ReturnStatement visited, VariableDeclarationStatement variableDeclarationStatement, ArrayInitializer returnExpression, ArrayType arrayType) {
            this.visited = visited;
            this.variableDeclarationStatement = variableDeclarationStatement;
            this.returnExpression = returnExpression;
            this.arrayType = arrayType;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ReturnExpressionCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            ArrayCreation newArrayCreation = ast.newArrayCreation();
            ArrayType newArrayType = this.visited.getAST().newArrayType((Type)rewrite.createCopyTarget((ASTNode)this.arrayType.getElementType()), this.arrayType.getDimensions());
            newArrayCreation.setType(newArrayType);
            newArrayCreation.setInitializer(ASTNodes.createMoveTarget(rewrite, this.returnExpression));
            ReturnStatement newReturnStatement = ast.newReturnStatement();
            newReturnStatement.setExpression((Expression)newArrayCreation);
            rewrite.remove((ASTNode)this.variableDeclarationStatement, group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newReturnStatement, group);
        }
    }

    private static class ReturnExpressionOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ReturnStatement visited;
        private final Statement previousSibling;
        private final Expression returnExpression;

        public ReturnExpressionOperation(ReturnStatement visited, Statement previousSibling, Expression returnExpression) {
            this.visited = visited;
            this.previousSibling = previousSibling;
            this.returnExpression = returnExpression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ReturnExpressionCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            rewrite.remove((ASTNode)this.previousSibling, group);
            ReturnStatement newReturnStatement = ast.newReturnStatement();
            newReturnStatement.setExpression(ASTNodes.createMoveTarget(rewrite, this.returnExpression));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newReturnStatement, group);
        }
    }
}

