/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ResponseStore<T> {
    private AtomicLong idSeed = new AtomicLong(0L);
    private Map<Long, ResponseItem<T>> responseCache;

    public ResponseStore() {
        this.responseCache = new ConcurrentHashMap<Long, ResponseItem<T>>();
    }

    public ResponseStore(final int maxSize) {
        this.responseCache = Collections.synchronizedMap(new LinkedHashMap<Long, ResponseItem<T>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return maxSize > 0 && this.size() > maxSize;
            }
        });
    }

    public ResponseItem<T> createResponse() {
        return new ResponseItem(this.idSeed.getAndIncrement());
    }

    public ResponseItem<T> get(Long id) {
        return this.responseCache.get(id);
    }

    public void store(ResponseItem<T> response) {
        if (response != null) {
            this.responseCache.put(response.getId(), response);
        }
    }

    public void delete(ResponseItem<T> response) {
        if (response != null) {
            this.responseCache.remove(response.getId());
        }
    }

    public void clear() {
        this.responseCache.clear();
    }

    public boolean isEmpty() {
        return this.responseCache.isEmpty();
    }

    public static class ResponseItem<T> {
        private Long id;
        private List<T> proposals;

        public ResponseItem(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public List<T> getProposals() {
            return this.proposals;
        }

        public void setProposals(List<T> proposals) {
            this.proposals = proposals;
        }
    }
}

