/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import com.microsoft.gradle.bs.importer.Utils;
import com.microsoft.gradle.bs.importer.model.NamedPipeConnectionException;
import com.microsoft.gradle.bs.importer.model.Telemetry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class NamedPipeStream {
    private StreamProvider provider;
    private final int MAX_ATTEMPTS = 30;

    public StreamProvider getSelectedStream() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    private StreamProvider createProvider() {
        PipeStreamProvider pipeStreamProvider = new PipeStreamProvider();
        pipeStreamProvider.initializeNamedPipe();
        return pipeStreamProvider;
    }

    public InputStream getInputStream() throws IOException {
        return this.getSelectedStream().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getSelectedStream().getOutputStream();
    }

    public class NamedPipeInputStream
    extends InputStream {
        private ReadableByteChannel unixChannel;
        private AsynchronousFileChannel winChannel;
        private ByteBuffer buffer = ByteBuffer.allocate(1024);
        private int readyBytes = 0;

        public NamedPipeInputStream(ReadableByteChannel channel) {
            this.unixChannel = channel;
        }

        public NamedPipeInputStream(AsynchronousFileChannel channel) {
            this.winChannel = channel;
        }

        @Override
        public int read() throws IOException {
            block4: {
                if (this.buffer.position() < this.readyBytes) {
                    return this.buffer.get() & 0xFF;
                }
                this.buffer.clear();
                this.readyBytes = this.winChannel != null ? this.winChannel.read(this.buffer, 0L).get().intValue() : this.unixChannel.read(this.buffer);
                if (this.readyBytes != -1) break block4;
                return -1;
            }
            try {
                this.buffer.flip();
                return this.buffer.get() & 0xFF;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    public class NamedPipeOutputStream
    extends OutputStream {
        private WritableByteChannel unixChannel;
        private AsynchronousFileChannel winChannel;
        private ByteBuffer buffer = ByteBuffer.allocate(1);

        public NamedPipeOutputStream(WritableByteChannel channel) {
            this.unixChannel = channel;
        }

        public NamedPipeOutputStream(AsynchronousFileChannel channel) {
            this.winChannel = channel;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.clear();
            this.buffer.put((byte)b);
            this.buffer.position(0);
            if (this.winChannel != null) {
                Future<Integer> result = this.winChannel.write(this.buffer, 0L);
                try {
                    result.get();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                this.unixChannel.write(this.buffer);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            int blocks = b.length / 1024;
            int writeBytes = 0;
            int i = 0;
            while (i <= blocks) {
                int offset = i * 1024;
                int length = Math.min(b.length - writeBytes, 1024);
                if (length <= 0) break;
                writeBytes += length;
                ByteBuffer buffer = ByteBuffer.wrap(b, offset, length);
                if (this.winChannel != null) {
                    Future<Integer> result = this.winChannel.write(buffer, 0L);
                    try {
                        result.get();
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                } else {
                    this.unixChannel.write(buffer);
                }
                ++i;
            }
        }
    }

    protected final class PipeStreamProvider
    implements StreamProvider {
        private InputStream input;
        private OutputStream output;

        protected PipeStreamProvider() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.input;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.output;
        }

        private void initializeNamedPipe() {
            String pathName = this.generateRandomPipeName();
            this.sendImporterPipeName(pathName);
            File pipeFile = new File(pathName);
            int attempts = 0;
            while (attempts < 30) {
                try {
                    this.attemptConnection(pipeFile);
                    break;
                }
                catch (IOException e) {
                    this.sleep(e, attempts);
                    ++attempts;
                }
            }
            Telemetry telemetry = new Telemetry("importerConnectAttempts", attempts);
            Utils.sendTelemetry(JavaLanguageServerPlugin.getProjectsManager().getConnection(), telemetry);
            if (attempts == 30) {
                throw new NamedPipeConnectionException(String.format("Failed to connect to extension, Max attempts: %d", 30));
            }
        }

        private static String generateRandomHex(int numBytes) {
            SecureRandom random = new SecureRandom();
            byte[] bytes = new byte[numBytes];
            random.nextBytes(bytes);
            StringBuilder hexString = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                hexString.append(String.format("%02x", b));
                ++n2;
            }
            return hexString.toString();
        }

        private String generateRandomPipeName() {
            if (System.getProperty("os.name").startsWith("Windows")) {
                return Paths.get("\\\\.\\pipe\\", PipeStreamProvider.generateRandomHex(16) + "-sock").toString();
            }
            int randomLength = 32;
            int fixedLength = ".sock".length();
            String tmpDir = System.getenv("XDG_RUNTIME_DIR");
            if (tmpDir == null || tmpDir.isEmpty()) {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            int limit = 0;
            if (System.getProperty("os.name").startsWith("Mac")) {
                limit = 103;
            } else if (System.getProperty("os.name").startsWith("Linux")) {
                limit = 107;
            }
            if (limit != 0) {
                randomLength = Math.min(limit - tmpDir.length() - fixedLength, randomLength);
            }
            if (randomLength < 16) {
                tmpDir = "/tmp/";
                JavaLanguageServerPlugin.logInfo((String)"length of random pipe name too long, using /tmp/ as tmpDir");
            }
            String randomSuffix = PipeStreamProvider.generateRandomHex(randomLength / 2);
            return Paths.get(tmpDir, randomSuffix + ".sock").toString();
        }

        private void sendImporterPipeName(String pipeName) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().sendNotification("_gradle.onWillImporterConnect", new Object[]{pipeName});
        }

        private void attemptConnection(File pipeFile) throws IOException {
            if (PipeStreamProvider.isWindows()) {
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(pipeFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                this.input = new NamedPipeInputStream(channel);
                this.output = new NamedPipeOutputStream(channel);
            } else {
                UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(pipeFile.toPath());
                SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);
                channel.connect(socketAddress);
                this.input = new NamedPipeInputStream(channel);
                this.output = new NamedPipeOutputStream(channel);
            }
        }

        private void sleep(IOException e, int attempts) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread interrupted while handling connection failure", ie);
            }
        }

        protected static boolean isWindows() {
            return "win32".equals(Platform.getOS());
        }
    }

    static interface StreamProvider {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;
    }
}

