/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import org.eclipse.jdt.core.CompletionProposal;

public final class SortTextHelper {
    public static final int CEILING = 999999999;
    public static final int MAX_RELEVANCE_VALUE = 99999999;

    private SortTextHelper() {
    }

    public static String convertRelevance(int relevance) {
        if (relevance > 99999999) {
            throw new IllegalArgumentException("Relevance must be lower than 100,000,000");
        }
        return String.valueOf(999999999 - Math.max(relevance, 0));
    }

    public static String computeSortText(CompletionProposal proposal) {
        int baseRelevance = proposal.getRelevance() * 16;
        switch (proposal.getKind()) {
            case 4: {
                return SortTextHelper.convertRelevance(baseRelevance + 1);
            }
            case 3: {
                return SortTextHelper.convertRelevance(baseRelevance + 2);
            }
            case 1: 
            case 9: 
            case 27: {
                return SortTextHelper.convertRelevance(baseRelevance + 3);
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 26: {
                return SortTextHelper.convertRelevance(baseRelevance + 4);
            }
            case 2: {
                return SortTextHelper.convertRelevance(baseRelevance + 5);
            }
            case 5: 
            case 10: {
                return SortTextHelper.convertRelevance(baseRelevance + 6);
            }
        }
        return SortTextHelper.convertRelevance(baseRelevance);
    }
}

