/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.UpdateProperty;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ConstantsForSystemPropertiesCleanUpCore
extends AbstractCleanUp {
    public ConstantsForSystemPropertiesCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public ConstantsForSystemPropertiesCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.system_property") && !this.computeFixSet().isEmpty();
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        EnumSet<UpdateProperty> computeFixSet = this.computeFixSet();
        if (!this.isEnabled("cleanup.system_property") || computeFixSet.isEmpty()) {
            return null;
        }
        LinkedHashSet operations = new LinkedHashSet();
        HashSet nodesprocessed = new HashSet();
        computeFixSet.forEach(i -> i.findOperations(compilationUnit, operations, nodesprocessed));
        if (operations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(FixMessages.ConstantsCleanUpFix_refactor, compilationUnit, operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    private EnumSet<UpdateProperty> computeFixSet() {
        EnumSet<UpdateProperty> fixSet = EnumSet.noneOf(UpdateProperty.class);
        if (this.isEnabled("cleanup.system_property_file_separator")) {
            fixSet.add(UpdateProperty.FILE_SEPARATOR);
        }
        if (this.isEnabled("cleanup.system_property_path_separator")) {
            fixSet.add(UpdateProperty.PATH_SEPARATOR);
        }
        if (this.isEnabled("cleanup.system_property_file_encoding")) {
            fixSet.add(UpdateProperty.FILE_ENCODING);
        }
        if (this.isEnabled("cleanup.system_property_line_separator")) {
            fixSet.add(UpdateProperty.LINE_SEPARATOR);
        }
        if (this.isEnabled("cleanup.system_property_boolean")) {
            fixSet.add(UpdateProperty.BOOLEAN_PROPERTY);
            fixSet.add(UpdateProperty.INTEGER_PROPERTY);
            fixSet.add(UpdateProperty.LONG_PROPERTY);
        }
        return fixSet;
    }

    @Override
    public String[] getStepDescriptions() {
        List<String> result = this.isEnabled("cleanup.system_property") ? this.computeFixSet().stream().map(e -> Messages.format(MultiFixMessages.ConstantsCleanUp_description, e.toString())).collect(Collectors.toList()) : Collections.emptyList();
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        StringBuilder sb = new StringBuilder();
        boolean isEnabled = this.isEnabled("cleanup.system_property");
        EnumSet<UpdateProperty> computeFixSet = this.computeFixSet();
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.FILE_SEPARATOR)) {
            sb.append("String fs = FileSystems.getDefault().getSeparator(); /* on JVM 1.6 this will be File.separator; */ \n");
        } else {
            sb.append("String fs = System.getProperty(\"file.separator\");\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.PATH_SEPARATOR)) {
            sb.append("String ps = File.pathSeparator;\n");
        } else {
            sb.append("String ps = System.getProperty(\"path.separator\");\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.LINE_SEPARATOR)) {
            sb.append("String ls = System.lineSeparator();\n");
        } else {
            sb.append("String ls = System.getProperty(\"line.separator\");\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.FILE_ENCODING)) {
            sb.append("String fe = Charset.defaultCharset().displayName();\n");
        } else {
            sb.append("String fe = System.getProperty(\"file.encoding\");\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.BOOLEAN_PROPERTY)) {
            sb.append("Boolean b = Boolean.getBoolean(\"arbitrarykey\");\n");
        } else {
            sb.append("Boolean b = Boolean.parseBoolean(System.getProperty(\"arbitrarykey\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.BOOLEAN_PROPERTY)) {
            sb.append("Boolean b2 = Boolean.getBoolean(\"arbitrarykey\");\n");
        } else {
            sb.append("Boolean b2 = Boolean.parseBoolean(System.getProperty(\"arbitrarykey\", \"false\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.INTEGER_PROPERTY)) {
            sb.append("Integer i = Integer.getInteger(\"arbitrarykey\");\n");
        } else {
            sb.append("Integer i = Integer.parseInt(System.getProperty(\"arbitrarykey\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.INTEGER_PROPERTY)) {
            sb.append("Integer i2 = Integer.getInteger(\"arbitrarykey\");\n");
        } else {
            sb.append("Integer i2 = Integer.parseInt(System.getProperty(\"arbitrarykey\",\"0\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.INTEGER_PROPERTY)) {
            sb.append("Integer i3 = Integer.getInteger(\"arbitrarykey\", 15);\n");
        } else {
            sb.append("Integer i3 = Integer.parseInt(System.getProperty(\"arbitrarykey\",\"15\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.LONG_PROPERTY)) {
            sb.append("Long l = Long.getLong(\"arbitrarykey\");\n");
        } else {
            sb.append("Long l = Long.parseLong(System.getProperty(\"arbitrarykey\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.LONG_PROPERTY)) {
            sb.append("Long l2 = Long.getLong(\"arbitrarykey\");\n");
        } else {
            sb.append("Long l2 = Long.parseLong(System.getProperty(\"arbitrarykey\" ,\"0\"));\n");
        }
        if (isEnabled && computeFixSet.contains((Object)UpdateProperty.LONG_PROPERTY)) {
            sb.append("Long l3 = Long.getLong(\"arbitrarykey\", 15);\n");
        } else {
            sb.append("Long l3 = Long.parseLong(System.getProperty(\"arbitrarykey\" ,\"15\"));\n");
        }
        return sb.toString();
    }
}

