/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class LambdaMethod
extends SourceMethod {
    private final int sourceStart;
    private final String[] parameterNameStrings;
    private final String returnTypeString;
    SourceMethodElementInfo elementInfo;
    private final String key;

    LambdaMethod(JavaElement parent, String name, String key, int sourceStart, String[] parameterTypes, String[] parameterNames, String returnType, SourceMethodElementInfo elementInfo) {
        super(parent, name, parameterTypes);
        this.sourceStart = sourceStart;
        this.parameterNameStrings = parameterNames;
        this.returnTypeString = returnType;
        this.elementInfo = elementInfo;
        this.key = key;
    }

    @Override
    public String getReturnType() throws JavaModelException {
        return this.returnTypeString;
    }

    @Override
    public String getSignature() throws JavaModelException {
        return Signature.createMethodSignature(this.parameterTypes, this.returnTypeString);
    }

    @Override
    public boolean isLambdaMethod() {
        return true;
    }

    @Override
    protected void closing(Object info) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void that;
        Object object = o;
        if (!(object instanceof LambdaMethod)) {
            return false;
        }
        LambdaMethod lambdaMethod = (LambdaMethod)object;
        LambdaMethod cfr_ignored_0 = (LambdaMethod)object;
        return super.equals(o) && this.sourceStart == that.sourceStart;
    }

    @Override
    protected int calculateHashCode() {
        return Util.combineHashCodes(super.calculateHashCode(), this.sourceStart);
    }

    @Override
    public SourceMethodElementInfo getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        return this.elementInfo;
    }

    public void getHandleMemento(StringBuilder buff, boolean serializeParent) {
        if (serializeParent) {
            ((LambdaExpression)this.getParent()).getHandleMemento(buff, true, false);
        }
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
        buff.append('!');
        buff.append(this.parameterTypes.length);
        int i = 0;
        int length = this.parameterTypes.length;
        while (i < length) {
            this.appendEscapedDelimiter(buff, '\"');
            this.escapeMementoName(buff, this.parameterTypes[i]);
            this.appendEscapedDelimiter(buff, '\"');
            this.escapeMementoName(buff, this.parameterNameStrings[i]);
            ++i;
        }
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.returnTypeString);
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.key);
        ILocalVariable[] arguments = this.elementInfo.arguments;
        int i2 = 0;
        int length2 = arguments.length;
        while (i2 < length2) {
            LocalVariable local = (LocalVariable)arguments[i2];
            local.getHandleMemento(buff, false);
            ++i2;
        }
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        this.getHandleMemento(buff, true);
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '&';
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public LambdaMethod resolved(Binding binding) {
        return this;
    }
}

