/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.syntaxserver;

import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.NameLookup;

class CompletionResultRequestor
extends JavaElementRequestor {
    protected ISearchRequestor requestor;
    protected Object unitToSkip;
    protected IJavaProject project;
    protected NameLookup nameLookup;
    protected boolean checkAccessRestrictions;

    public CompletionResultRequestor(ISearchRequestor requestor) {
        this.requestor = requestor;
        this.unitToSkip = null;
        this.project = null;
        this.nameLookup = null;
        this.checkAccessRestrictions = false;
    }

    public CompletionResultRequestor(ISearchRequestor requestor, ICompilationUnit unitToSkip, IJavaProject project, NameLookup nameLookup) {
        this.requestor = requestor;
        this.unitToSkip = unitToSkip;
        this.project = project;
        this.nameLookup = nameLookup;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true));
    }

    public void acceptInitializer(IInitializer initializer) {
    }

    public void acceptPackageFragment(IPackageFragment packageFragment) {
        this.requestor.acceptPackage(packageFragment.getElementName().toCharArray());
    }

    public void acceptModule(IModuleDescription module) {
        this.requestor.acceptModule(module.getElementName().toCharArray());
    }

    public void acceptType(IType type) {
        try {
            if (this.unitToSkip != null && this.unitToSkip.equals(type.getCompilationUnit())) {
                return;
            }
            char[] packageName = type.getPackageFragment().getElementName().toCharArray();
            if (type.isBinary()) {
                this.requestor.acceptType(packageName, type.getElementName().toCharArray(), null, 1, null);
            } else {
                this.requestor.acceptType(packageName, type.getElementName().toCharArray(), null, type.getFlags(), null);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

