/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.maven;

import com.microsoft.java.maven.ArtifactResult;
import com.microsoft.java.maven.MavenSearcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.UserInputSearchExpression;

class BaseClassSearcher
extends MavenSearcher {
    private LevenshteinDistance editDistanceCalculator = new LevenshteinDistance();

    public BaseClassSearcher(String contextId, String repositoryId, String indexPath) throws IOException {
        super(contextId, repositoryId, indexPath);
        this.indexerContext = this.indexer.createIndexingContext(contextId, repositoryId, null, new File(indexPath), null, null, true, true, this.indexers);
    }

    public Map<String, ArtifactResult> searchByClassName(String className) {
        if (this.indexerContext == null) {
            return new HashMap<String, ArtifactResult>();
        }
        Query q = this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression(String.valueOf(className) + "~"));
        BooleanQuery bq = new BooleanQuery.Builder().add(q, BooleanClause.Occur.MUST).build();
        try {
            List<ArtifactResult> result = this.search((Query)bq, className);
            HashMap<String, ArtifactResult> resultMap = new HashMap<String, ArtifactResult>();
            for (ArtifactResult r : result) {
                if (resultMap.containsKey(r.getFullClassName())) continue;
                resultMap.put(r.getFullClassName(), r);
            }
            return resultMap;
        }
        catch (IOException iOException) {
            return new HashMap<String, ArtifactResult>();
        }
    }

    public List<ArtifactResult> searchByIdentifier(String groupId, String artifactId) {
        Query query;
        if (this.indexerContext == null) {
            return new ArrayList<ArtifactResult>();
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (!groupId.equals("")) {
            query = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new UserInputSearchExpression(groupId));
            builder = builder.add(query, BooleanClause.Occur.MUST);
        }
        if (!artifactId.equals("")) {
            query = this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new UserInputSearchExpression(artifactId));
            builder = builder.add(query, BooleanClause.Occur.MUST);
        }
        BooleanQuery bq = builder.build();
        try {
            FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest((Query)bq, this.indexerContext));
            ArrayList<ArtifactResult> resultList = new ArrayList<ArtifactResult>();
            for (ArtifactInfo r : response.getResults()) {
                resultList.add(new ArtifactResult(r.getGroupId(), r.getArtifactId(), r.getVersion(), "", "", -1, -1));
            }
            return resultList;
        }
        catch (IOException iOException) {
            return new ArrayList<ArtifactResult>();
        }
    }

    private List<ArtifactResult> search(Query q, String queryClassname) throws IOException {
        FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest(q, this.indexerContext));
        ArrayList<ArtifactResult> resultList = new ArrayList<ArtifactResult>();
        for (ArtifactInfo r : response.getResults()) {
            String[] fullClassnameList;
            String[] stringArray = fullClassnameList = r.getClassNames().split("\n");
            int n = fullClassnameList.length;
            int n2 = 0;
            while (n2 < n) {
                String fullClassname = stringArray[n2];
                int matchKind = this.isMatch(fullClassname = fullClassname.substring(1).replaceAll("/", "."), queryClassname);
                if (matchKind == 1) {
                    resultList.add(new ArtifactResult(r.getGroupId(), r.getArtifactId(), r.getVersion(), fullClassname.substring(fullClassname.lastIndexOf(".") + 1), fullClassname, -1, 1));
                } else if (matchKind == 2) {
                    resultList.add(new ArtifactResult(r.getGroupId(), r.getArtifactId(), r.getVersion(), fullClassname.substring(fullClassname.lastIndexOf(".") + 1), fullClassname, -1, 2));
                }
                ++n2;
            }
        }
        return resultList;
    }

    private int isMatch(String fullClassName, String queryClassName) {
        String qc;
        String fc = fullClassName.substring(fullClassName.lastIndexOf(".") + 1).toLowerCase();
        String string = qc = queryClassName.indexOf(46) != -1 ? queryClassName.substring(queryClassName.lastIndexOf(".") + 1).toLowerCase() : queryClassName;
        if (fc.startsWith(qc)) {
            return 1;
        }
        if (fc.length() >= qc.length() && this.editDistanceCalculator.apply((CharSequence)fc, (CharSequence)qc) <= 2) {
            return 2;
        }
        return 0;
    }

    public Boolean turnOnIndexerContext() {
        if (this.indexerContext == null) {
            try {
                this.indexerContext = this.indexer.createIndexingContext(this.contextId, this.repositoryId, null, new File(this.indexPath), null, null, true, true, this.indexers);
                return true;
            }
            catch (IOException | IllegalArgumentException exception) {
                this.indexerContext = null;
                return false;
            }
        }
        return true;
    }

    public Boolean turnOffIndexerContext() {
        if (this.indexerContext == null) {
            return true;
        }
        try {
            this.indexer.closeIndexingContext(this.indexerContext, false);
            this.indexerContext = null;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

