/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameTypeParameterProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameTypeParameterProcessor";
    private Change fChange = null;
    private ITypeParameter fTypeParameter;
    private boolean fUpdateReferences = true;

    public RenameTypeParameterProcessor(ITypeParameter parameter) {
        this.fTypeParameter = parameter;
        if (parameter != null) {
            this.setNewElementName(parameter.getElementName());
        }
    }

    public RenameTypeParameterProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        status.merge(this.initialize(arguments));
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fTypeParameter, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fTypeParameter.getDeclaringMember().getCompilationUnit())};
    }

    @Override
    public int getSaveMode() {
        return 3;
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)context);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 5);
            monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
            status.merge(Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember()));
            monitor.worked(1);
            if (!status.hasFatalError()) {
                status.merge(this.checkNewElementName(this.getNewElementName()));
                monitor.worked(1);
                monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching);
                status.merge(this.createRenameChanges((IProgressMonitor)new SubProgressMonitor(monitor, 2)));
                monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                if (status.hasFatalError()) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        if (!this.fTypeParameter.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_deleted, BasicElementLabels.getFileName((ITypeRoot)this.fTypeParameter.getDeclaringMember().getCompilationUnit())));
        }
        return Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember());
    }

    @Override
    public RefactoringStatus checkNewElementName(String name) throws CoreException {
        IMember member;
        Assert.isNotNull((Object)name);
        RefactoringStatus result = Checks.checkTypeParameterName(name, (IJavaElement)this.fTypeParameter);
        if (Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.RenameTypeParameterRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fTypeParameter, name)) {
            result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_another_name);
        }
        if ((member = this.fTypeParameter.getDeclaringMember()) instanceof IType) {
            IType type = (IType)member;
            if (type.getTypeParameter(name).exists()) {
                result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_class_type_parameter_already_defined);
            }
        } else if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.getTypeParameter(name).exists()) {
                result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_method_type_parameter_already_defined);
            }
        } else {
            JavaManipulationPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
            Assert.isTrue((boolean)false);
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        try {
            Object change = this.fChange;
            if (change != null) {
                String project = null;
                IJavaProject javaProject = this.fTypeParameter.getJavaProject();
                if (javaProject != null) {
                    project = javaProject.getElementName();
                }
                String description = Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTypeParameter.getElementName()));
                String header = Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fTypeParameter.getElementName()), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fTypeParameter.getDeclaringMember(), 2235681801344L), BasicElementLabels.getJavaElementName(this.getNewElementName())});
                String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
                RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.type.parameter");
                descriptor.setProject(project);
                descriptor.setDescription(description);
                descriptor.setComment(comment);
                descriptor.setFlags(0);
                descriptor.setJavaElement((IJavaElement)this.fTypeParameter);
                descriptor.setNewName(this.getNewElementName());
                descriptor.setUpdateReferences(this.fUpdateReferences);
                change = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.RenameTypeParameterProcessor_change_name, new Change[]{change});
            }
            Change change2 = change;
            return change2;
        }
        finally {
            this.fChange = null;
            monitor.done();
        }
    }

    private RefactoringStatus createRenameChanges(IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching, 2);
            ICompilationUnit cu = this.fTypeParameter.getDeclaringMember().getCompilationUnit();
            CompilationUnit root = RefactoringASTParser.parseWithASTProvider((ITypeRoot)cu, true, null);
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(cu, root);
            IMember member = this.fTypeParameter.getDeclaringMember();
            MethodDeclaration declaration = null;
            if (member instanceof IMethod) {
                declaration = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root);
            } else if (member instanceof IType) {
                declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, root);
            } else {
                JavaManipulationPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
                Assert.isTrue((boolean)false);
            }
            monitor.worked(1);
            RenameTypeParameterVisitor visitor = new RenameTypeParameterVisitor(rewrite, this.fTypeParameter.getNameRange(), status);
            if (declaration != null) {
                declaration.accept((ASTVisitor)visitor);
            }
            this.fChange = visitor.getResult();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fTypeParameter);
    }

    @Override
    public String getCurrentElementName() {
        return this.fTypeParameter.getElementName();
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fTypeParameter};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Object getNewElement() throws CoreException {
        IMember member = this.fTypeParameter.getDeclaringMember();
        if (member instanceof IType) {
            IType type = (IType)member;
            return type.getTypeParameter(this.getNewElementName());
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            return method.getTypeParameter(this.getNewElementName());
        }
        JavaManipulationPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTypeParameterProcessor_name;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String parameter = extended.getAttribute(ATTRIBUTE_PARAMETER);
        if (parameter == null || "".equals(parameter)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PARAMETER));
        }
        String handle = extended.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.type.parameter");
            }
            if (element instanceof IMethod) {
                this.fTypeParameter = ((IMethod)element).getTypeParameter(parameter);
            } else if (element instanceof IType) {
                this.fTypeParameter = ((IType)element).getTypeParameter(parameter);
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}));
            }
            if (this.fTypeParameter == null || !this.fTypeParameter.exists()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(this.fTypeParameter, this.getProcessorName(), "org.eclipse.jdt.ui.rename.type.parameter");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.parseBoolean(references);
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isRenameAvailable(this.fTypeParameter);
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    private class RenameTypeParameterVisitor
    extends HierarchicalASTVisitor {
        private final IBinding fBinding;
        private final SimpleName fName;
        private final CompilationUnitRewrite fRewrite;
        private final RefactoringStatus fStatus;

        public RenameTypeParameterVisitor(CompilationUnitRewrite rewrite, ISourceRange range, RefactoringStatus status) {
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)range);
            Assert.isNotNull((Object)status);
            this.fRewrite = rewrite;
            this.fName = (SimpleName)NodeFinder.perform((ASTNode)rewrite.getRoot(), (ISourceRange)range);
            this.fBinding = this.fName.resolveBinding();
            this.fStatus = status;
        }

        public Change getResult() throws CoreException {
            return this.fRewrite.createChange(true);
        }

        @Override
        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (this.fBinding == binding) {
                String groupDescription = null;
                if (node != this.fName) {
                    if (RenameTypeParameterProcessor.this.fUpdateReferences) {
                        groupDescription = RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_reference;
                    }
                } else {
                    groupDescription = RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_declaration;
                }
                if (groupDescription != null) {
                    this.fRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(groupDescription));
                }
            }
            return true;
        }

        @Override
        public boolean visit(AbstractTypeDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create((ITypeRoot)RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), SourceRangeFactory.create((ASTNode)node)));
                return true;
            }
            return true;
        }
    }
}

