/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.partition;

import org.eclipse.jdt.ls.core.internal.partition.FastJavaPartitionScanner;
import org.eclipse.jdt.ls.core.internal.partition.FastPartitioner;
import org.eclipse.jdt.ls.core.internal.partition.IPartitionTokenScanner;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.ITypedRegion;

public class FastJavaPartitioner
extends FastPartitioner {
    private boolean fIsTextBlockSupported = false;

    public FastJavaPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        super(scanner, legalContentTypes);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.fIsTextBlockSupported = this.isTextBlockSupported();
    }

    public void resetPositionCache() {
        this.clearPositionCache();
    }

    @Override
    public void documentAboutToBeChanged(DocumentEvent e) {
        super.documentAboutToBeChanged(e);
        if (this.hasTextBlockSupportedValueChanged()) {
            this.clearManagingPositionCategory();
            this.connect(this.fDocument, false);
        }
    }

    @Override
    public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        if (this.hasTextBlockSupportedValueChanged()) {
            this.clearManagingPositionCategory();
            this.connect(this.fDocument, false);
        }
        return super.computePartitioning(offset, length, includeZeroLengthPartitions);
    }

    public void cleanAndReConnectDocumentIfNecessary() {
        if (this.hasTextBlockSupportedValueChanged()) {
            this.clearManagingPositionCategory();
            this.connect(this.fDocument, false);
        }
    }

    public boolean hasTextBlockSupportedValueChanged() {
        boolean textBlockSupportedValueChanged = false;
        boolean textBlockSupported = this.isTextBlockSupported();
        if (textBlockSupported != this.fIsTextBlockSupported) {
            textBlockSupportedValueChanged = true;
        }
        return textBlockSupportedValueChanged;
    }

    private boolean isTextBlockSupported() {
        boolean isTextBlockSupported = false;
        isTextBlockSupported = this.fScanner instanceof FastJavaPartitionScanner ? ((FastJavaPartitionScanner)this.fScanner).isTextBlockSupported() : false;
        return isTextBlockSupported;
    }

    private void clearManagingPositionCategory() {
        String[] categories;
        String[] stringArray = categories = this.getManagingPositionCategories();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            try {
                this.fDocument.removePositionCategory(category);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            ++n2;
        }
        this.clearPositionCache();
    }
}

