/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;

public class EclipseProjectImporter
extends AbstractProjectImporter {
    @Override
    public boolean applies(IProgressMonitor monitor) throws CoreException {
        if (this.directories == null) {
            BasicFileDetector eclipseDetector = new BasicFileDetector(this.rootFolder.toPath(), ".project").addExclusions("**/bin");
            IProject[] iProjectArray = ProjectUtils.getAllProjects(false);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                File projectFile = project.getLocation().toFile();
                eclipseDetector.addExclusions(projectFile.getAbsolutePath().replace("\\", "\\\\"));
                ++n2;
            }
            this.directories = eclipseDetector.scan(monitor);
        }
        this.directories = this.directories.stream().filter(path -> new File(path.toFile(), ".classpath").exists()).collect(Collectors.toList());
        return !this.directories.isEmpty();
    }

    @Override
    public boolean applies(Collection<IPath> buildFiles, IProgressMonitor monitor) {
        Collection<java.nio.file.Path> configurationDirs = this.findProjectPathByConfigurationName(buildFiles, Arrays.asList(".project"), true);
        if (configurationDirs == null || configurationDirs.isEmpty()) {
            return false;
        }
        HashSet<java.nio.file.Path> importedProjectPaths = new HashSet<java.nio.file.Path>();
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            importedProjectPaths.add(project.getLocation().toFile().toPath());
            ++n2;
        }
        this.directories = configurationDirs.stream().filter(d -> {
            boolean folderIsImported = importedProjectPaths.stream().anyMatch(path2 -> path2.compareTo((java.nio.file.Path)d) == 0);
            return !folderIsImported;
        }).collect(Collectors.toList());
        this.directories = this.directories.stream().filter(path -> new File(path.toFile(), ".classpath").exists()).collect(Collectors.toList());
        return !this.directories.isEmpty();
    }

    @Override
    public void reset() {
        this.directories = null;
    }

    public void setDirectories(Collection<java.nio.file.Path> paths) {
        this.directories = paths;
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.directories.size());
        JavaLanguageServerPlugin.logInfo("Importing Eclipse project(s)");
        this.directories.forEach(d -> this.importDir((java.nio.file.Path)d, (IProgressMonitor)subMonitor.newChild(1)));
        subMonitor.done();
    }

    /*
     * Unable to fully structure code
     */
    private void importDir(java.nio.file.Path dir, IProgressMonitor m) {
        block10: {
            block9: {
                block8: {
                    monitor = SubMonitor.convert((IProgressMonitor)m, (int)4);
                    workspace = ResourcesPlugin.getWorkspace();
                    dotProjectPath = new Path(dir.resolve(".project").toAbsolutePath().toString());
                    name = null;
                    descriptor = workspace.loadProjectDescription((IPath)dotProjectPath);
                    name = descriptor.getName();
                    if (descriptor.hasNature("org.eclipse.jdt.core.javanature")) break block8;
                    monitor.done();
                    return;
                }
                project = workspace.getRoot().getProject(name);
                if (!project.exists()) ** GOTO lbl26
                existingProjectPath = project.getLocation();
                if (!(existingProjectPath = this.fixDevice(existingProjectPath)).equals((Object)(dotProjectPath = this.fixDevice((IPath)dotProjectPath)).removeLastSegments(1))) break block9;
                project.open(0, (IProgressMonitor)monitor.newChild(1));
                project.refreshLocal(2, (IProgressMonitor)monitor.newChild(1));
                monitor.done();
                return;
            }
            try {
                block12: {
                    block11: {
                        try {
                            project = this.findUniqueProject(workspace, name);
                            descriptor.setName(project.getName());
lbl26:
                            // 2 sources

                            project.create(descriptor, (IProgressMonitor)monitor.newChild(1));
                            project.open(0, (IProgressMonitor)monitor.newChild(1));
                            break block10;
                        }
                        catch (CoreException e) {
                            status = e.getStatus();
                            if (status == null || !status.isMultiStatus()) break block11;
                            var13_11 = status.getChildren();
                            var12_12 = var13_11.length;
                            var11_13 = 0;
                            ** while (var11_13 < var12_12)
                        }
lbl-1000:
                        // 1 sources

                        {
                            child = var13_11[var11_13];
                            this.logStatus("Failed to import Eclipse project '" + name + "'.", child);
                            ++var11_13;
                            continue;
lbl40:
                            // 1 sources

                            break block12;
                        }
                    }
                    this.logStatus("Failed to import Eclipse project '" + name + "'.", status);
                }
                throw new RuntimeException(e);
            }
            catch (Throwable var14_15) {
                throw var14_15;
            }
            finally {
                monitor.done();
            }
        }
    }

    private void logStatus(String message, IStatus status) {
        if (status == null) {
            return;
        }
        if (!status.isOK() && status.getSeverity() >= 4) {
            if (status.getException() != null) {
                JavaLanguageServerPlugin.logException(message, status.getException());
            } else {
                JavaLanguageServerPlugin.logError(message + " " + status.getMessage());
            }
            return;
        }
        JavaLanguageServerPlugin.log(status);
    }

    private IPath fixDevice(IPath path) {
        if (path != null && path.getDevice() != null) {
            return path.setDevice(path.getDevice().toUpperCase());
        }
        if ("win32".equals(Platform.getOS()) && path != null && path.toString().startsWith("//")) {
            String server = path.segment(0);
            String pathStr = path.toString().replace(server, server.toUpperCase());
            return new Path(pathStr);
        }
        return path;
    }

    public IProject findUniqueProject(IWorkspace workspace, String basename) {
        IProject project = null;
        int i = 1;
        while (project == null || project.exists()) {
            String name = i < 2 ? basename : basename + " (" + i + ")";
            project = workspace.getRoot().getProject(name);
            ++i;
        }
        return project;
    }
}

