/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.reorg;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.ls.core.internal.Messages;

public class ReorgUtils {
    private static final ISourceRange fgUnknownRange = new SourceRange(-1, 0);

    private ReorgUtils() {
    }

    public static boolean isArchiveOrExternalMember(IJavaElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
            if (root != null && (root.isArchive() || root.isExternal())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsOnlyProjects(List<?> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator<?> iter = elements.iterator();
        while (iter.hasNext()) {
            if (ReorgUtils.isProject(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object element) {
        return element instanceof IJavaProject || element instanceof IProject;
    }

    public static boolean isInsideCompilationUnit(IJavaElement element) {
        return !(element instanceof ICompilationUnit) && ReorgUtils.hasAncestorOfType(element, 5);
    }

    public static boolean isInsideClassFile(IJavaElement element) {
        return !(element instanceof IClassFile) && ReorgUtils.hasAncestorOfType(element, 6);
    }

    public static boolean hasAncestorOfType(IJavaElement element, int type) {
        return element.getAncestor(type) != null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement javaElement) {
        if (javaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)javaElement;
        }
        return (ICompilationUnit)javaElement.getAncestor(5);
    }

    public static ICompilationUnit[] getCompilationUnits(IJavaElement[] javaElements) {
        ICompilationUnit[] result = new ICompilationUnit[javaElements.length];
        int i = 0;
        while (i < javaElements.length) {
            result[i] = ReorgUtils.getCompilationUnit(javaElements[i]);
            ++i;
        }
        return result;
    }

    public static IResource getResource(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).getPrimary().getResource();
        }
        return element.getResource();
    }

    public static IResource[] getResources(IJavaElement[] elements) {
        IResource[] result = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            result[i] = ReorgUtils.getResource(elements[i]);
            ++i;
        }
        return result;
    }

    public static String getName(IResource resource) {
        String resourceLabel = BasicElementLabels.getResourceName((IResource)resource);
        switch (resource.getType()) {
            case 1: {
                return Messages.format(RefactoringCoreMessages.ReorgUtils_0, resourceLabel);
            }
            case 2: {
                return Messages.format(RefactoringCoreMessages.ReorgUtils_1, resourceLabel);
            }
            case 4: {
                return Messages.format(RefactoringCoreMessages.ReorgUtils_2, resourceLabel);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String getName(IJavaElement element) throws JavaModelException {
        String pattern = ReorgUtils.createNamePattern(element);
        String arg = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0x200009L);
        return Messages.format(pattern, arg);
    }

    private static String createNamePattern(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 6: {
                return RefactoringCoreMessages.ReorgUtils_3;
            }
            case 5: {
                return RefactoringCoreMessages.ReorgUtils_4;
            }
            case 8: {
                return RefactoringCoreMessages.ReorgUtils_5;
            }
            case 12: {
                return RefactoringCoreMessages.ReorgUtils_6;
            }
            case 13: {
                return RefactoringCoreMessages.ReorgUtils_7;
            }
            case 10: {
                return RefactoringCoreMessages.ReorgUtils_8;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_9;
            }
            case 9: {
                if (((IMethod)element).isConstructor()) {
                    return RefactoringCoreMessages.ReorgUtils_10;
                }
                return RefactoringCoreMessages.ReorgUtils_11;
            }
            case 11: {
                return RefactoringCoreMessages.ReorgUtils_12;
            }
            case 4: {
                if (JavaElementUtil.isDefaultPackage((Object)element)) {
                    return RefactoringCoreMessages.ReorgUtils_13;
                }
                return RefactoringCoreMessages.ReorgUtils_14;
            }
            case 3: {
                if (((IPackageFragmentRoot)element).isArchive()) {
                    return RefactoringCoreMessages.ReorgUtils_21;
                }
                if (ReorgUtils.isSourceFolder(element)) {
                    return RefactoringCoreMessages.ReorgUtils_15;
                }
                if (ReorgUtils.isClassFolder(element)) {
                    return RefactoringCoreMessages.ReorgUtils_16;
                }
                return RefactoringCoreMessages.ReorgUtils_17;
            }
            case 7: {
                IType type = (IType)element;
                if (type.isAnonymous()) {
                    return RefactoringCoreMessages.ReorgUtils_20;
                }
                return RefactoringCoreMessages.ReorgUtils_18;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IResource[] getResources(List<?> elements) {
        ArrayList<IResource> resources = new ArrayList<IResource>(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IResource)) continue;
            resources.add((IResource)element);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IJavaElement[] getJavaElements(List<?> elements) {
        ArrayList<IJavaElement> resources = new ArrayList<IJavaElement>(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IJavaElement)) continue;
            resources.add((IJavaElement)element);
        }
        return resources.toArray(new IJavaElement[resources.size()]);
    }

    public static IJarEntryResource[] getJarEntryResources(List<?> elements) {
        ArrayList<IJarEntryResource> resources = new ArrayList<IJarEntryResource>(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IJarEntryResource)) continue;
            resources.add((IJarEntryResource)element);
        }
        return resources.toArray(new IJarEntryResource[resources.size()]);
    }

    public static boolean hasSourceAvailable(IMember member) throws JavaModelException {
        return !member.isBinary() || member.getSourceRange() != null && !fgUnknownRange.equals(member.getSourceRange());
    }

    public static IResource[] setMinus(IResource[] setToRemoveFrom, IResource[] elementsToRemove) {
        HashSet<IResource> setMinus = new HashSet<IResource>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IResource[setMinus.size()]);
    }

    public static IJavaElement[] setMinus(IJavaElement[] setToRemoveFrom, IJavaElement[] elementsToRemove) {
        HashSet<IJavaElement> setMinus = new HashSet<IJavaElement>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IJavaElement[setMinus.size()]);
    }

    public static IJavaElement[] union(IJavaElement[] set1, IJavaElement[] set2) {
        LinkedHashSet<IJavaElement> union = new LinkedHashSet<IJavaElement>(set1.length + set2.length);
        union.addAll(Arrays.asList(set1));
        union.addAll(Arrays.asList(set2));
        return union.toArray(new IJavaElement[union.size()]);
    }

    public static IResource[] union(IResource[] set1, IResource[] set2) {
        Stream<IResource> nonNullResources = Stream.concat(Arrays.stream(set1), Arrays.stream(set2)).filter(Objects::nonNull);
        LinkedHashSet union = new LinkedHashSet(set1.length + set2.length);
        nonNullResources.forEach(x -> {
            boolean bl = union.add(x);
        });
        return union.toArray(new IResource[union.size()]);
    }

    public static IType[] getMainTypes(IJavaElement[] javaElements) throws JavaModelException {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element instanceof IType && JavaElementUtil.isMainType((IType)((IType)element))) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IFolder[] getFolders(IResource[] resources) {
        Set<IResource> result = ReorgUtils.getResourcesOfType(resources, 2);
        return result.toArray(new IFolder[result.size()]);
    }

    public static IFile[] getFiles(IResource[] resources) {
        Set<IResource> result = ReorgUtils.getResourcesOfType(resources, 1);
        return result.toArray(new IFile[result.size()]);
    }

    public static Set<IResource> getResourcesOfType(IResource[] resources, int typeMask) {
        HashSet<IResource> result = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (ReorgUtils.isOfType(resources[i], typeMask)) {
                result.add(resources[i]);
            }
            ++i;
        }
        return result;
    }

    public static List<?> getElementsOfType(IJavaElement[] javaElements, int type) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(javaElements.length);
        int i = 0;
        while (i < javaElements.length) {
            if (ReorgUtils.isOfType(javaElements[i], type)) {
                result.add(javaElements[i]);
            }
            ++i;
        }
        return result;
    }

    public static boolean hasElementsNotOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IJavaElement[] javaElements, int type) {
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element != null && !ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] javaElements, int type) {
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element != null && ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] javaElements, int[] types) {
        int i = 0;
        while (i < types.length) {
            if (ReorgUtils.hasElementsOfType(javaElements, types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasOnlyElementsOfType(IJavaElement[] javaElements, int[] types) {
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            boolean found = false;
            int j = 0;
            while (j < types.length && !found) {
                if (ReorgUtils.isOfType(element, types[j])) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasElementsOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isOfType(IJavaElement element, int type) {
        return element.getElementType() == type;
    }

    private static boolean isOfType(IResource resource, int type) {
        return resource != null && ReorgUtils.isFlagSet(resource.getType(), type);
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean isSourceFolder(IJavaElement javaElement) throws JavaModelException {
        return javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() == 1;
    }

    public static boolean isClassFolder(IJavaElement javaElement) throws JavaModelException {
        return javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() == 2;
    }

    public static boolean isPackageFragmentRoot(IJavaProject javaProject) throws JavaModelException {
        return ReorgUtils.getCorrespondingPackageFragmentRoot(javaProject) != null;
    }

    private static boolean isPackageFragmentRootCorrespondingToProject(IPackageFragmentRoot root) {
        return root.getResource() instanceof IProject;
    }

    public static IPackageFragmentRoot getCorrespondingPackageFragmentRoot(IJavaProject p) throws JavaModelException {
        IPackageFragmentRoot[] roots = p.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (ReorgUtils.isPackageFragmentRootCorrespondingToProject(roots[i])) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean containsLinkedResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLinkedResources(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            IResource res = ReorgUtils.getResource(javaElements[i]);
            if (res != null && res.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean canBeDestinationForLinkedResources(IResource resource) {
        return resource.isAccessible() && resource instanceof IProject;
    }

    public static boolean canBeDestinationForLinkedResources(IJavaElement javaElement) {
        if (javaElement instanceof IPackageFragmentRoot) {
            return ReorgUtils.isPackageFragmentRootCorrespondingToProject((IPackageFragmentRoot)javaElement);
        }
        return javaElement instanceof IJavaProject;
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragment pack, IPackageFragmentRoot root) {
        if (pack == null) {
            return false;
        }
        IJavaElement packParent = pack.getParent();
        if (packParent == null) {
            return false;
        }
        if (packParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource((Object)pack);
        IResource packageRootResource = ResourceUtil.getResource((Object)root);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragmentRoot root, IJavaProject javaProject) {
        if (root == null) {
            return false;
        }
        IJavaElement rootParent = root.getParent();
        if (rootParent == null) {
            return false;
        }
        if (rootParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource((Object)root);
        IResource packageRootResource = ResourceUtil.getResource((Object)javaProject);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(ICompilationUnit cu, IPackageFragment dest) {
        if (cu == null) {
            return false;
        }
        IJavaElement cuParent = cu.getParent();
        if (cuParent == null) {
            return false;
        }
        if (cuParent.equals(dest)) {
            return true;
        }
        IResource cuResource = cu.getResource();
        IResource packageResource = ResourceUtil.getResource((Object)dest);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(cuResource, packageResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        URI r1Location = r1.getLocationURI();
        URI r2Location = r2.getLocationURI();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    public static IResource[] getNotNulls(IResource[] resources) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getNotLinked(IResource[] resources) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource) && !resource.isLinked()) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static Map<ICompilationUnit, List<IJavaElement>> groupByCompilationUnit(List<IJavaElement> javaElements) {
        HashMap<ICompilationUnit, List<IJavaElement>> result = new HashMap<ICompilationUnit, List<IJavaElement>>();
        for (IJavaElement element : javaElements) {
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu == null) continue;
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(element);
        }
        return result;
    }

    public static void splitIntoJavaElementsAndResources(Object[] elements, List<? super IJavaElement> javaElementResult, List<? super IResource> resourceResult) {
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IJavaElement) {
                javaElementResult.add((IJavaElement)((IJavaElement)element));
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IJavaElement jElement = JavaCore.create((IResource)resource);
                if (jElement != null && jElement.exists()) {
                    javaElementResult.add((IJavaElement)jElement);
                } else {
                    resourceResult.add((IResource)resource);
                }
            }
            ++i;
        }
    }

    public static boolean containsElementOrParent(Set<IAdaptable> elements, IJavaElement element) {
        IJavaElement curr = element;
        do {
            if (!elements.contains(curr)) continue;
            return true;
        } while ((curr = curr.getParent()) != null);
        return false;
    }

    public static boolean containsElementOrParent(Set<IAdaptable> elements, IResource element) {
        IResource curr = element;
        do {
            if (elements.contains(curr)) {
                return true;
            }
            IJavaElement jElement = JavaCore.create((IResource)curr);
            if (jElement == null || !jElement.exists()) continue;
            return ReorgUtils.containsElementOrParent(elements, jElement);
        } while ((curr = curr.getParent()) != null);
        return false;
    }
}

