/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.contentassist.CompletionRanking;
import org.eclipse.jdt.ls.core.contentassist.ICompletionRankingProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalDescriptionProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalReplacementProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.GetterSetterCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.contentassist.TypeFilter;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionContributionService;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionGuessMethodArgumentsMode;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionMatchCaseMode;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionRankingAggregation;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.InsertReplaceRange;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class CompletionProposalRequestor
extends CompletionRequestor {
    private List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
    private Set<String> collapsedTypes = new HashSet<String>();
    private final ICompilationUnit unit;
    private final String uri;
    private CompletionProposalDescriptionProvider descriptionProvider;
    private CompletionResponse response;
    private boolean fIsTestCodeExcluded;
    private CompletionContext context;
    private boolean isComplete = true;
    private PreferenceManager preferenceManager;
    private CompletionProposalReplacementProvider proposalProvider;
    private CompletionItemDefaults itemDefaults = new CompletionItemDefaults();
    private Set<Integer> completionKinds = new TreeSet<Integer>();
    public static final Set<CompletionItemKind> SUPPORTED_KINDS = ImmutableSet.of((Object)CompletionItemKind.Constructor, (Object)CompletionItemKind.Class, (Object)CompletionItemKind.Constant, (Object)CompletionItemKind.Interface, (Object)CompletionItemKind.Enum, (Object)CompletionItemKind.EnumMember, (Object[])new CompletionItemKind[]{CompletionItemKind.Module, CompletionItemKind.Field, CompletionItemKind.Keyword, CompletionItemKind.Reference, CompletionItemKind.Variable, CompletionItemKind.Method, CompletionItemKind.Text, CompletionItemKind.Snippet, CompletionItemKind.Property, CompletionItemKind.Struct});

    public boolean isComplete() {
        return this.isComplete;
    }

    /*
     * WARNING - void declaration
     */
    public CompletionItemDefaults getCompletionItemDefaults() {
        if (!this.completionKinds.isEmpty()) {
            Object object;
            if (this.itemDefaults.getData() == null) {
                this.itemDefaults.setData(new HashMap());
            }
            if ((object = this.itemDefaults.getData()) instanceof Map) {
                void map;
                Map map2 = (Map)object;
                Map cfr_ignored_0 = (Map)object;
                map.put("completionKinds", this.completionKinds);
            }
        }
        return this.itemDefaults;
    }

    @Deprecated
    public CompletionProposalRequestor(ICompilationUnit aUnit, int offset) {
        this(aUnit, offset, JavaLanguageServerPlugin.getPreferencesManager());
    }

    public CompletionProposalRequestor(ICompilationUnit aUnit, int offset, PreferenceManager preferenceManager) {
        this.unit = aUnit;
        this.uri = JDTUtils.toURI(aUnit);
        this.preferenceManager = preferenceManager;
        this.response = new CompletionResponse();
        this.response.setOffset(offset);
        this.fIsTestCodeExcluded = !this.isTestSource(this.unit.getJavaProject(), this.unit);
        this.setRequireExtendedContext(true);
        try {
            List<String> importedElements = Arrays.stream(this.unit.getImports()).map(t -> t.getElementName()).toList();
            TypeFilter.getDefault().removeFilterIfMatched(importedElements);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to get imports during completion", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTestSource(IJavaProject project, ICompilationUnit cu) {
        if (project == null) {
            return true;
        }
        try {
            IClasspathEntry[] resolvedClasspath = project.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public void accept(CompletionProposal proposal) {
        if (this.isFiltered(proposal)) {
            return;
        }
        if (this.isIgnored(proposal.getKind())) {
            return;
        }
        if (!this.matchCase(proposal)) {
            return;
        }
        if (this.needToCollapse(proposal)) {
            return;
        }
        if (proposal.getKind() == 11) {
            this.acceptPotentialMethodDeclaration(proposal);
        } else {
            if (proposal.getKind() == 8 && this.unit.getParent() != null && String.valueOf(proposal.getCompletion()).equals(this.unit.getParent().getElementName())) {
                proposal.setRelevance(proposal.getRelevance() + 1);
            }
            this.proposals.add(proposal);
        }
    }

    public List<CompletionItem> getCompletionItems() {
        return this.getCompletionItems((IProgressMonitor)new NullProgressMonitor());
    }

    public List<CompletionItem> getCompletionItems(IProgressMonitor monitor) {
        CompletionRankingAggregation[] aggregatedRanks = this.getAggregatedRankingResult(monitor);
        int i = 0;
        while (i < this.proposals.size()) {
            CompletionProposal proposal = this.proposals.get(i);
            if (aggregatedRanks[i] != null) {
                proposal.setRelevance(proposal.getRelevance() + aggregatedRanks[i].getScore());
            }
            ++i;
        }
        HashMap<CompletionProposal, CompletionRankingAggregation> proposalToRankingResult = new HashMap<CompletionProposal, CompletionRankingAggregation>();
        int i2 = 0;
        while (i2 < this.proposals.size()) {
            proposalToRankingResult.put(this.proposals.get(i2), aggregatedRanks[i2]);
            ++i2;
        }
        this.proposals.sort(new ProposalComparator(this.proposals.size()));
        int maxCompletions = this.preferenceManager.getPreferences().getMaxCompletionResults();
        int limit = Math.min(this.proposals.size(), maxCompletions);
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>(limit);
        if (!this.proposals.isEmpty()) {
            this.initializeCompletionListItemDefaults(this.proposals.get(0));
        }
        LinkedList<Map<String, String>> contributedData = new LinkedList<Map<String, String>>();
        int pId = 0;
        int proposalIndex = 0;
        LinkedList<CompletionProposal> proposalsToBeCached = new LinkedList<CompletionProposal>();
        while (pId < limit && proposalIndex < this.proposals.size()) {
            CompletionProposal proposal = this.proposals.get(proposalIndex);
            try {
                CompletionItem item = this.toCompletionItem(proposal, pId);
                CompletionRankingAggregation rankingResult = (CompletionRankingAggregation)proposalToRankingResult.get(proposal);
                if (rankingResult != null) {
                    String decorators = rankingResult.getDecorators();
                    if (!decorators.isEmpty()) {
                        item.setLabel(decorators + " " + item.getLabel());
                        if (StringUtils.isEmpty((CharSequence)item.getFilterText())) {
                            item.setFilterText(item.getInsertText());
                        }
                    }
                    Map<String, String> rankingData = rankingResult.getData();
                    contributedData.add(rankingData);
                }
                completionItems.add(item);
                proposalsToBeCached.add(proposal);
                ++pId;
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException("Failed to convert completion proposal to completion item", e);
            }
            ++proposalIndex;
        }
        Either editRange = this.itemDefaults.getEditRange();
        if (editRange != null) {
            Object range = editRange.getLeft() != null ? (Range)editRange.getLeft() : (editRange.getRight() != null ? (((InsertReplaceRange)editRange.getRight()).getInsert() != null ? ((InsertReplaceRange)editRange.getRight()).getInsert() : ((InsertReplaceRange)editRange.getRight()).getReplace()) : null);
            int line = -1;
            if (range != null) {
                int offset = this.response.getOffset();
                try {
                    Range offsetRange = JDTUtils.toRange((IOpenable)this.unit, offset, 0);
                    line = offsetRange.getStart().getLine();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (range != null && range.getStart().getLine() != line) {
                this.itemDefaults.setEditRange(null);
                this.itemDefaults.setInsertTextFormat(null);
            }
        }
        if (this.proposals.size() > proposalIndex) {
            this.isComplete = false;
        }
        this.response.setProposals(proposalsToBeCached);
        this.response.setItems(completionItems);
        this.response.setCommonData("uri", this.uri);
        this.response.setCompletionItemData(contributedData);
        CompletionResponses.store(this.response);
        return completionItems;
    }

    private CompletionRankingAggregation[] getAggregatedRankingResult(IProgressMonitor monitor) {
        List<ICompletionRankingProvider> providers = ((CompletionContributionService)JavaLanguageServerPlugin.getCompletionContributionService()).getRankingProviders();
        CompletionRankingAggregation[] resultCombination = new CompletionRankingAggregation[this.proposals.size()];
        if (providers != null && !providers.isEmpty()) {
            for (ICompletionRankingProvider provider : providers) {
                CompletionRanking[] results = provider.rank(this.proposals, this.context, this.unit, monitor);
                if (results == null || results.length != this.proposals.size()) continue;
                int i = 0;
                while (i < results.length) {
                    if (results[i] != null) {
                        if (resultCombination[i] == null) {
                            resultCombination[i] = new CompletionRankingAggregation();
                        }
                        resultCombination[i].addScore(results[i].getScore());
                        resultCombination[i].addDecorator(results[i].getDecorator());
                        resultCombination[i].addData(results[i].getData());
                    }
                    ++i;
                }
            }
        }
        return resultCombination;
    }

    private void initializeCompletionListItemDefaults(CompletionProposal proposal) {
        CompletionItem completionItem = new CompletionItem();
        this.proposalProvider.updateReplacement(proposal, completionItem, '\u0000');
        if (completionItem.getInsertTextFormat() != null && this.preferenceManager.getClientPreferences().isCompletionListItemDefaultsPropertySupport("insertTextFormat")) {
            this.itemDefaults.setInsertTextFormat(completionItem.getInsertTextFormat());
        }
        if (completionItem.getTextEdit() != null && this.preferenceManager.getClientPreferences().isCompletionListItemDefaultsPropertySupport("editRange")) {
            this.itemDefaults.setEditRange(CompletionProposalRequestor.getEditRange(completionItem, this.preferenceManager));
        }
        if (this.preferenceManager.getClientPreferences().isCompletionListItemDefaultsPropertySupport("insertTextMode") && this.preferenceManager.getClientPreferences().isCompletionItemInsertTextModeSupport(InsertTextMode.AdjustIndentation) && this.preferenceManager.getClientPreferences().getCompletionItemInsertTextModeDefault() != InsertTextMode.AdjustIndentation) {
            this.itemDefaults.setInsertTextMode(InsertTextMode.AdjustIndentation);
        }
    }

    public CompletionItem toCompletionItem(CompletionProposal proposal, int index) {
        CompletionItem $ = new CompletionItem();
        $.setKind(CompletionProposalRequestor.mapKind(proposal));
        if (Flags.isDeprecated((int)proposal.getFlags())) {
            if (this.preferenceManager.getClientPreferences().isCompletionItemTagSupported()) {
                $.setTags(List.of(CompletionItemTag.Deprecated));
            } else {
                $.setDeprecated(Boolean.valueOf(true));
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("rid", String.valueOf(this.response.getId()));
        data.put("pid", String.valueOf(index));
        $.setData(data);
        this.descriptionProvider.updateDescription(proposal, $);
        $.setSortText(SortTextHelper.computeSortText(proposal));
        this.proposalProvider.updateReplacement(proposal, $, '\u0000');
        if ($.getTextEdit() != null) {
            String newText;
            String string = newText = $.getTextEdit().isLeft() ? ((TextEdit)$.getTextEdit().getLeft()).getNewText() : ((InsertReplaceEdit)$.getTextEdit().getRight()).getNewText();
            Range range = $.getTextEdit().isLeft() ? ((TextEdit)$.getTextEdit().getLeft()).getRange() : (((InsertReplaceEdit)$.getTextEdit().getRight()).getInsert() != null ? ((InsertReplaceEdit)$.getTextEdit().getRight()).getInsert() : ((InsertReplaceEdit)$.getTextEdit().getRight()).getReplace());
            boolean labelDetailsEnabled = this.preferenceManager.getClientPreferences().isCompletionItemLabelDetailsSupport();
            String filterText = "";
            if (labelDetailsEnabled && $.getKind() == CompletionItemKind.Method) {
                filterText = CompletionProposalDescriptionProvider.createMethodProposalDescription(proposal).toString();
            } else if (labelDetailsEnabled && $.getKind() == CompletionItemKind.Constructor && $.getLabelDetails() != null && $.getLabelDetails().getDetail() != null) {
                filterText = newText.concat($.getLabelDetails().getDetail());
            }
            if (range != null && !filterText.isEmpty()) {
                $.setFilterText(filterText);
            } else if (range != null && newText != null) {
                $.setFilterText(newText);
            }
            Range replace = this.preferenceManager.getClientPreferences().isCompletionInsertReplaceSupport() ? ($.getTextEdit().isRight() ? ((InsertReplaceEdit)$.getTextEdit().getRight()).getReplace() : null) : range;
            if (replace != null && replace.getEnd().getLine() != replace.getStart().getLine()) {
                replace.setEnd(replace.getStart());
            }
            if (this.itemDefaults.getEditRange() != null && this.itemDefaults.getEditRange().equals(CompletionProposalRequestor.getEditRange($, this.preferenceManager))) {
                $.setTextEditText(newText);
                $.setTextEdit(null);
            }
        }
        if (this.itemDefaults.getInsertTextFormat() != null && this.itemDefaults.getInsertTextFormat() == $.getInsertTextFormat()) {
            $.setInsertTextFormat(null);
        }
        return $;
    }

    private static Either<Range, InsertReplaceRange> getEditRange(CompletionItem completionItem, PreferenceManager preferenceManager) {
        if (preferenceManager.getClientPreferences().isCompletionInsertReplaceSupport()) {
            return Either.forRight((Object)new InsertReplaceRange(((InsertReplaceEdit)completionItem.getTextEdit().getRight()).getInsert(), ((InsertReplaceEdit)completionItem.getTextEdit().getRight()).getReplace()));
        }
        Range range = completionItem.getTextEdit().isLeft() ? ((TextEdit)completionItem.getTextEdit().getLeft()).getRange() : (((InsertReplaceEdit)completionItem.getTextEdit().getRight()).getInsert() != null ? ((InsertReplaceEdit)completionItem.getTextEdit().getRight()).getInsert() : ((InsertReplaceEdit)completionItem.getTextEdit().getRight()).getReplace());
        return Either.forLeft((Object)range);
    }

    public void acceptContext(CompletionContext context) {
        super.acceptContext(context);
        this.context = context;
        this.response.setContext(context);
        this.descriptionProvider = new CompletionProposalDescriptionProvider(this.unit, context);
        this.proposalProvider = new CompletionProposalReplacementProvider(this.unit, context, this.response.getOffset(), this.preferenceManager.getPreferences(), this.preferenceManager.getClientPreferences(), false);
    }

    private static CompletionItemKind mapKind(CompletionProposal proposal) {
        int kind = proposal.getKind();
        int flags = proposal.getFlags();
        switch (kind) {
            case 26: 
            case 27: {
                return CompletionItemKind.Constructor;
            }
            case 1: 
            case 9: {
                if (Flags.isInterface((int)flags)) {
                    return CompletionItemKind.Interface;
                }
                if (Flags.isEnum((int)flags)) {
                    return CompletionItemKind.Enum;
                }
                if (Flags.isRecord((int)flags)) {
                    return CompletionItemKind.Struct;
                }
                return CompletionItemKind.Class;
            }
            case 8: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                return CompletionItemKind.Module;
            }
            case 2: {
                if (Flags.isEnum((int)flags)) {
                    return CompletionItemKind.EnumMember;
                }
                if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                    return CompletionItemKind.Constant;
                }
                return CompletionItemKind.Field;
            }
            case 25: {
                return CompletionItemKind.Field;
            }
            case 3: {
                return CompletionItemKind.Keyword;
            }
            case 4: {
                return CompletionItemKind.Reference;
            }
            case 5: 
            case 10: {
                return CompletionItemKind.Variable;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 24: 
            case 30: {
                return CompletionItemKind.Method;
            }
            case 13: {
                return CompletionItemKind.Property;
            }
        }
        return CompletionItemKind.Text;
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        super.setIgnored(completionProposalKind, ignore);
        if (completionProposalKind == 7 && !ignore) {
            this.setRequireExtendedContext(true);
        }
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        try {
            IJavaElement enclosingElement = null;
            if (this.response.getContext().isExtended()) {
                enclosingElement = this.response.getContext().getEnclosingElement();
            } else if (this.unit != null) {
                enclosingElement = this.unit.getElementAt(proposal.getCompletionLocation() + 1);
            }
            if (enclosingElement == null) {
                return;
            }
            IType type = (IType)enclosingElement.getAncestor(7);
            if (type != null) {
                String prefix = String.valueOf(proposal.getName());
                int completionStart = proposal.getReplaceStart();
                int completionEnd = proposal.getReplaceEnd();
                int relevance = proposal.getRelevance() + 6;
                GetterSetterCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance, this.proposals);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Accept potential method declaration failed for completion ", e);
        }
    }

    public boolean isTestCodeExcluded() {
        return this.fIsTestCodeExcluded;
    }

    public CompletionContext getContext() {
        return this.context;
    }

    public List<CompletionProposal> getProposals() {
        return this.proposals;
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        if (this.isIgnored(proposal.getKind())) {
            return true;
        }
        switch (proposal.getKind()) {
            case 9: 
            case 16: 
            case 26: 
            case 27: {
                return this.isTypeFiltered(proposal);
            }
            case 6: {
                if (proposal.getRequiredProposals() == null) break;
                return this.isTypeFiltered(proposal);
            }
        }
        return false;
    }

    protected boolean isTypeFiltered(CompletionProposal proposal) {
        if (CompletionProposalUtils.isImportCompletion(proposal)) {
            return false;
        }
        char[] declaringType = this.getDeclaringType(proposal);
        return declaringType != null && TypeFilter.isFiltered(declaringType);
    }

    protected final char[] getDeclaringType(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                char[] declaration = proposal.getDeclarationSignature();
                if (declaration == null) {
                    return "java.lang.Object".toCharArray();
                }
                return Signature.toCharArray((char[])declaration);
            }
            case 8: 
            case 28: 
            case 29: {
                return proposal.getDeclarationSignature();
            }
            case 9: 
            case 16: {
                return Signature.toCharArray((char[])proposal.getSignature());
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public boolean isIgnored(char[] fullTypeName) {
        return fullTypeName != null && TypeFilter.isFiltered(fullTypeName);
    }

    public boolean isIgnored(int completionProposalKind) {
        this.completionKinds.add(completionProposalKind);
        return super.isIgnored(completionProposalKind);
    }

    private boolean matchCase(CompletionProposal proposal) {
        char firstCharOfCompletion;
        CompletionProposal[] requiredProposals;
        if (CompletionMatchCaseMode.FIRSTLETTER != this.preferenceManager.getPreferences().getCompletionMatchCaseMode()) {
            return true;
        }
        if (this.context.getToken().length == 0 || proposal.getCompletion().length == 0) {
            return true;
        }
        if ((proposal.getKind() == 26 || proposal.getKind() == 27 || proposal.getKind() == 1) && (requiredProposals = proposal.getRequiredProposals()) != null) {
            CompletionProposal[] completionProposalArray = requiredProposals;
            int n = requiredProposals.length;
            int n2 = 0;
            while (n2 < n) {
                CompletionProposal requiredProposal = completionProposalArray[n2];
                if (requiredProposal.getKind() == 9) {
                    proposal = requiredProposal;
                }
                ++n2;
            }
        }
        if (proposal.getKind() == 9) {
            String simpleTypeName = SignatureUtil.getSimpleTypeName((CompletionProposal)proposal);
            firstCharOfCompletion = simpleTypeName.charAt(0);
        } else {
            firstCharOfCompletion = proposal.getKind() == 7 ? proposal.getName()[0] : proposal.getCompletion()[0];
        }
        return this.context.getToken()[0] == firstCharOfCompletion;
    }

    private boolean needToCollapse(CompletionProposal proposal) {
        if (this.preferenceManager.getPreferences().getGuessMethodArgumentsMode() != CompletionGuessMethodArgumentsMode.OFF) {
            return false;
        }
        CompletionProposal requiredProposal = CompletionProposalUtils.getRequiredTypeProposal(proposal);
        if (requiredProposal == null) {
            return false;
        }
        return !this.collapsedTypes.add(String.valueOf(requiredProposal.getSignature()));
    }

    static class ProposalComparator
    implements Comparator<CompletionProposal> {
        private Map<CompletionProposal, char[]> completionCache;

        ProposalComparator(int cacheSize) {
            this.completionCache = new HashMap<CompletionProposal, char[]>(cacheSize + 1, 1.0f);
        }

        @Override
        public int compare(CompletionProposal p1, CompletionProposal p2) {
            int res = p2.getRelevance() - p1.getRelevance();
            if (res == 0) {
                res = p1.getKind() - p2.getKind();
            }
            if (res == 0) {
                char[] completion1 = p1.getKind() == 7 ? p1.getName() : this.getCompletion(p1);
                char[] completion2 = p2.getKind() == 7 ? p2.getName() : this.getCompletion(p2);
                int p1Length = completion1.length;
                int p2Length = completion2.length;
                int i = 0;
                while (i < p1Length) {
                    if (i >= p2Length) {
                        return -1;
                    }
                    res = Character.compare(completion1[i], completion2[i]);
                    if (res != 0) {
                        return res;
                    }
                    ++i;
                }
                res = p2Length - p1Length;
            }
            CompletionItemKind p1Kind = CompletionProposalRequestor.mapKind(p1);
            CompletionItemKind p2Kind = CompletionProposalRequestor.mapKind(p2);
            if (!(res != 0 || p1Kind != CompletionItemKind.Method && p1Kind != CompletionItemKind.Constructor || p2Kind != CompletionItemKind.Method && p2Kind != CompletionItemKind.Constructor)) {
                int paramCount1 = Signature.getParameterCount((char[])p1.getSignature());
                int paramCount2 = Signature.getParameterCount((char[])p2.getSignature());
                res = paramCount1 - paramCount2;
            }
            return res;
        }

        private char[] getCompletion(CompletionProposal cp) {
            return this.completionCache.computeIfAbsent(cp, p -> p.getCompletion());
        }
    }
}

