/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.syntaxserver;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ls.core.internal.BaseJDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResolveHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FoldingRangeHandler;
import org.eclipse.jdt.ls.core.internal.handlers.HoverHandler;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToTypeDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SelectionRangeHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceEventsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceFolderChangeHandler;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.syntaxserver.IExtendedProtocol;
import org.eclipse.jdt.ls.core.internal.syntaxserver.SyntaxDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.syntaxserver.SyntaxInitHandler;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class SyntaxLanguageServer
extends BaseJDTLanguageServer
implements LanguageServer,
TextDocumentService,
WorkspaceService,
IExtendedProtocol {
    public static final String JAVA_LSP_JOIN_ON_COMPLETION = "java.lsp.joinOnCompletion";
    private SyntaxDocumentLifeCycleHandler documentLifeCycleHandler;
    private ContentProviderManager contentProviderManager;
    private ProjectsManager projectsManager;
    private PreferenceManager preferenceManager;
    private Job shutdownJob = new Job("Shutdown..."){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ResourcesPlugin.getWorkspace().save(true, monitor);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            return Status.OK_STATUS;
        }
    };

    public SyntaxLanguageServer(ContentProviderManager contentProviderManager, ProjectsManager projectsManager, PreferenceManager preferenceManager) {
        this(contentProviderManager, projectsManager, preferenceManager, true);
    }

    public SyntaxLanguageServer(ContentProviderManager contentProviderManager, ProjectsManager projectsManager, PreferenceManager preferenceManager, boolean delayValidation) {
        this.contentProviderManager = contentProviderManager;
        this.projectsManager = projectsManager;
        this.preferenceManager = preferenceManager;
        this.documentLifeCycleHandler = new SyntaxDocumentLifeCycleHandler(null, projectsManager, preferenceManager, delayValidation);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        JavaLanguageServerPlugin.logInfo(">> initialize");
        SyntaxInitHandler handler = new SyntaxInitHandler(this.projectsManager, this.preferenceManager);
        return CompletableFuture.completedFuture(handler.initialize(params));
    }

    public CompletableFuture<Object> shutdown() {
        JavaLanguageServerPlugin.logInfo(">> shutdown");
        return this.computeAsync(monitor -> {
            this.shutdownJob.schedule();
            this.shutdownReceived = true;
            return new Object();
        });
    }

    public void exit() {
        JavaLanguageServerPlugin.logInfo(">> exit");
        if (!this.shutdownReceived) {
            this.shutdownJob.schedule();
        }
        try {
            this.shutdownJob.join();
        }
        catch (InterruptedException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        JavaLanguageServerPlugin.getLanguageServer().exit();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> System.exit(1), 1L, TimeUnit.MINUTES);
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    @JsonDelegate
    public IExtendedProtocol getExtendedService() {
        return this;
    }

    public void initialized() {
        JavaLanguageServerPlugin.logInfo(">> initialized");
        try {
            Job.getJobManager().join((Object)"java-ls-initialization-jobs", null);
        }
        catch (InterruptedException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        this.client.sendStatus(ServiceStatus.Started, "LightWeightServiceReady");
        JavaLanguageServerPlugin.logInfo(">> initialization job finished");
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferenceManager.getClientPreferences().isCompletionDynamicRegistered()) {
            this.registerCapability(Preferences.COMPLETION_ID, "textDocument/completion", CompletionHandler.DEFAULT_COMPLETION_OPTIONS);
        }
        if (!preferenceManager.getClientPreferences().isClientDocumentSymbolProviderRegistered() && preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            this.registerCapability(Preferences.DOCUMENT_SYMBOL_ID, "textDocument/documentSymbol", null);
        }
        if (preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            this.registerCapability(Preferences.DEFINITION_ID, "textDocument/definition", null);
        }
        if (preferenceManager.getClientPreferences().isTypeDefinitionDynamicRegistered()) {
            this.registerCapability(Preferences.TYPEDEFINITION_ID, "textDocument/typeDefinition", null);
        }
        if (preferenceManager.getClientPreferences().isFoldgingRangeDynamicRegistered()) {
            this.registerCapability(Preferences.FOLDINGRANGE_ID, "textDocument/foldingRange", null);
        }
        if (preferenceManager.getClientPreferences().isSelectionRangeDynamicRegistered()) {
            this.registerCapability(Preferences.SELECTION_RANGE_ID, "textDocument/selectionRange", null);
        }
        if (!preferenceManager.getClientPreferences().isClientHoverProviderRegistered() && preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            this.registerCapability(Preferences.HOVER_ID, "textDocument/hover", null);
        }
        if (preferenceManager.getClientPreferences().isWorkspaceChangeWatchedFilesDynamicRegistered()) {
            this.projectsManager.registerWatchers();
        }
    }

    @Override
    public void connectClient(JavaClientConnection.JavaLanguageClient client) {
        super.connectClient(client);
        this.documentLifeCycleHandler.setClient(this.client);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        JavaLanguageServerPlugin.logInfo(">> workspace/didChangeConfiguration");
        Map settings = JSONUtility.toModel(params.getSettings(), Map.class);
        if (settings instanceof Map) {
            Collection<IPath> rootPaths = this.preferenceManager.getPreferences().getRootPaths();
            Preferences prefs = Preferences.createFrom(settings);
            prefs.setRootPaths(rootPaths);
            this.preferenceManager.update(prefs);
        }
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        JavaLanguageServerPlugin.logInfo(">> workspace/didChangeWatchedFiles ");
        WorkspaceEventsHandler handler = new WorkspaceEventsHandler(this.projectsManager, this.client, this.documentLifeCycleHandler);
        handler.didChangeWatchedFiles(params);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/didOpen");
        this.documentLifeCycleHandler.didOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/didChange");
        this.documentLifeCycleHandler.didChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/didClose");
        this.documentLifeCycleHandler.didClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/didSave");
        this.documentLifeCycleHandler.didSave(params);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/documentSymbol");
        boolean hierarchicalDocumentSymbolSupported = this.preferenceManager.getClientPreferences().isHierarchicalDocumentSymbolSupported();
        DocumentSymbolHandler handler = new DocumentSymbolHandler(hierarchicalDocumentSymbolSupported);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.documentSymbol(params, (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams position) {
        JavaLanguageServerPlugin.logInfo(">> document/definition");
        NavigateToDefinitionHandler handler = new NavigateToDefinitionHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            List<? extends Location> locations = handler.definition((TextDocumentPositionParams)position, (IProgressMonitor)monitor);
            for (Location location : locations) {
                location.setUri(JDTUtils.replaceUriFragment(location.getUri(), "syntaxserver"));
            }
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams position) {
        JavaLanguageServerPlugin.logInfo(">> document/typeDefinition");
        NavigateToTypeDefinitionHandler handler = new NavigateToTypeDefinitionHandler();
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            List<? extends Location> locations = handler.typeDefinition((TextDocumentPositionParams)position, (IProgressMonitor)monitor);
            for (Location location : locations) {
                location.setUri(JDTUtils.replaceUriFragment(location.getUri(), "syntaxserver"));
            }
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/foldingRange");
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return new FoldingRangeHandler().foldingRange(params, (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        JavaLanguageServerPlugin.logInfo(">> document/selectionRange");
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return new SelectionRangeHandler().selectionRange(params, (IProgressMonitor)monitor);
        });
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        JavaLanguageServerPlugin.logInfo(">> java/didChangeWorkspaceFolders");
        WorkspaceFolderChangeHandler handler = new WorkspaceFolderChangeHandler(this.projectsManager, this.preferenceManager);
        handler.update(params);
    }

    @Override
    public CompletableFuture<String> classFileContents(TextDocumentIdentifier param) {
        JavaLanguageServerPlugin.logInfo(">> java/classFileContents");
        URI uri = JDTUtils.toURI(param.getUri());
        return this.computeAsync(monitor -> this.contentProviderManager.getContent(uri, (IProgressMonitor)monitor));
    }

    public CompletableFuture<Hover> hover(HoverParams position) {
        JavaLanguageServerPlugin.logInfo(">> document/hover");
        HoverHandler handler = new HoverHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.hover((TextDocumentPositionParams)position, (IProgressMonitor)monitor));
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        JavaLanguageServerPlugin.logInfo(">> document/completion");
        CompletionHandler handler = new CompletionHandler(this.preferenceManager);
        IProgressMonitor[] monitors = new IProgressMonitor[1];
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> result = this.computeAsync(monitor -> {
            iProgressMonitorArray[0] = monitor;
            if (Boolean.getBoolean(JAVA_LSP_JOIN_ON_COMPLETION)) {
                this.waitForLifecycleJobs((IProgressMonitor)monitor);
            }
            return handler.completion(position, (IProgressMonitor)monitor);
        });
        result.join();
        if (monitors[0].isCanceled()) {
            result.cancel(true);
        }
        return result;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        JavaLanguageServerPlugin.logInfo(">> document/resolveCompletionItem");
        CompletionResolveHandler handler = new CompletionResolveHandler(this.preferenceManager);
        IProgressMonitor[] monitors = new IProgressMonitor[1];
        CompletableFuture<CompletionItem> result = this.computeAsync(monitor -> {
            iProgressMonitorArray[0] = monitor;
            if (Boolean.getBoolean(JAVA_LSP_JOIN_ON_COMPLETION)) {
                this.waitForLifecycleJobs((IProgressMonitor)monitor);
            }
            return handler.resolve(unresolved, (IProgressMonitor)monitor);
        });
        result.join();
        if (monitors[0].isCanceled()) {
            result.cancel(true);
        }
        return result;
    }

    private void waitForLifecycleJobs(IProgressMonitor monitor) {
        JobHelpers.waitForJobs("DocumentLifeCycleJobs", monitor);
    }
}

