"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VSXExtensionResolver = void 0;
const os = require("os");
const path = require("path");
const fs = require("@theia/core/shared/fs-extra");
const uuid_1 = require("uuid");
const requestretry = require("requestretry");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const vsx_extension_uri_1 = require("../common/vsx-extension-uri");
const ovsx_client_provider_1 = require("../common/ovsx-client-provider");
let VSXExtensionResolver = class VSXExtensionResolver {
    constructor() {
        this.downloadPath = path.resolve(os.tmpdir(), uuid_1.v4());
        fs.ensureDirSync(this.downloadPath);
        fs.emptyDirSync(this.downloadPath);
    }
    accept(pluginId) {
        return !!vsx_extension_uri_1.VSXExtensionUri.toId(new uri_1.default(pluginId));
    }
    async resolve(context) {
        const id = vsx_extension_uri_1.VSXExtensionUri.toId(new uri_1.default(context.getOriginId()));
        if (!id) {
            return;
        }
        console.log(`[${id}]: trying to resolve latest version...`);
        const client = await this.clientProvider();
        const extension = await client.getLatestCompatibleExtensionVersion(id);
        if (!extension) {
            return;
        }
        if (extension.error) {
            throw new Error(extension.error);
        }
        const resolvedId = id + '-' + extension.version;
        const downloadUrl = extension.files.download;
        console.log(`[${id}]: resolved to '${resolvedId}'`);
        const extensionPath = path.resolve(this.downloadPath, path.basename(downloadUrl));
        console.log(`[${resolvedId}]: trying to download from "${downloadUrl}"...`);
        if (!await this.download(downloadUrl, extensionPath)) {
            console.log(`[${resolvedId}]: not found`);
            return;
        }
        console.log(`[${resolvedId}]: downloaded to ${extensionPath}"`);
        context.addPlugin(resolvedId, extensionPath);
    }
    async download(downloadUrl, downloadPath) {
        return new Promise((resolve, reject) => {
            requestretry(downloadUrl, {
                method: 'GET',
                maxAttempts: 5,
                retryDelay: 2000,
                retryStrategy: requestretry.RetryStrategies.HTTPOrNetworkError
            }, (err, response) => {
                if (err) {
                    reject(err);
                }
                else if (response && response.statusCode === 404) {
                    resolve(false);
                }
                else if (response && response.statusCode !== 200) {
                    reject(new Error(response.statusMessage));
                }
            }).pipe(fs.createWriteStream(downloadPath))
                .on('error', reject)
                .on('close', () => resolve(true));
        });
    }
};
__decorate([
    inversify_1.inject(ovsx_client_provider_1.OVSXClientProvider),
    __metadata("design:type", Function)
], VSXExtensionResolver.prototype, "clientProvider", void 0);
VSXExtensionResolver = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], VSXExtensionResolver);
exports.VSXExtensionResolver = VSXExtensionResolver;
//# sourceMappingURL=vsx-extension-resolver.js.map