/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { CancellationTokenSource } from '../../../base/common/cancellation';
import { DisposableStore, Disposable, MutableDisposable } from '../../../base/common/lifecycle';
import { timeout } from '../../../base/common/async';
export var TriggerAction;
(function (TriggerAction) {
    /**
     * Do nothing after the button was clicked.
     */
    TriggerAction[TriggerAction["NO_ACTION"] = 0] = "NO_ACTION";
    /**
     * Close the picker.
     */
    TriggerAction[TriggerAction["CLOSE_PICKER"] = 1] = "CLOSE_PICKER";
    /**
     * Update the results of the picker.
     */
    TriggerAction[TriggerAction["REFRESH_PICKER"] = 2] = "REFRESH_PICKER";
    /**
     * Remove the item from the picker.
     */
    TriggerAction[TriggerAction["REMOVE_ITEM"] = 3] = "REMOVE_ITEM";
})(TriggerAction || (TriggerAction = {}));
function isPicksWithActive(obj) {
    var candidate = obj;
    return Array.isArray(candidate.items);
}
function isFastAndSlowPicks(obj) {
    var candidate = obj;
    return !!candidate.picks && candidate.additionalPicks instanceof Promise;
}
var PickerQuickAccessProvider = /** @class */ (function (_super) {
    __extends(PickerQuickAccessProvider, _super);
    function PickerQuickAccessProvider(prefix, options) {
        var _this = _super.call(this) || this;
        _this.prefix = prefix;
        _this.options = options;
        return _this;
    }
    PickerQuickAccessProvider.prototype.provide = function (picker, token) {
        var _this = this;
        var _a;
        var disposables = new DisposableStore();
        // Apply options if any
        picker.canAcceptInBackground = !!((_a = this.options) === null || _a === void 0 ? void 0 : _a.canAcceptInBackground);
        // Disable filtering & sorting, we control the results
        picker.matchOnLabel = picker.matchOnDescription = picker.matchOnDetail = picker.sortByLabel = false;
        // Set initial picks and update on type
        var picksCts = undefined;
        var picksDisposable = disposables.add(new MutableDisposable());
        var updatePickerItems = function () { return __awaiter(_this, void 0, void 0, function () {
            var picksDisposables, picksToken, picksFilter, providedPicks, applyPicks, fastPicksApplied_1, slowPicksApplied_1, awaitedPicks;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        picksDisposables = picksDisposable.value = new DisposableStore();
                        // Cancel any previous ask for picks and busy
                        picksCts === null || picksCts === void 0 ? void 0 : picksCts.dispose(true);
                        picker.busy = false;
                        // Create new cancellation source for this run
                        picksCts = new CancellationTokenSource(token);
                        picksToken = picksCts.token;
                        picksFilter = picker.value.substr(this.prefix.length).trim();
                        providedPicks = this.getPicks(picksFilter, picksDisposables, picksToken);
                        applyPicks = function (picks, skipEmpty) {
                            var _a;
                            var items;
                            var activeItem = undefined;
                            if (isPicksWithActive(picks)) {
                                items = picks.items;
                                activeItem = picks.active;
                            }
                            else {
                                items = picks;
                            }
                            if (items.length === 0) {
                                if (skipEmpty) {
                                    return false;
                                }
                                if (picksFilter.length > 0 && ((_a = _this.options) === null || _a === void 0 ? void 0 : _a.noResultsPick)) {
                                    items = [_this.options.noResultsPick];
                                }
                            }
                            picker.items = items;
                            if (activeItem) {
                                picker.activeItems = [activeItem];
                            }
                            return true;
                        };
                        if (!(providedPicks === null)) return [3 /*break*/, 1];
                        return [3 /*break*/, 8];
                    case 1:
                        if (!isFastAndSlowPicks(providedPicks)) return [3 /*break*/, 3];
                        fastPicksApplied_1 = false;
                        slowPicksApplied_1 = false;
                        return [4 /*yield*/, Promise.all([
                                // Fast Picks: to reduce amount of flicker, we race against
                                // the slow picks over 500ms and then set the fast picks.
                                // If the slow picks are faster, we reduce the flicker by
                                // only setting the items once.
                                (function () { return __awaiter(_this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0: return [4 /*yield*/, timeout(PickerQuickAccessProvider.FAST_PICKS_RACE_DELAY)];
                                            case 1:
                                                _a.sent();
                                                if (picksToken.isCancellationRequested) {
                                                    return [2 /*return*/];
                                                }
                                                if (!slowPicksApplied_1) {
                                                    fastPicksApplied_1 = applyPicks(providedPicks.picks, true /* skip over empty to reduce flicker */);
                                                }
                                                return [2 /*return*/];
                                        }
                                    });
                                }); })(),
                                // Slow Picks: we await the slow picks and then set them at
                                // once together with the fast picks, but only if we actually
                                // have additional results.
                                (function () { return __awaiter(_this, void 0, void 0, function () {
                                    var awaitedAdditionalPicks, picks, activePick, additionalPicks, additionalActivePick, fallbackActivePick, fallbackActivePickCandidate;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                picker.busy = true;
                                                _a.label = 1;
                                            case 1:
                                                _a.trys.push([1, , 3, 4]);
                                                return [4 /*yield*/, providedPicks.additionalPicks];
                                            case 2:
                                                awaitedAdditionalPicks = _a.sent();
                                                if (picksToken.isCancellationRequested) {
                                                    return [2 /*return*/];
                                                }
                                                picks = void 0;
                                                activePick = undefined;
                                                if (isPicksWithActive(providedPicks.picks)) {
                                                    picks = providedPicks.picks.items;
                                                    activePick = providedPicks.picks.active;
                                                }
                                                else {
                                                    picks = providedPicks.picks;
                                                }
                                                additionalPicks = void 0;
                                                additionalActivePick = undefined;
                                                if (isPicksWithActive(awaitedAdditionalPicks)) {
                                                    additionalPicks = awaitedAdditionalPicks.items;
                                                    additionalActivePick = awaitedAdditionalPicks.active;
                                                }
                                                else {
                                                    additionalPicks = awaitedAdditionalPicks;
                                                }
                                                if (additionalPicks.length > 0 || !fastPicksApplied_1) {
                                                    fallbackActivePick = undefined;
                                                    if (!activePick && !additionalActivePick) {
                                                        fallbackActivePickCandidate = picker.activeItems[0];
                                                        if (fallbackActivePickCandidate && picks.indexOf(fallbackActivePickCandidate) !== -1) {
                                                            fallbackActivePick = fallbackActivePickCandidate;
                                                        }
                                                    }
                                                    applyPicks({
                                                        items: __spreadArray(__spreadArray([], __read(picks)), __read(additionalPicks)),
                                                        active: activePick || additionalActivePick || fallbackActivePick
                                                    });
                                                }
                                                return [3 /*break*/, 4];
                                            case 3:
                                                if (!picksToken.isCancellationRequested) {
                                                    picker.busy = false;
                                                }
                                                slowPicksApplied_1 = true;
                                                return [7 /*endfinally*/];
                                            case 4: return [2 /*return*/];
                                        }
                                    });
                                }); })()
                            ])];
                    case 2:
                        _a.sent();
                        return [3 /*break*/, 8];
                    case 3:
                        if (!!(providedPicks instanceof Promise)) return [3 /*break*/, 4];
                        applyPicks(providedPicks);
                        return [3 /*break*/, 8];
                    case 4:
                        picker.busy = true;
                        _a.label = 5;
                    case 5:
                        _a.trys.push([5, , 7, 8]);
                        return [4 /*yield*/, providedPicks];
                    case 6:
                        awaitedPicks = _a.sent();
                        if (picksToken.isCancellationRequested) {
                            return [2 /*return*/];
                        }
                        applyPicks(awaitedPicks);
                        return [3 /*break*/, 8];
                    case 7:
                        if (!picksToken.isCancellationRequested) {
                            picker.busy = false;
                        }
                        return [7 /*endfinally*/];
                    case 8: return [2 /*return*/];
                }
            });
        }); };
        disposables.add(picker.onDidChangeValue(function () { return updatePickerItems(); }));
        updatePickerItems();
        // Accept the pick on accept and hide picker
        disposables.add(picker.onDidAccept(function (event) {
            var _a = __read(picker.selectedItems, 1), item = _a[0];
            if (typeof (item === null || item === void 0 ? void 0 : item.accept) === 'function') {
                if (!event.inBackground) {
                    picker.hide(); // hide picker unless we accept in background
                }
                item.accept(picker.keyMods, event);
            }
        }));
        // Trigger the pick with button index if button triggered
        disposables.add(picker.onDidTriggerItemButton(function (_a) {
            var button = _a.button, item = _a.item;
            return __awaiter(_this, void 0, void 0, function () {
                var buttonIndex, result, action, _b, index, items;
                var _c, _d;
                return __generator(this, function (_e) {
                    switch (_e.label) {
                        case 0:
                            if (!(typeof item.trigger === 'function')) return [3 /*break*/, 4];
                            buttonIndex = (_d = (_c = item.buttons) === null || _c === void 0 ? void 0 : _c.indexOf(button)) !== null && _d !== void 0 ? _d : -1;
                            if (!(buttonIndex >= 0)) return [3 /*break*/, 4];
                            result = item.trigger(buttonIndex, picker.keyMods);
                            if (!(typeof result === 'number')) return [3 /*break*/, 1];
                            _b = result;
                            return [3 /*break*/, 3];
                        case 1: return [4 /*yield*/, result];
                        case 2:
                            _b = _e.sent();
                            _e.label = 3;
                        case 3:
                            action = _b;
                            if (token.isCancellationRequested) {
                                return [2 /*return*/];
                            }
                            switch (action) {
                                case TriggerAction.NO_ACTION:
                                    break;
                                case TriggerAction.CLOSE_PICKER:
                                    picker.hide();
                                    break;
                                case TriggerAction.REFRESH_PICKER:
                                    updatePickerItems();
                                    break;
                                case TriggerAction.REMOVE_ITEM:
                                    index = picker.items.indexOf(item);
                                    if (index !== -1) {
                                        items = picker.items.slice();
                                        items.splice(index, 1);
                                        picker.items = items;
                                    }
                                    break;
                            }
                            _e.label = 4;
                        case 4: return [2 /*return*/];
                    }
                });
            });
        }));
        return disposables;
    };
    PickerQuickAccessProvider.FAST_PICKS_RACE_DELAY = 200; // timeout before we accept fast results before slow results are present
    return PickerQuickAccessProvider;
}(Disposable));
export { PickerQuickAccessProvider };
