/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as dom from '../../../base/browser/dom';
import { ActionBar } from '../../../base/browser/ui/actionbar/actionbar';
import { DisposableStore } from '../../../base/common/lifecycle';
import { suggestWidgetStatusbarMenu } from './suggest';
import { localize } from '../../../nls';
import { MenuEntryActionViewItem } from '../../../platform/actions/browser/menuEntryActionViewItem';
import { IMenuService, MenuItemAction } from '../../../platform/actions/common/actions';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
var StatusBarViewItem = /** @class */ (function (_super) {
    __extends(StatusBarViewItem, _super);
    function StatusBarViewItem() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    StatusBarViewItem.prototype.updateLabel = function () {
        var kb = this._keybindingService.lookupKeybinding(this._action.id);
        if (!kb) {
            return _super.prototype.updateLabel.call(this);
        }
        if (this.label) {
            this.label.textContent = localize('ddd', '{0} ({1})', this._action.label, StatusBarViewItem.symbolPrintEnter(kb));
        }
    };
    StatusBarViewItem.symbolPrintEnter = function (kb) {
        var _a;
        return (_a = kb.getLabel()) === null || _a === void 0 ? void 0 : _a.replace(/\benter\b/gi, '\u23CE');
    };
    return StatusBarViewItem;
}(MenuEntryActionViewItem));
var SuggestWidgetStatus = /** @class */ (function () {
    function SuggestWidgetStatus(container, instantiationService, _menuService, _contextKeyService) {
        this._menuService = _menuService;
        this._contextKeyService = _contextKeyService;
        this._menuDisposables = new DisposableStore();
        this.element = dom.append(container, dom.$('.suggest-status-bar'));
        var actionViewItemProvider = (function (action) {
            return action instanceof MenuItemAction ? instantiationService.createInstance(StatusBarViewItem, action) : undefined;
        });
        this._leftActions = new ActionBar(this.element, { actionViewItemProvider: actionViewItemProvider });
        this._rightActions = new ActionBar(this.element, { actionViewItemProvider: actionViewItemProvider });
        this._leftActions.domNode.classList.add('left');
        this._rightActions.domNode.classList.add('right');
    }
    SuggestWidgetStatus.prototype.dispose = function () {
        this._menuDisposables.dispose();
        this.element.remove();
    };
    SuggestWidgetStatus.prototype.show = function () {
        var _this = this;
        var menu = this._menuService.createMenu(suggestWidgetStatusbarMenu, this._contextKeyService);
        var renderMenu = function () {
            var e_1, _a;
            var left = [];
            var right = [];
            try {
                for (var _b = __values(menu.getActions()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = __read(_c.value, 2), group = _d[0], actions = _d[1];
                    if (group === 'left') {
                        left.push.apply(left, __spreadArray([], __read(actions)));
                    }
                    else {
                        right.push.apply(right, __spreadArray([], __read(actions)));
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            _this._leftActions.clear();
            _this._leftActions.push(left);
            _this._rightActions.clear();
            _this._rightActions.push(right);
        };
        this._menuDisposables.add(menu.onDidChange(function () { return renderMenu(); }));
        this._menuDisposables.add(menu);
    };
    SuggestWidgetStatus.prototype.hide = function () {
        this._menuDisposables.clear();
    };
    SuggestWidgetStatus = __decorate([
        __param(1, IInstantiationService),
        __param(2, IMenuService),
        __param(3, IContextKeyService)
    ], SuggestWidgetStatus);
    return SuggestWidgetStatus;
}());
export { SuggestWidgetStatus };
