/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { isNonEmptyArray } from '../../../base/common/arrays';
import { DisposableStore } from '../../../base/common/lifecycle';
import { CharacterSet } from '../../common/core/characterClassifier';
var CommitCharacterController = /** @class */ (function () {
    function CommitCharacterController(editor, widget, accept) {
        var _this = this;
        this._disposables = new DisposableStore();
        this._disposables.add(widget.onDidShow(function () { return _this._onItem(widget.getFocusedItem()); }));
        this._disposables.add(widget.onDidFocus(this._onItem, this));
        this._disposables.add(widget.onDidHide(this.reset, this));
        this._disposables.add(editor.onWillType(function (text) {
            if (_this._active && !widget.isFrozen()) {
                var ch = text.charCodeAt(text.length - 1);
                if (_this._active.acceptCharacters.has(ch) && editor.getOption(0 /* acceptSuggestionOnCommitCharacter */)) {
                    accept(_this._active.item);
                }
            }
        }));
    }
    CommitCharacterController.prototype._onItem = function (selected) {
        var e_1, _a;
        if (!selected || !isNonEmptyArray(selected.item.completion.commitCharacters)) {
            // no item or no commit characters
            this.reset();
            return;
        }
        if (this._active && this._active.item.item === selected.item) {
            // still the same item
            return;
        }
        // keep item and its commit characters
        var acceptCharacters = new CharacterSet();
        try {
            for (var _b = __values(selected.item.completion.commitCharacters), _c = _b.next(); !_c.done; _c = _b.next()) {
                var ch = _c.value;
                if (ch.length > 0) {
                    acceptCharacters.add(ch.charCodeAt(0));
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._active = { acceptCharacters: acceptCharacters, item: selected };
    };
    CommitCharacterController.prototype.reset = function () {
        this._active = undefined;
    };
    CommitCharacterController.prototype.dispose = function () {
        this._disposables.dispose();
    };
    return CommitCharacterController;
}());
export { CommitCharacterController };
