/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
// import color detector contribution
import './colorDetector';
import { Disposable } from '../../../base/common/lifecycle';
import { registerEditorContribution } from '../../browser/editorExtensions';
import { ModesHoverController } from '../hover/hover';
import { Range } from '../../common/core/range';
var ColorContribution = /** @class */ (function (_super) {
    __extends(ColorContribution, _super);
    function ColorContribution(_editor) {
        var _this = _super.call(this) || this;
        _this._editor = _editor;
        _this._register(_editor.onMouseDown(function (e) { return _this.onMouseDown(e); }));
        return _this;
    }
    ColorContribution.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
    };
    ColorContribution.prototype.onMouseDown = function (mouseEvent) {
        var _a;
        var targetType = mouseEvent.target.type;
        if (targetType !== 6 /* CONTENT_TEXT */) {
            return;
        }
        var hoverOnColorDecorator = __spreadArray([], __read(((_a = mouseEvent.target.element) === null || _a === void 0 ? void 0 : _a.classList.values()) || [])).find(function (className) { return className.startsWith('ced-colorBox'); });
        if (!hoverOnColorDecorator) {
            return;
        }
        if (!mouseEvent.target.range) {
            return;
        }
        var hoverController = this._editor.getContribution(ModesHoverController.ID);
        if (!hoverController.isColorPickerVisible()) {
            var range = new Range(mouseEvent.target.range.startLineNumber, mouseEvent.target.range.startColumn + 1, mouseEvent.target.range.endLineNumber, mouseEvent.target.range.endColumn + 1);
            hoverController.showContentHover(range, 0 /* Delayed */, false);
        }
    };
    ColorContribution.ID = 'editor.contrib.colorContribution';
    ColorContribution.RECOMPUTE_TIME = 1000; // ms
    return ColorContribution;
}(Disposable));
export { ColorContribution };
registerEditorContribution(ColorContribution.ID, ColorContribution);
