/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import './anchorSelect.css';
import { EditorAction, registerEditorAction, registerEditorContribution } from '../../browser/editorExtensions';
import { localize } from '../../../nls';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { Selection } from '../../common/core/selection';
import { KeyChord } from '../../../base/common/keyCodes';
import { RawContextKey, IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { MarkdownString } from '../../../base/common/htmlContent';
import { alert } from '../../../base/browser/ui/aria/aria';
export var SelectionAnchorSet = new RawContextKey('selectionAnchorSet', false);
var SelectionAnchorController = /** @class */ (function () {
    function SelectionAnchorController(editor, contextKeyService) {
        var _this = this;
        this.editor = editor;
        this.selectionAnchorSetContextKey = SelectionAnchorSet.bindTo(contextKeyService);
        this.modelChangeListener = editor.onDidChangeModel(function () { return _this.selectionAnchorSetContextKey.reset(); });
    }
    SelectionAnchorController.get = function (editor) {
        return editor.getContribution(SelectionAnchorController.ID);
    };
    SelectionAnchorController.prototype.setSelectionAnchor = function () {
        if (this.editor.hasModel()) {
            var position = this.editor.getPosition();
            var previousDecorations = this.decorationId ? [this.decorationId] : [];
            var newDecorationId = this.editor.deltaDecorations(previousDecorations, [{
                    range: Selection.fromPositions(position, position),
                    options: {
                        stickiness: 1 /* NeverGrowsWhenTypingAtEdges */,
                        hoverMessage: new MarkdownString().appendText(localize('selectionAnchor', "Selection Anchor")),
                        className: 'selection-anchor'
                    }
                }]);
            this.decorationId = newDecorationId[0];
            this.selectionAnchorSetContextKey.set(!!this.decorationId);
            alert(localize('anchorSet', "Anchor set at {0}:{1}", position.lineNumber, position.column));
        }
    };
    SelectionAnchorController.prototype.goToSelectionAnchor = function () {
        if (this.editor.hasModel() && this.decorationId) {
            var anchorPosition = this.editor.getModel().getDecorationRange(this.decorationId);
            if (anchorPosition) {
                this.editor.setPosition(anchorPosition.getStartPosition());
            }
        }
    };
    SelectionAnchorController.prototype.selectFromAnchorToCursor = function () {
        if (this.editor.hasModel() && this.decorationId) {
            var start = this.editor.getModel().getDecorationRange(this.decorationId);
            if (start) {
                var end = this.editor.getPosition();
                this.editor.setSelection(Selection.fromPositions(start.getStartPosition(), end));
                this.cancelSelectionAnchor();
            }
        }
    };
    SelectionAnchorController.prototype.cancelSelectionAnchor = function () {
        if (this.decorationId) {
            this.editor.deltaDecorations([this.decorationId], []);
            this.decorationId = undefined;
            this.selectionAnchorSetContextKey.set(false);
        }
    };
    SelectionAnchorController.prototype.dispose = function () {
        this.cancelSelectionAnchor();
        this.modelChangeListener.dispose();
    };
    SelectionAnchorController.ID = 'editor.contrib.selectionAnchorController';
    SelectionAnchorController = __decorate([
        __param(1, IContextKeyService)
    ], SelectionAnchorController);
    return SelectionAnchorController;
}());
var SetSelectionAnchor = /** @class */ (function (_super) {
    __extends(SetSelectionAnchor, _super);
    function SetSelectionAnchor() {
        return _super.call(this, {
            id: 'editor.action.setSelectionAnchor',
            label: localize('setSelectionAnchor', "Set Selection Anchor"),
            alias: 'Set Selection Anchor',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: KeyChord(2048 /* CtrlCmd */ | 41 /* KEY_K */, 2048 /* CtrlCmd */ | 32 /* KEY_B */),
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    SetSelectionAnchor.prototype.run = function (_accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                controller = SelectionAnchorController.get(editor);
                controller.setSelectionAnchor();
                return [2 /*return*/];
            });
        });
    };
    return SetSelectionAnchor;
}(EditorAction));
var GoToSelectionAnchor = /** @class */ (function (_super) {
    __extends(GoToSelectionAnchor, _super);
    function GoToSelectionAnchor() {
        return _super.call(this, {
            id: 'editor.action.goToSelectionAnchor',
            label: localize('goToSelectionAnchor', "Go to Selection Anchor"),
            alias: 'Go to Selection Anchor',
            precondition: SelectionAnchorSet,
        }) || this;
    }
    GoToSelectionAnchor.prototype.run = function (_accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                controller = SelectionAnchorController.get(editor);
                controller.goToSelectionAnchor();
                return [2 /*return*/];
            });
        });
    };
    return GoToSelectionAnchor;
}(EditorAction));
var SelectFromAnchorToCursor = /** @class */ (function (_super) {
    __extends(SelectFromAnchorToCursor, _super);
    function SelectFromAnchorToCursor() {
        return _super.call(this, {
            id: 'editor.action.selectFromAnchorToCursor',
            label: localize('selectFromAnchorToCursor', "Select from Anchor to Cursor"),
            alias: 'Select from Anchor to Cursor',
            precondition: SelectionAnchorSet,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: KeyChord(2048 /* CtrlCmd */ | 41 /* KEY_K */, 2048 /* CtrlCmd */ | 41 /* KEY_K */),
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    SelectFromAnchorToCursor.prototype.run = function (_accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                controller = SelectionAnchorController.get(editor);
                controller.selectFromAnchorToCursor();
                return [2 /*return*/];
            });
        });
    };
    return SelectFromAnchorToCursor;
}(EditorAction));
var CancelSelectionAnchor = /** @class */ (function (_super) {
    __extends(CancelSelectionAnchor, _super);
    function CancelSelectionAnchor() {
        return _super.call(this, {
            id: 'editor.action.cancelSelectionAnchor',
            label: localize('cancelSelectionAnchor', "Cancel Selection Anchor"),
            alias: 'Cancel Selection Anchor',
            precondition: SelectionAnchorSet,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: 9 /* Escape */,
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    CancelSelectionAnchor.prototype.run = function (_accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                controller = SelectionAnchorController.get(editor);
                controller.cancelSelectionAnchor();
                return [2 /*return*/];
            });
        });
    };
    return CancelSelectionAnchor;
}(EditorAction));
registerEditorContribution(SelectionAnchorController.ID, SelectionAnchorController);
registerEditorAction(SetSelectionAnchor);
registerEditorAction(GoToSelectionAnchor);
registerEditorAction(SelectFromAnchorToCursor);
registerEditorAction(CancelSelectionAnchor);
