/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as strings from '../../../base/common/strings';
import { ReplaceCommand } from '../commands/replaceCommand';
import { CursorColumns, EditOperationResult, isQuote } from './cursorCommon';
import { MoveOperations } from './cursorMoveOperations';
import { Range } from '../core/range';
var DeleteOperations = /** @class */ (function () {
    function DeleteOperations() {
    }
    DeleteOperations.deleteRight = function (prevEditOperationType, config, model, selections) {
        var commands = [];
        var shouldPushStackElementBefore = (prevEditOperationType !== 3 /* DeletingRight */);
        for (var i = 0, len = selections.length; i < len; i++) {
            var selection = selections[i];
            var deleteSelection = selection;
            if (deleteSelection.isEmpty()) {
                var position = selection.getPosition();
                var rightOfPosition = MoveOperations.right(config, model, position.lineNumber, position.column);
                deleteSelection = new Range(rightOfPosition.lineNumber, rightOfPosition.column, position.lineNumber, position.column);
            }
            if (deleteSelection.isEmpty()) {
                // Probably at end of file => ignore
                commands[i] = null;
                continue;
            }
            if (deleteSelection.startLineNumber !== deleteSelection.endLineNumber) {
                shouldPushStackElementBefore = true;
            }
            commands[i] = new ReplaceCommand(deleteSelection, '');
        }
        return [shouldPushStackElementBefore, commands];
    };
    DeleteOperations.isAutoClosingPairDelete = function (autoClosingBrackets, autoClosingQuotes, autoClosingPairsOpen, model, selections) {
        var e_1, _a;
        if (autoClosingBrackets === 'never' && autoClosingQuotes === 'never') {
            return false;
        }
        for (var i = 0, len = selections.length; i < len; i++) {
            var selection = selections[i];
            var position = selection.getPosition();
            if (!selection.isEmpty()) {
                return false;
            }
            var lineText = model.getLineContent(position.lineNumber);
            if (position.column < 2 || position.column >= lineText.length + 1) {
                return false;
            }
            var character = lineText.charAt(position.column - 2);
            var autoClosingPairCandidates = autoClosingPairsOpen.get(character);
            if (!autoClosingPairCandidates) {
                return false;
            }
            if (isQuote(character)) {
                if (autoClosingQuotes === 'never') {
                    return false;
                }
            }
            else {
                if (autoClosingBrackets === 'never') {
                    return false;
                }
            }
            var afterCharacter = lineText.charAt(position.column - 1);
            var foundAutoClosingPair = false;
            try {
                for (var autoClosingPairCandidates_1 = (e_1 = void 0, __values(autoClosingPairCandidates)), autoClosingPairCandidates_1_1 = autoClosingPairCandidates_1.next(); !autoClosingPairCandidates_1_1.done; autoClosingPairCandidates_1_1 = autoClosingPairCandidates_1.next()) {
                    var autoClosingPairCandidate = autoClosingPairCandidates_1_1.value;
                    if (autoClosingPairCandidate.open === character && autoClosingPairCandidate.close === afterCharacter) {
                        foundAutoClosingPair = true;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (autoClosingPairCandidates_1_1 && !autoClosingPairCandidates_1_1.done && (_a = autoClosingPairCandidates_1.return)) _a.call(autoClosingPairCandidates_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (!foundAutoClosingPair) {
                return false;
            }
        }
        return true;
    };
    DeleteOperations._runAutoClosingPairDelete = function (config, model, selections) {
        var commands = [];
        for (var i = 0, len = selections.length; i < len; i++) {
            var position = selections[i].getPosition();
            var deleteSelection = new Range(position.lineNumber, position.column - 1, position.lineNumber, position.column + 1);
            commands[i] = new ReplaceCommand(deleteSelection, '');
        }
        return [true, commands];
    };
    DeleteOperations.deleteLeft = function (prevEditOperationType, config, model, selections) {
        if (this.isAutoClosingPairDelete(config.autoClosingBrackets, config.autoClosingQuotes, config.autoClosingPairs.autoClosingPairsOpenByEnd, model, selections)) {
            return this._runAutoClosingPairDelete(config, model, selections);
        }
        var commands = [];
        var shouldPushStackElementBefore = (prevEditOperationType !== 2 /* DeletingLeft */);
        for (var i = 0, len = selections.length; i < len; i++) {
            var selection = selections[i];
            var deleteSelection = selection;
            if (deleteSelection.isEmpty()) {
                var position = selection.getPosition();
                if (config.useTabStops && position.column > 1) {
                    var lineContent = model.getLineContent(position.lineNumber);
                    var firstNonWhitespaceIndex = strings.firstNonWhitespaceIndex(lineContent);
                    var lastIndentationColumn = (firstNonWhitespaceIndex === -1
                        ? /* entire string is whitespace */ lineContent.length + 1
                        : firstNonWhitespaceIndex + 1);
                    if (position.column <= lastIndentationColumn) {
                        var fromVisibleColumn = CursorColumns.visibleColumnFromColumn2(config, model, position);
                        var toVisibleColumn = CursorColumns.prevIndentTabStop(fromVisibleColumn, config.indentSize);
                        var toColumn = CursorColumns.columnFromVisibleColumn2(config, model, position.lineNumber, toVisibleColumn);
                        deleteSelection = new Range(position.lineNumber, toColumn, position.lineNumber, position.column);
                    }
                    else {
                        deleteSelection = new Range(position.lineNumber, position.column - 1, position.lineNumber, position.column);
                    }
                }
                else {
                    var leftOfPosition = MoveOperations.left(config, model, position.lineNumber, position.column);
                    deleteSelection = new Range(leftOfPosition.lineNumber, leftOfPosition.column, position.lineNumber, position.column);
                }
            }
            if (deleteSelection.isEmpty()) {
                // Probably at beginning of file => ignore
                commands[i] = null;
                continue;
            }
            if (deleteSelection.startLineNumber !== deleteSelection.endLineNumber) {
                shouldPushStackElementBefore = true;
            }
            commands[i] = new ReplaceCommand(deleteSelection, '');
        }
        return [shouldPushStackElementBefore, commands];
    };
    DeleteOperations.cut = function (config, model, selections) {
        var commands = [];
        for (var i = 0, len = selections.length; i < len; i++) {
            var selection = selections[i];
            if (selection.isEmpty()) {
                if (config.emptySelectionClipboard) {
                    // This is a full line cut
                    var position = selection.getPosition();
                    var startLineNumber = void 0, startColumn = void 0, endLineNumber = void 0, endColumn = void 0;
                    if (position.lineNumber < model.getLineCount()) {
                        // Cutting a line in the middle of the model
                        startLineNumber = position.lineNumber;
                        startColumn = 1;
                        endLineNumber = position.lineNumber + 1;
                        endColumn = 1;
                    }
                    else if (position.lineNumber > 1) {
                        // Cutting the last line & there are more than 1 lines in the model
                        startLineNumber = position.lineNumber - 1;
                        startColumn = model.getLineMaxColumn(position.lineNumber - 1);
                        endLineNumber = position.lineNumber;
                        endColumn = model.getLineMaxColumn(position.lineNumber);
                    }
                    else {
                        // Cutting the single line that the model contains
                        startLineNumber = position.lineNumber;
                        startColumn = 1;
                        endLineNumber = position.lineNumber;
                        endColumn = model.getLineMaxColumn(position.lineNumber);
                    }
                    var deleteSelection = new Range(startLineNumber, startColumn, endLineNumber, endColumn);
                    if (!deleteSelection.isEmpty()) {
                        commands[i] = new ReplaceCommand(deleteSelection, '');
                    }
                    else {
                        commands[i] = null;
                    }
                }
                else {
                    // Cannot cut empty selection
                    commands[i] = null;
                }
            }
            else {
                commands[i] = new ReplaceCommand(selection, '');
            }
        }
        return new EditOperationResult(0 /* Other */, commands, {
            shouldPushStackElementBefore: true,
            shouldPushStackElementAfter: true
        });
    };
    return DeleteOperations;
}());
export { DeleteOperations };
