/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import * as dom from '../../../base/browser/dom';
import * as platform from '../../../base/common/platform';
import { EventType, Gesture } from '../../../base/browser/touch';
import { Disposable } from '../../../base/common/lifecycle';
import { MouseHandler, createMouseMoveEventMerger } from './mouseHandler';
import { EditorMouseEvent, EditorPointerEventFactory } from '../editorDom';
import { BrowserFeatures } from '../../../base/browser/canIUse';
import { TextAreaSyntethicEvents } from './textAreaInput';
/**
 * Currently only tested on iOS 13/ iPadOS.
 */
var PointerEventHandler = /** @class */ (function (_super) {
    __extends(PointerEventHandler, _super);
    function PointerEventHandler(context, viewController, viewHelper) {
        var _this = _super.call(this, context, viewController, viewHelper) || this;
        _this._register(Gesture.addTarget(_this.viewHelper.linesContentDomNode));
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, EventType.Tap, function (e) { return _this.onTap(e); }));
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, EventType.Change, function (e) { return _this.onChange(e); }));
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, EventType.Contextmenu, function (e) { return _this._onContextMenu(new EditorMouseEvent(e, _this.viewHelper.viewDomNode), false); }));
        _this._lastPointerType = 'mouse';
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, 'pointerdown', function (e) {
            var pointerType = e.pointerType;
            if (pointerType === 'mouse') {
                _this._lastPointerType = 'mouse';
                return;
            }
            else if (pointerType === 'touch') {
                _this._lastPointerType = 'touch';
            }
            else {
                _this._lastPointerType = 'pen';
            }
        }));
        // PonterEvents
        var pointerEvents = new EditorPointerEventFactory(_this.viewHelper.viewDomNode);
        _this._register(pointerEvents.onPointerMoveThrottled(_this.viewHelper.viewDomNode, function (e) { return _this._onMouseMove(e); }, createMouseMoveEventMerger(_this.mouseTargetFactory), MouseHandler.MOUSE_MOVE_MINIMUM_TIME));
        _this._register(pointerEvents.onPointerUp(_this.viewHelper.viewDomNode, function (e) { return _this._onMouseUp(e); }));
        _this._register(pointerEvents.onPointerLeave(_this.viewHelper.viewDomNode, function (e) { return _this._onMouseLeave(e); }));
        _this._register(pointerEvents.onPointerDown(_this.viewHelper.viewDomNode, function (e) { return _this._onMouseDown(e); }));
        return _this;
    }
    PointerEventHandler.prototype.onTap = function (event) {
        if (!event.initialTarget || !this.viewHelper.linesContentDomNode.contains(event.initialTarget)) {
            return;
        }
        event.preventDefault();
        this.viewHelper.focusTextArea();
        var target = this._createMouseTarget(new EditorMouseEvent(event, this.viewHelper.viewDomNode), false);
        if (target.position) {
            // this.viewController.moveTo(target.position);
            this.viewController.dispatchMouse({
                position: target.position,
                mouseColumn: target.position.column,
                startedOnLineNumbers: false,
                mouseDownCount: event.tapCount,
                inSelectionMode: false,
                altKey: false,
                ctrlKey: false,
                metaKey: false,
                shiftKey: false,
                leftButton: false,
                middleButton: false,
            });
        }
    };
    PointerEventHandler.prototype.onChange = function (e) {
        if (this._lastPointerType === 'touch') {
            this._context.model.deltaScrollNow(-e.translationX, -e.translationY);
        }
    };
    PointerEventHandler.prototype._onMouseDown = function (e) {
        if (e.browserEvent.pointerType === 'touch') {
            return;
        }
        _super.prototype._onMouseDown.call(this, e);
    };
    return PointerEventHandler;
}(MouseHandler));
export { PointerEventHandler };
var TouchHandler = /** @class */ (function (_super) {
    __extends(TouchHandler, _super);
    function TouchHandler(context, viewController, viewHelper) {
        var _this = _super.call(this, context, viewController, viewHelper) || this;
        _this._register(Gesture.addTarget(_this.viewHelper.linesContentDomNode));
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, EventType.Tap, function (e) { return _this.onTap(e); }));
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, EventType.Change, function (e) { return _this.onChange(e); }));
        _this._register(dom.addDisposableListener(_this.viewHelper.linesContentDomNode, EventType.Contextmenu, function (e) { return _this._onContextMenu(new EditorMouseEvent(e, _this.viewHelper.viewDomNode), false); }));
        return _this;
    }
    TouchHandler.prototype.onTap = function (event) {
        event.preventDefault();
        this.viewHelper.focusTextArea();
        var target = this._createMouseTarget(new EditorMouseEvent(event, this.viewHelper.viewDomNode), false);
        if (target.position) {
            // Send the tap event also to the <textarea> (for input purposes)
            var event_1 = document.createEvent('CustomEvent');
            event_1.initEvent(TextAreaSyntethicEvents.Tap, false, true);
            this.viewHelper.dispatchTextAreaEvent(event_1);
            this.viewController.moveTo(target.position);
        }
    };
    TouchHandler.prototype.onChange = function (e) {
        this._context.model.deltaScrollNow(-e.translationX, -e.translationY);
    };
    return TouchHandler;
}(MouseHandler));
var PointerHandler = /** @class */ (function (_super) {
    __extends(PointerHandler, _super);
    function PointerHandler(context, viewController, viewHelper) {
        var _this = _super.call(this) || this;
        if ((platform.isIOS && BrowserFeatures.pointerEvents)) {
            _this.handler = _this._register(new PointerEventHandler(context, viewController, viewHelper));
        }
        else if (window.TouchEvent) {
            _this.handler = _this._register(new TouchHandler(context, viewController, viewHelper));
        }
        else {
            _this.handler = _this._register(new MouseHandler(context, viewController, viewHelper));
        }
        return _this;
    }
    PointerHandler.prototype.getTargetAtClientPoint = function (clientX, clientY) {
        return this.handler.getTargetAtClientPoint(clientX, clientY);
    };
    return PointerHandler;
}(Disposable));
export { PointerHandler };
