/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as strings from './strings';
import * as streams from './stream';
var hasBuffer = (typeof Buffer !== 'undefined');
var hasTextEncoder = (typeof TextEncoder !== 'undefined');
var hasTextDecoder = (typeof TextDecoder !== 'undefined');
var textEncoder;
var textDecoder;
var VSBuffer = /** @class */ (function () {
    function VSBuffer(buffer) {
        this.buffer = buffer;
        this.byteLength = this.buffer.byteLength;
    }
    VSBuffer.alloc = function (byteLength) {
        if (hasBuffer) {
            return new VSBuffer(Buffer.allocUnsafe(byteLength));
        }
        else {
            return new VSBuffer(new Uint8Array(byteLength));
        }
    };
    VSBuffer.wrap = function (actual) {
        if (hasBuffer && !(Buffer.isBuffer(actual))) {
            // https://nodejs.org/dist/latest-v10.x/docs/api/buffer.html#buffer_class_method_buffer_from_arraybuffer_byteoffset_length
            // Create a zero-copy Buffer wrapper around the ArrayBuffer pointed to by the Uint8Array
            actual = Buffer.from(actual.buffer, actual.byteOffset, actual.byteLength);
        }
        return new VSBuffer(actual);
    };
    VSBuffer.fromString = function (source, options) {
        var dontUseNodeBuffer = (options === null || options === void 0 ? void 0 : options.dontUseNodeBuffer) || false;
        if (!dontUseNodeBuffer && hasBuffer) {
            return new VSBuffer(Buffer.from(source));
        }
        else if (hasTextEncoder) {
            if (!textEncoder) {
                textEncoder = new TextEncoder();
            }
            return new VSBuffer(textEncoder.encode(source));
        }
        else {
            return new VSBuffer(strings.encodeUTF8(source));
        }
    };
    VSBuffer.concat = function (buffers, totalLength) {
        if (typeof totalLength === 'undefined') {
            totalLength = 0;
            for (var i = 0, len = buffers.length; i < len; i++) {
                totalLength += buffers[i].byteLength;
            }
        }
        var ret = VSBuffer.alloc(totalLength);
        var offset = 0;
        for (var i = 0, len = buffers.length; i < len; i++) {
            var element = buffers[i];
            ret.set(element, offset);
            offset += element.byteLength;
        }
        return ret;
    };
    VSBuffer.prototype.toString = function () {
        if (hasBuffer) {
            return this.buffer.toString();
        }
        else if (hasTextDecoder) {
            if (!textDecoder) {
                textDecoder = new TextDecoder();
            }
            return textDecoder.decode(this.buffer);
        }
        else {
            return strings.decodeUTF8(this.buffer);
        }
    };
    VSBuffer.prototype.slice = function (start, end) {
        // IMPORTANT: use subarray instead of slice because TypedArray#slice
        // creates shallow copy and NodeBuffer#slice doesn't. The use of subarray
        // ensures the same, performant, behaviour.
        return new VSBuffer(this.buffer.subarray(start /*bad lib.d.ts*/, end));
    };
    VSBuffer.prototype.set = function (array, offset) {
        if (array instanceof VSBuffer) {
            this.buffer.set(array.buffer, offset);
        }
        else {
            this.buffer.set(array, offset);
        }
    };
    VSBuffer.prototype.readUInt32BE = function (offset) {
        return readUInt32BE(this.buffer, offset);
    };
    VSBuffer.prototype.writeUInt32BE = function (value, offset) {
        writeUInt32BE(this.buffer, value, offset);
    };
    VSBuffer.prototype.readUInt32LE = function (offset) {
        return readUInt32LE(this.buffer, offset);
    };
    VSBuffer.prototype.writeUInt32LE = function (value, offset) {
        writeUInt32LE(this.buffer, value, offset);
    };
    VSBuffer.prototype.readUInt8 = function (offset) {
        return readUInt8(this.buffer, offset);
    };
    VSBuffer.prototype.writeUInt8 = function (value, offset) {
        writeUInt8(this.buffer, value, offset);
    };
    return VSBuffer;
}());
export { VSBuffer };
export function readUInt16LE(source, offset) {
    return (((source[offset + 0] << 0) >>> 0) |
        ((source[offset + 1] << 8) >>> 0));
}
export function writeUInt16LE(destination, value, offset) {
    destination[offset + 0] = (value & 255);
    value = value >>> 8;
    destination[offset + 1] = (value & 255);
}
export function readUInt32BE(source, offset) {
    return (source[offset] * Math.pow(2, 24)
        + source[offset + 1] * Math.pow(2, 16)
        + source[offset + 2] * Math.pow(2, 8)
        + source[offset + 3]);
}
export function writeUInt32BE(destination, value, offset) {
    destination[offset + 3] = value;
    value = value >>> 8;
    destination[offset + 2] = value;
    value = value >>> 8;
    destination[offset + 1] = value;
    value = value >>> 8;
    destination[offset] = value;
}
export function readUInt32LE(source, offset) {
    return (((source[offset + 0] << 0) >>> 0) |
        ((source[offset + 1] << 8) >>> 0) |
        ((source[offset + 2] << 16) >>> 0) |
        ((source[offset + 3] << 24) >>> 0));
}
export function writeUInt32LE(destination, value, offset) {
    destination[offset + 0] = (value & 255);
    value = value >>> 8;
    destination[offset + 1] = (value & 255);
    value = value >>> 8;
    destination[offset + 2] = (value & 255);
    value = value >>> 8;
    destination[offset + 3] = (value & 255);
}
export function readUInt8(source, offset) {
    return source[offset];
}
export function writeUInt8(destination, value, offset) {
    destination[offset] = value;
}
export function readableToBuffer(readable) {
    return streams.consumeReadable(readable, function (chunks) { return VSBuffer.concat(chunks); });
}
export function bufferToReadable(buffer) {
    return streams.toReadable(buffer);
}
export function streamToBuffer(stream) {
    return streams.consumeStream(stream, function (chunks) { return VSBuffer.concat(chunks); });
}
export function bufferedStreamToBuffer(bufferedStream) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, _b, _c;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    if (bufferedStream.ended) {
                        return [2 /*return*/, VSBuffer.concat(bufferedStream.buffer)];
                    }
                    _b = (_a = VSBuffer).concat;
                    _c = [__spreadArray([], __read(bufferedStream.buffer))];
                    // ...and all additional chunks
                    return [4 /*yield*/, streamToBuffer(bufferedStream.stream)];
                case 1: return [2 /*return*/, _b.apply(_a, [__spreadArray.apply(void 0, _c.concat([[
                                // ...and all additional chunks
                                _d.sent()
                            ]]))])];
            }
        });
    });
}
export function bufferToStream(buffer) {
    return streams.toStream(buffer, function (chunks) { return VSBuffer.concat(chunks); });
}
export function streamToBufferReadableStream(stream) {
    return streams.transform(stream, { data: function (data) { return typeof data === 'string' ? VSBuffer.fromString(data) : VSBuffer.wrap(data); } }, function (chunks) { return VSBuffer.concat(chunks); });
}
export function newWriteableBufferStream(options) {
    return streams.newWriteableStream(function (chunks) { return VSBuffer.concat(chunks); }, options);
}
