/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { Iterable } from '../../../common/iterator';
import { Event } from '../../../common/event';
import { TreeError, WeakMapper } from './tree';
import { ObjectTreeModel } from './objectTreeModel';
function noCompress(element) {
    var elements = [element.element];
    var incompressible = element.incompressible || false;
    return {
        element: { elements: elements, incompressible: incompressible },
        children: Iterable.map(Iterable.from(element.children), noCompress),
        collapsible: element.collapsible,
        collapsed: element.collapsed
    };
}
// Exported only for test reasons, do not use directly
export function compress(element) {
    var _a;
    var elements = [element.element];
    var incompressible = element.incompressible || false;
    var childrenIterator;
    var children;
    while (true) {
        _a = __read(Iterable.consume(Iterable.from(element.children), 2), 2), children = _a[0], childrenIterator = _a[1];
        if (children.length !== 1) {
            break;
        }
        if (children[0].incompressible) {
            break;
        }
        element = children[0];
        elements.push(element.element);
    }
    return {
        element: { elements: elements, incompressible: incompressible },
        children: Iterable.map(Iterable.concat(children, childrenIterator), compress),
        collapsible: element.collapsible,
        collapsed: element.collapsed
    };
}
function _decompress(element, index) {
    if (index === void 0) { index = 0; }
    var children;
    if (index < element.element.elements.length - 1) {
        children = [_decompress(element, index + 1)];
    }
    else {
        children = Iterable.map(Iterable.from(element.children), function (el) { return _decompress(el, 0); });
    }
    if (index === 0 && element.element.incompressible) {
        return {
            element: element.element.elements[index],
            children: children,
            incompressible: true,
            collapsible: element.collapsible,
            collapsed: element.collapsed
        };
    }
    return {
        element: element.element.elements[index],
        children: children,
        collapsible: element.collapsible,
        collapsed: element.collapsed
    };
}
// Exported only for test reasons, do not use directly
export function decompress(element) {
    return _decompress(element, 0);
}
function splice(treeElement, element, children) {
    if (treeElement.element === element) {
        return __assign(__assign({}, treeElement), { children: children });
    }
    return __assign(__assign({}, treeElement), { children: Iterable.map(Iterable.from(treeElement.children), function (e) { return splice(e, element, children); }) });
}
var wrapIdentityProvider = function (base) { return ({
    getId: function (node) {
        return node.elements.map(function (e) { return base.getId(e).toString(); }).join('\0');
    }
}); };
// Exported only for test reasons, do not use directly
var CompressedObjectTreeModel = /** @class */ (function () {
    function CompressedObjectTreeModel(user, list, options) {
        if (options === void 0) { options = {}; }
        this.user = user;
        this.rootRef = null;
        this.nodes = new Map();
        this.model = new ObjectTreeModel(user, list, options);
        this.enabled = typeof options.compressionEnabled === 'undefined' ? true : options.compressionEnabled;
        this.identityProvider = options.identityProvider;
    }
    Object.defineProperty(CompressedObjectTreeModel.prototype, "onDidSplice", {
        get: function () { return this.model.onDidSplice; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedObjectTreeModel.prototype, "onDidChangeCollapseState", {
        get: function () { return this.model.onDidChangeCollapseState; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedObjectTreeModel.prototype, "onDidChangeRenderNodeCount", {
        get: function () { return this.model.onDidChangeRenderNodeCount; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedObjectTreeModel.prototype, "size", {
        get: function () { return this.nodes.size; },
        enumerable: false,
        configurable: true
    });
    CompressedObjectTreeModel.prototype.setChildren = function (element, children, options) {
        // Diffs must be deem, since the compression can affect nested elements.
        // @see https://github.com/microsoft/vscode/pull/114237#issuecomment-759425034
        if (children === void 0) { children = Iterable.empty(); }
        var diffIdentityProvider = options.diffIdentityProvider && wrapIdentityProvider(options.diffIdentityProvider);
        if (element === null) {
            var compressedChildren = Iterable.map(children, this.enabled ? compress : noCompress);
            this._setChildren(null, compressedChildren, { diffIdentityProvider: diffIdentityProvider, diffDepth: Infinity });
            return;
        }
        var compressedNode = this.nodes.get(element);
        if (!compressedNode) {
            throw new Error('Unknown compressed tree node');
        }
        var node = this.model.getNode(compressedNode);
        var compressedParentNode = this.model.getParentNodeLocation(compressedNode);
        var parent = this.model.getNode(compressedParentNode);
        var decompressedElement = decompress(node);
        var splicedElement = splice(decompressedElement, element, children);
        var recompressedElement = (this.enabled ? compress : noCompress)(splicedElement);
        var parentChildren = parent.children
            .map(function (child) { return child === node ? recompressedElement : child; });
        this._setChildren(parent.element, parentChildren, {
            diffIdentityProvider: diffIdentityProvider,
            diffDepth: node.depth - parent.depth,
        });
    };
    CompressedObjectTreeModel.prototype.isCompressionEnabled = function () {
        return this.enabled;
    };
    CompressedObjectTreeModel.prototype.setCompressionEnabled = function (enabled) {
        if (enabled === this.enabled) {
            return;
        }
        this.enabled = enabled;
        var root = this.model.getNode();
        var rootChildren = root.children;
        var decompressedRootChildren = Iterable.map(rootChildren, decompress);
        var recompressedRootChildren = Iterable.map(decompressedRootChildren, enabled ? compress : noCompress);
        // it should be safe to always use deep diff mode here if an identity
        // provider is available, since we know the raw nodes are unchanged.
        this._setChildren(null, recompressedRootChildren, {
            diffIdentityProvider: this.identityProvider,
            diffDepth: Infinity,
        });
    };
    CompressedObjectTreeModel.prototype._setChildren = function (node, children, options) {
        var _this = this;
        var insertedElements = new Set();
        var onDidCreateNode = function (node) {
            var e_1, _a;
            try {
                for (var _b = __values(node.element.elements), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var element = _c.value;
                    insertedElements.add(element);
                    _this.nodes.set(element, node.element);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        };
        var onDidDeleteNode = function (node) {
            var e_2, _a;
            try {
                for (var _b = __values(node.element.elements), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var element = _c.value;
                    if (!insertedElements.has(element)) {
                        _this.nodes.delete(element);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
        };
        this.model.setChildren(node, children, __assign(__assign({}, options), { onDidCreateNode: onDidCreateNode, onDidDeleteNode: onDidDeleteNode }));
    };
    CompressedObjectTreeModel.prototype.has = function (element) {
        return this.nodes.has(element);
    };
    CompressedObjectTreeModel.prototype.getListIndex = function (location) {
        var node = this.getCompressedNode(location);
        return this.model.getListIndex(node);
    };
    CompressedObjectTreeModel.prototype.getListRenderCount = function (location) {
        var node = this.getCompressedNode(location);
        return this.model.getListRenderCount(node);
    };
    CompressedObjectTreeModel.prototype.getNode = function (location) {
        if (typeof location === 'undefined') {
            return this.model.getNode();
        }
        var node = this.getCompressedNode(location);
        return this.model.getNode(node);
    };
    // TODO: review this
    CompressedObjectTreeModel.prototype.getNodeLocation = function (node) {
        var compressedNode = this.model.getNodeLocation(node);
        if (compressedNode === null) {
            return null;
        }
        return compressedNode.elements[compressedNode.elements.length - 1];
    };
    // TODO: review this
    CompressedObjectTreeModel.prototype.getParentNodeLocation = function (location) {
        var compressedNode = this.getCompressedNode(location);
        var parentNode = this.model.getParentNodeLocation(compressedNode);
        if (parentNode === null) {
            return null;
        }
        return parentNode.elements[parentNode.elements.length - 1];
    };
    CompressedObjectTreeModel.prototype.getFirstElementChild = function (location) {
        var compressedNode = this.getCompressedNode(location);
        return this.model.getFirstElementChild(compressedNode);
    };
    CompressedObjectTreeModel.prototype.getLastElementAncestor = function (location) {
        var compressedNode = typeof location === 'undefined' ? undefined : this.getCompressedNode(location);
        return this.model.getLastElementAncestor(compressedNode);
    };
    CompressedObjectTreeModel.prototype.isCollapsible = function (location) {
        var compressedNode = this.getCompressedNode(location);
        return this.model.isCollapsible(compressedNode);
    };
    CompressedObjectTreeModel.prototype.setCollapsible = function (location, collapsible) {
        var compressedNode = this.getCompressedNode(location);
        return this.model.setCollapsible(compressedNode, collapsible);
    };
    CompressedObjectTreeModel.prototype.isCollapsed = function (location) {
        var compressedNode = this.getCompressedNode(location);
        return this.model.isCollapsed(compressedNode);
    };
    CompressedObjectTreeModel.prototype.setCollapsed = function (location, collapsed, recursive) {
        var compressedNode = this.getCompressedNode(location);
        return this.model.setCollapsed(compressedNode, collapsed, recursive);
    };
    CompressedObjectTreeModel.prototype.expandTo = function (location) {
        var compressedNode = this.getCompressedNode(location);
        this.model.expandTo(compressedNode);
    };
    CompressedObjectTreeModel.prototype.rerender = function (location) {
        var compressedNode = this.getCompressedNode(location);
        this.model.rerender(compressedNode);
    };
    CompressedObjectTreeModel.prototype.updateElementHeight = function (element, height) {
        var compressedNode = this.getCompressedNode(element);
        if (!compressedNode) {
            return;
        }
        this.model.updateElementHeight(compressedNode, height);
    };
    CompressedObjectTreeModel.prototype.refilter = function () {
        this.model.refilter();
    };
    CompressedObjectTreeModel.prototype.resort = function (location, recursive) {
        if (location === void 0) { location = null; }
        if (recursive === void 0) { recursive = true; }
        var compressedNode = this.getCompressedNode(location);
        this.model.resort(compressedNode, recursive);
    };
    CompressedObjectTreeModel.prototype.getCompressedNode = function (element) {
        if (element === null) {
            return null;
        }
        var node = this.nodes.get(element);
        if (!node) {
            throw new TreeError(this.user, "Tree element not found: " + element);
        }
        return node;
    };
    return CompressedObjectTreeModel;
}());
export { CompressedObjectTreeModel };
export var DefaultElementMapper = function (elements) { return elements[elements.length - 1]; };
var CompressedTreeNodeWrapper = /** @class */ (function () {
    function CompressedTreeNodeWrapper(unwrapper, node) {
        this.unwrapper = unwrapper;
        this.node = node;
    }
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "element", {
        get: function () { return this.node.element === null ? null : this.unwrapper(this.node.element); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "children", {
        get: function () {
            var _this = this;
            return this.node.children.map(function (node) { return new CompressedTreeNodeWrapper(_this.unwrapper, node); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "depth", {
        get: function () { return this.node.depth; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "visibleChildrenCount", {
        get: function () { return this.node.visibleChildrenCount; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "visibleChildIndex", {
        get: function () { return this.node.visibleChildIndex; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "collapsible", {
        get: function () { return this.node.collapsible; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "collapsed", {
        get: function () { return this.node.collapsed; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "visible", {
        get: function () { return this.node.visible; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressedTreeNodeWrapper.prototype, "filterData", {
        get: function () { return this.node.filterData; },
        enumerable: false,
        configurable: true
    });
    return CompressedTreeNodeWrapper;
}());
function mapList(nodeMapper, list) {
    return {
        splice: function (start, deleteCount, toInsert) {
            list.splice(start, deleteCount, toInsert.map(function (node) { return nodeMapper.map(node); }));
        },
        updateElementHeight: function (index, height) {
            list.updateElementHeight(index, height);
        }
    };
}
function mapOptions(compressedNodeUnwrapper, options) {
    return __assign(__assign({}, options), { identityProvider: options.identityProvider && {
            getId: function (node) {
                return options.identityProvider.getId(compressedNodeUnwrapper(node));
            }
        }, sorter: options.sorter && {
            compare: function (node, otherNode) {
                return options.sorter.compare(node.elements[0], otherNode.elements[0]);
            }
        }, filter: options.filter && {
            filter: function (node, parentVisibility) {
                return options.filter.filter(compressedNodeUnwrapper(node), parentVisibility);
            }
        } });
}
var CompressibleObjectTreeModel = /** @class */ (function () {
    function CompressibleObjectTreeModel(user, list, options) {
        var _this = this;
        if (options === void 0) { options = {}; }
        this.rootRef = null;
        this.elementMapper = options.elementMapper || DefaultElementMapper;
        var compressedNodeUnwrapper = function (node) { return _this.elementMapper(node.elements); };
        this.nodeMapper = new WeakMapper(function (node) { return new CompressedTreeNodeWrapper(compressedNodeUnwrapper, node); });
        this.model = new CompressedObjectTreeModel(user, mapList(this.nodeMapper, list), mapOptions(compressedNodeUnwrapper, options));
    }
    Object.defineProperty(CompressibleObjectTreeModel.prototype, "onDidSplice", {
        get: function () {
            var _this = this;
            return Event.map(this.model.onDidSplice, function (_a) {
                var insertedNodes = _a.insertedNodes, deletedNodes = _a.deletedNodes;
                return ({
                    insertedNodes: insertedNodes.map(function (node) { return _this.nodeMapper.map(node); }),
                    deletedNodes: deletedNodes.map(function (node) { return _this.nodeMapper.map(node); }),
                });
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressibleObjectTreeModel.prototype, "onDidChangeCollapseState", {
        get: function () {
            var _this = this;
            return Event.map(this.model.onDidChangeCollapseState, function (_a) {
                var node = _a.node, deep = _a.deep;
                return ({
                    node: _this.nodeMapper.map(node),
                    deep: deep
                });
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CompressibleObjectTreeModel.prototype, "onDidChangeRenderNodeCount", {
        get: function () {
            var _this = this;
            return Event.map(this.model.onDidChangeRenderNodeCount, function (node) { return _this.nodeMapper.map(node); });
        },
        enumerable: false,
        configurable: true
    });
    CompressibleObjectTreeModel.prototype.setChildren = function (element, children, options) {
        if (children === void 0) { children = Iterable.empty(); }
        if (options === void 0) { options = {}; }
        this.model.setChildren(element, children, options);
    };
    CompressibleObjectTreeModel.prototype.isCompressionEnabled = function () {
        return this.model.isCompressionEnabled();
    };
    CompressibleObjectTreeModel.prototype.setCompressionEnabled = function (enabled) {
        this.model.setCompressionEnabled(enabled);
    };
    CompressibleObjectTreeModel.prototype.has = function (location) {
        return this.model.has(location);
    };
    CompressibleObjectTreeModel.prototype.getListIndex = function (location) {
        return this.model.getListIndex(location);
    };
    CompressibleObjectTreeModel.prototype.getListRenderCount = function (location) {
        return this.model.getListRenderCount(location);
    };
    CompressibleObjectTreeModel.prototype.getNode = function (location) {
        return this.nodeMapper.map(this.model.getNode(location));
    };
    CompressibleObjectTreeModel.prototype.getNodeLocation = function (node) {
        return node.element;
    };
    CompressibleObjectTreeModel.prototype.getParentNodeLocation = function (location) {
        return this.model.getParentNodeLocation(location);
    };
    CompressibleObjectTreeModel.prototype.getFirstElementChild = function (location) {
        var result = this.model.getFirstElementChild(location);
        if (result === null || typeof result === 'undefined') {
            return result;
        }
        return this.elementMapper(result.elements);
    };
    CompressibleObjectTreeModel.prototype.getLastElementAncestor = function (location) {
        var result = this.model.getLastElementAncestor(location);
        if (result === null || typeof result === 'undefined') {
            return result;
        }
        return this.elementMapper(result.elements);
    };
    CompressibleObjectTreeModel.prototype.isCollapsible = function (location) {
        return this.model.isCollapsible(location);
    };
    CompressibleObjectTreeModel.prototype.setCollapsible = function (location, collapsed) {
        return this.model.setCollapsible(location, collapsed);
    };
    CompressibleObjectTreeModel.prototype.isCollapsed = function (location) {
        return this.model.isCollapsed(location);
    };
    CompressibleObjectTreeModel.prototype.setCollapsed = function (location, collapsed, recursive) {
        return this.model.setCollapsed(location, collapsed, recursive);
    };
    CompressibleObjectTreeModel.prototype.expandTo = function (location) {
        return this.model.expandTo(location);
    };
    CompressibleObjectTreeModel.prototype.rerender = function (location) {
        return this.model.rerender(location);
    };
    CompressibleObjectTreeModel.prototype.updateElementHeight = function (element, height) {
        this.model.updateElementHeight(element, height);
    };
    CompressibleObjectTreeModel.prototype.refilter = function () {
        return this.model.refilter();
    };
    CompressibleObjectTreeModel.prototype.resort = function (element, recursive) {
        if (element === void 0) { element = null; }
        if (recursive === void 0) { recursive = true; }
        return this.model.resort(element, recursive);
    };
    CompressibleObjectTreeModel.prototype.getCompressedTreeNode = function (location) {
        if (location === void 0) { location = null; }
        return this.model.getNode(location);
    };
    return CompressibleObjectTreeModel;
}());
export { CompressibleObjectTreeModel };
