/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import './table.css';
import { List } from '../list/listWidget';
import { $, append, clearNode, createStyleSheet, getContentHeight, getContentWidth } from '../../dom';
import { SplitView } from '../splitview/splitview';
import { Emitter, Event } from '../../../common/event';
var TableListRenderer = /** @class */ (function () {
    function TableListRenderer(columns, renderers, getColumnSize) {
        var e_1, _a;
        this.columns = columns;
        this.getColumnSize = getColumnSize;
        this.templateId = TableListRenderer.TemplateId;
        this.renderedTemplates = new Set();
        var rendererMap = new Map(renderers.map(function (r) { return [r.templateId, r]; }));
        this.renderers = [];
        try {
            for (var columns_1 = __values(columns), columns_1_1 = columns_1.next(); !columns_1_1.done; columns_1_1 = columns_1.next()) {
                var column = columns_1_1.value;
                var renderer = rendererMap.get(column.templateId);
                if (!renderer) {
                    throw new Error("Table cell renderer for template id " + column.templateId + " not found.");
                }
                this.renderers.push(renderer);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (columns_1_1 && !columns_1_1.done && (_a = columns_1.return)) _a.call(columns_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    TableListRenderer.prototype.renderTemplate = function (container) {
        var rowContainer = append(container, $('.monaco-table-tr'));
        var cellContainers = [];
        var cellTemplateData = [];
        for (var i = 0; i < this.columns.length; i++) {
            var renderer = this.renderers[i];
            var cellContainer = append(rowContainer, $('.monaco-table-td', { 'data-col-index': i }));
            cellContainer.style.width = this.getColumnSize(i) + "px";
            cellContainers.push(cellContainer);
            cellTemplateData.push(renderer.renderTemplate(cellContainer));
        }
        var result = { container: container, cellContainers: cellContainers, cellTemplateData: cellTemplateData };
        this.renderedTemplates.add(result);
        return result;
    };
    TableListRenderer.prototype.renderElement = function (element, index, templateData, height) {
        for (var i = 0; i < this.columns.length; i++) {
            var column = this.columns[i];
            var cell = column.project(element);
            var renderer = this.renderers[i];
            renderer.renderElement(cell, index, templateData.cellTemplateData[i], height);
        }
    };
    TableListRenderer.prototype.disposeElement = function (element, index, templateData, height) {
        for (var i = 0; i < this.columns.length; i++) {
            var renderer = this.renderers[i];
            if (renderer.disposeElement) {
                var column = this.columns[i];
                var cell = column.project(element);
                renderer.disposeElement(cell, index, templateData.cellTemplateData[i], height);
            }
        }
    };
    TableListRenderer.prototype.disposeTemplate = function (templateData) {
        for (var i = 0; i < this.columns.length; i++) {
            var renderer = this.renderers[i];
            renderer.disposeTemplate(templateData.cellTemplateData[i]);
        }
        clearNode(templateData.container);
        this.renderedTemplates.delete(templateData);
    };
    TableListRenderer.prototype.layoutColumn = function (index, size) {
        var e_2, _a;
        try {
            for (var _b = __values(this.renderedTemplates), _c = _b.next(); !_c.done; _c = _b.next()) {
                var cellContainers = _c.value.cellContainers;
                cellContainers[index].style.width = size + "px";
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    TableListRenderer.TemplateId = 'row';
    return TableListRenderer;
}());
function asListVirtualDelegate(delegate) {
    return {
        getHeight: function (row) { return delegate.getHeight(row); },
        getTemplateId: function () { return TableListRenderer.TemplateId; },
    };
}
var ColumnHeader = /** @class */ (function () {
    function ColumnHeader(column, index) {
        this.column = column;
        this.index = index;
        this._onDidLayout = new Emitter();
        this.onDidLayout = this._onDidLayout.event;
        this.element = $('.monaco-table-th', { 'data-col-index': index, title: column.tooltip }, column.label);
    }
    Object.defineProperty(ColumnHeader.prototype, "minimumSize", {
        get: function () { var _a; return (_a = this.column.minimumWidth) !== null && _a !== void 0 ? _a : 120; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ColumnHeader.prototype, "maximumSize", {
        get: function () { var _a; return (_a = this.column.maximumWidth) !== null && _a !== void 0 ? _a : Number.POSITIVE_INFINITY; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ColumnHeader.prototype, "onDidChange", {
        get: function () { var _a; return (_a = this.column.onDidChangeWidthConstraints) !== null && _a !== void 0 ? _a : Event.None; },
        enumerable: false,
        configurable: true
    });
    ColumnHeader.prototype.layout = function (size) {
        this._onDidLayout.fire([this.index, size]);
    };
    return ColumnHeader;
}());
var Table = /** @class */ (function () {
    function Table(user, container, virtualDelegate, columns, renderers, _options) {
        var _this = this;
        this.virtualDelegate = virtualDelegate;
        this.domId = "table_id_" + ++Table.InstanceCount;
        this.cachedHeight = 0;
        this.domNode = append(container, $(".monaco-table." + this.domId));
        var headers = columns.map(function (c, i) { return new ColumnHeader(c, i); });
        var descriptor = {
            size: headers.reduce(function (a, b) { return a + b.column.weight; }, 0),
            views: headers.map(function (view) { return ({ size: view.column.weight, view: view }); })
        };
        this.splitview = new SplitView(this.domNode, {
            orientation: 1 /* HORIZONTAL */,
            scrollbarVisibility: 2 /* Hidden */,
            getSashOrthogonalSize: function () { return _this.cachedHeight; },
            descriptor: descriptor
        });
        this.splitview.el.style.height = virtualDelegate.headerRowHeight + "px";
        this.splitview.el.style.lineHeight = virtualDelegate.headerRowHeight + "px";
        var renderer = new TableListRenderer(columns, renderers, function (i) { return _this.splitview.getViewSize(i); });
        this.list = new List(user, this.domNode, asListVirtualDelegate(virtualDelegate), [renderer], _options);
        this.columnLayoutDisposable = Event.any.apply(Event, __spreadArray([], __read(headers.map(function (h) { return h.onDidLayout; }))))(function (_a) {
            var _b = __read(_a, 2), index = _b[0], size = _b[1];
            return renderer.layoutColumn(index, size);
        });
        this.styleElement = createStyleSheet(this.domNode);
        this.style({});
    }
    Object.defineProperty(Table.prototype, "onDidChangeFocus", {
        get: function () { return this.list.onDidChangeFocus; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onDidChangeSelection", {
        get: function () { return this.list.onDidChangeSelection; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onDidScroll", {
        get: function () { return this.list.onDidScroll; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseClick", {
        get: function () { return this.list.onMouseClick; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseDblClick", {
        get: function () { return this.list.onMouseDblClick; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseMiddleClick", {
        get: function () { return this.list.onMouseMiddleClick; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onPointer", {
        get: function () { return this.list.onPointer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseUp", {
        get: function () { return this.list.onMouseUp; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseDown", {
        get: function () { return this.list.onMouseDown; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseOver", {
        get: function () { return this.list.onMouseOver; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseMove", {
        get: function () { return this.list.onMouseMove; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onMouseOut", {
        get: function () { return this.list.onMouseOut; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onTouchStart", {
        get: function () { return this.list.onTouchStart; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onTap", {
        get: function () { return this.list.onTap; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onContextMenu", {
        get: function () { return this.list.onContextMenu; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onDidFocus", {
        get: function () { return this.list.onDidFocus; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onDidBlur", {
        get: function () { return this.list.onDidBlur; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "scrollTop", {
        get: function () { return this.list.scrollTop; },
        set: function (scrollTop) { this.list.scrollTop = scrollTop; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "scrollLeft", {
        get: function () { return this.list.scrollLeft; },
        set: function (scrollLeft) { this.list.scrollLeft = scrollLeft; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "scrollHeight", {
        get: function () { return this.list.scrollHeight; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "renderHeight", {
        get: function () { return this.list.renderHeight; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Table.prototype, "onDidDispose", {
        get: function () { return this.list.onDidDispose; },
        enumerable: false,
        configurable: true
    });
    Table.prototype.updateOptions = function (options) {
        this.list.updateOptions(options);
    };
    Table.prototype.splice = function (start, deleteCount, elements) {
        if (elements === void 0) { elements = []; }
        this.list.splice(start, deleteCount, elements);
    };
    Table.prototype.rerender = function () {
        this.list.rerender();
    };
    Table.prototype.row = function (index) {
        return this.list.element(index);
    };
    Table.prototype.indexOf = function (element) {
        return this.list.indexOf(element);
    };
    Object.defineProperty(Table.prototype, "length", {
        get: function () {
            return this.list.length;
        },
        enumerable: false,
        configurable: true
    });
    Table.prototype.getHTMLElement = function () {
        return this.domNode;
    };
    Table.prototype.layout = function (height, width) {
        height = height !== null && height !== void 0 ? height : getContentHeight(this.domNode);
        width = width !== null && width !== void 0 ? width : getContentWidth(this.domNode);
        this.cachedHeight = height;
        this.splitview.layout(width);
        this.list.layout(height - this.virtualDelegate.headerRowHeight, width);
    };
    Table.prototype.toggleKeyboardNavigation = function () {
        this.list.toggleKeyboardNavigation();
    };
    Table.prototype.style = function (styles) {
        var content = [];
        content.push(".monaco-table." + this.domId + " > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\ttop: " + (this.virtualDelegate.headerRowHeight + 1) + "px;\n\t\t\theight: calc(100% - " + this.virtualDelegate.headerRowHeight + "px);\n\t\t}");
        this.styleElement.textContent = content.join('\n');
        this.list.style(styles);
    };
    Table.prototype.domFocus = function () {
        this.list.domFocus();
    };
    Table.prototype.getSelectedElements = function () {
        return this.list.getSelectedElements();
    };
    Table.prototype.setSelection = function (indexes, browserEvent) {
        this.list.setSelection(indexes, browserEvent);
    };
    Table.prototype.getSelection = function () {
        return this.list.getSelection();
    };
    Table.prototype.setFocus = function (indexes, browserEvent) {
        this.list.setFocus(indexes, browserEvent);
    };
    Table.prototype.focusNext = function (n, loop, browserEvent) {
        if (n === void 0) { n = 1; }
        if (loop === void 0) { loop = false; }
        this.list.focusNext(n, loop, browserEvent);
    };
    Table.prototype.focusPrevious = function (n, loop, browserEvent) {
        if (n === void 0) { n = 1; }
        if (loop === void 0) { loop = false; }
        this.list.focusPrevious(n, loop, browserEvent);
    };
    Table.prototype.focusNextPage = function (browserEvent) {
        this.list.focusNextPage(browserEvent);
    };
    Table.prototype.focusPreviousPage = function (browserEvent) {
        this.list.focusPreviousPage(browserEvent);
    };
    Table.prototype.focusFirst = function (browserEvent) {
        this.list.focusFirst(browserEvent);
    };
    Table.prototype.focusLast = function (browserEvent) {
        this.list.focusLast(browserEvent);
    };
    Table.prototype.getFocus = function () {
        return this.list.getFocus();
    };
    Table.prototype.reveal = function (index, relativeTop) {
        this.list.reveal(index, relativeTop);
    };
    Table.prototype.dispose = function () {
        this.splitview.dispose();
        this.list.dispose();
        this.columnLayoutDisposable.dispose();
    };
    Table.InstanceCount = 0;
    return Table;
}());
export { Table };
