/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { StandardWheelEvent } from '../../mouseEvent';
import { AbstractScrollbar } from './abstractScrollbar';
import { ARROW_IMG_SIZE } from './scrollbarArrow';
import { ScrollbarState } from './scrollbarState';
import { Codicon, registerCodicon } from '../../../common/codicons';
var scrollbarButtonLeftIcon = registerCodicon('scrollbar-button-left', Codicon.triangleLeft);
var scrollbarButtonRightIcon = registerCodicon('scrollbar-button-right', Codicon.triangleRight);
var HorizontalScrollbar = /** @class */ (function (_super) {
    __extends(HorizontalScrollbar, _super);
    function HorizontalScrollbar(scrollable, options, host) {
        var _this = this;
        var scrollDimensions = scrollable.getScrollDimensions();
        var scrollPosition = scrollable.getCurrentScrollPosition();
        _this = _super.call(this, {
            lazyRender: options.lazyRender,
            host: host,
            scrollbarState: new ScrollbarState((options.horizontalHasArrows ? options.arrowSize : 0), (options.horizontal === 2 /* Hidden */ ? 0 : options.horizontalScrollbarSize), (options.vertical === 2 /* Hidden */ ? 0 : options.verticalScrollbarSize), scrollDimensions.width, scrollDimensions.scrollWidth, scrollPosition.scrollLeft),
            visibility: options.horizontal,
            extraScrollbarClassName: 'horizontal',
            scrollable: scrollable,
            scrollByPage: options.scrollByPage
        }) || this;
        if (options.horizontalHasArrows) {
            var arrowDelta = (options.arrowSize - ARROW_IMG_SIZE) / 2;
            var scrollbarDelta = (options.horizontalScrollbarSize - ARROW_IMG_SIZE) / 2;
            _this._createArrow({
                className: 'scra',
                icon: scrollbarButtonLeftIcon,
                top: scrollbarDelta,
                left: arrowDelta,
                bottom: undefined,
                right: undefined,
                bgWidth: options.arrowSize,
                bgHeight: options.horizontalScrollbarSize,
                onActivate: function () { return _this._host.onMouseWheel(new StandardWheelEvent(null, 1, 0)); },
            });
            _this._createArrow({
                className: 'scra',
                icon: scrollbarButtonRightIcon,
                top: scrollbarDelta,
                left: undefined,
                bottom: undefined,
                right: arrowDelta,
                bgWidth: options.arrowSize,
                bgHeight: options.horizontalScrollbarSize,
                onActivate: function () { return _this._host.onMouseWheel(new StandardWheelEvent(null, -1, 0)); },
            });
        }
        _this._createSlider(Math.floor((options.horizontalScrollbarSize - options.horizontalSliderSize) / 2), 0, undefined, options.horizontalSliderSize);
        return _this;
    }
    HorizontalScrollbar.prototype._updateSlider = function (sliderSize, sliderPosition) {
        this.slider.setWidth(sliderSize);
        this.slider.setLeft(sliderPosition);
    };
    HorizontalScrollbar.prototype._renderDomNode = function (largeSize, smallSize) {
        this.domNode.setWidth(largeSize);
        this.domNode.setHeight(smallSize);
        this.domNode.setLeft(0);
        this.domNode.setBottom(0);
    };
    HorizontalScrollbar.prototype.onDidScroll = function (e) {
        this._shouldRender = this._onElementScrollSize(e.scrollWidth) || this._shouldRender;
        this._shouldRender = this._onElementScrollPosition(e.scrollLeft) || this._shouldRender;
        this._shouldRender = this._onElementSize(e.width) || this._shouldRender;
        return this._shouldRender;
    };
    HorizontalScrollbar.prototype._mouseDownRelativePosition = function (offsetX, offsetY) {
        return offsetX;
    };
    HorizontalScrollbar.prototype._sliderMousePosition = function (e) {
        return e.posx;
    };
    HorizontalScrollbar.prototype._sliderOrthogonalMousePosition = function (e) {
        return e.posy;
    };
    HorizontalScrollbar.prototype._updateScrollbarSize = function (size) {
        this.slider.setHeight(size);
    };
    HorizontalScrollbar.prototype.writeScrollPosition = function (target, scrollPosition) {
        target.scrollLeft = scrollPosition;
    };
    return HorizontalScrollbar;
}(AbstractScrollbar));
export { HorizontalScrollbar };
