/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as dom from '../../dom';
import { CSSIcon } from '../../../common/codicons';
var labelWithIconsRegex = new RegExp("(\\\\)?\\$\\((" + CSSIcon.iconNameExpression + "(?:" + CSSIcon.iconModifierExpression + ")?)\\)", 'g');
export function renderLabelWithIcons(text) {
    var elements = new Array();
    var match;
    var textStart = 0, textStop = 0;
    while ((match = labelWithIconsRegex.exec(text)) !== null) {
        textStop = match.index || 0;
        elements.push(text.substring(textStart, textStop));
        textStart = (match.index || 0) + match[0].length;
        var _a = __read(match, 3), escaped = _a[1], codicon = _a[2];
        elements.push(escaped ? "$(" + codicon + ")" : renderIcon({ id: codicon }));
    }
    if (textStart < text.length) {
        elements.push(text.substring(textStart));
    }
    return elements;
}
export function renderIcon(icon) {
    var _a;
    var node = dom.$("span");
    (_a = node.classList).add.apply(_a, __spreadArray([], __read(CSSIcon.asClassNameArray(icon))));
    return node;
}
