"use strict";
/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadTranslations = void 0;
const nls_1 = require("../common/nls");
const endpoint_1 = require("./endpoint");
async function loadTranslations() {
    if (nls_1.nls.locale) {
        const endpoint = new endpoint_1.Endpoint({ path: '/i18n/' + nls_1.nls.locale }).getRestUrl().toString();
        const response = await fetch(endpoint);
        nls_1.nls.localization = await response.json();
    }
}
exports.loadTranslations = loadTranslations;
//# sourceMappingURL=nls-loader.js.map