"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DecorationStyle = void 0;
var DecorationStyle;
(function (DecorationStyle) {
    function createStyleSheet(styleId, container = document.getElementsByTagName('head')[0]) {
        const style = document.createElement('style');
        style.id = styleId;
        style.type = 'text/css';
        style.media = 'screen';
        style.appendChild(document.createTextNode('')); // trick for webkit
        container.appendChild(style);
        return style.sheet;
    }
    DecorationStyle.createStyleSheet = createStyleSheet;
    function getRuleIndex(selector, styleSheet) {
        return Array.from(styleSheet.cssRules || styleSheet.rules).findIndex(rule => rule.type === CSSRule.STYLE_RULE && rule.selectorText === selector);
    }
    function getOrCreateStyleRule(selector, styleSheet) {
        let index = getRuleIndex(selector, styleSheet);
        if (index === -1) {
            // The given selector does not exist in the provided independent style sheet, rule index = 0
            index = styleSheet.insertRule(selector + '{}', 0);
        }
        const rules = styleSheet.cssRules || styleSheet.rules;
        const rule = rules[index];
        if (rule && rule.type === CSSRule.STYLE_RULE) {
            return rule;
        }
        styleSheet.deleteRule(index);
        throw new Error('This function is only for CSS style rules. Other types of CSS rules are not allowed.');
    }
    DecorationStyle.getOrCreateStyleRule = getOrCreateStyleRule;
    function deleteStyleRule(selector, styleSheet) {
        if (!styleSheet) {
            return;
        }
        // In general, only one rule exists for a given selector in the provided independent style sheet
        const index = getRuleIndex(selector, styleSheet);
        if (index !== -1) {
            styleSheet.deleteRule(index);
        }
    }
    DecorationStyle.deleteStyleRule = deleteStyleRule;
})(DecorationStyle = exports.DecorationStyle || (exports.DecorationStyle = {}));
//# sourceMappingURL=decoration-style.js.map