"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TheiaBlueprintGettingStartedWidget = void 0;
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
const React = require("react");
const inversify_1 = require("@theia/core/shared/inversify");
const branding_util_1 = require("./branding-util");
const getting_started_widget_1 = require("@theia/getting-started/lib/browser/getting-started-widget");
const vsx_environment_1 = require("@theia/vsx-registry/lib/common/vsx-environment");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
let TheiaBlueprintGettingStartedWidget = class TheiaBlueprintGettingStartedWidget extends getting_started_widget_1.GettingStartedWidget {
    async init() {
        super.init();
        this.vscodeApiVersion = await this.environment.getVscodeApiVersion();
        this.update();
    }
    render() {
        return React.createElement("div", { className: 'gs-container' },
            React.createElement("div", { className: 'gs-float' },
                React.createElement("div", { className: 'gs-logo' }),
                this.renderActions()),
            this.renderHeader(),
            React.createElement("hr", { className: 'gs-hr' }),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, branding_util_1.renderWhatIs(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, branding_util_1.renderWhatIsNot())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, branding_util_1.renderTickets(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, branding_util_1.renderSourceCode(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, branding_util_1.renderDocumentation(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, branding_util_1.renderDownloads())));
    }
    renderActions() {
        return React.createElement("div", { className: 'gs-container' },
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderOpen())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderRecentWorkspaces())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderSettings())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderHelp())));
    }
    renderHeader() {
        return React.createElement("div", { className: 'gs-header' },
            React.createElement("h1", null,
                "Eclipse Theia ",
                React.createElement("span", { className: 'gs-blue-header' }, "Blueprint")),
            this.renderVersion());
    }
    renderVersion() {
        return React.createElement("div", null,
            React.createElement("p", { className: 'gs-sub-header' }, this.applicationInfo ? 'Version ' + this.applicationInfo.version + ' (Beta)' : '(Beta)'),
            React.createElement("p", { className: 'gs-sub-header' }, 'VS Code API Version: ' + this.vscodeApiVersion));
    }
};
__decorate([
    inversify_1.inject(vsx_environment_1.VSXEnvironment),
    __metadata("design:type", vsx_environment_1.VSXEnvironment)
], TheiaBlueprintGettingStartedWidget.prototype, "environment", void 0);
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], TheiaBlueprintGettingStartedWidget.prototype, "windowService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TheiaBlueprintGettingStartedWidget.prototype, "init", null);
TheiaBlueprintGettingStartedWidget = __decorate([
    inversify_1.injectable()
], TheiaBlueprintGettingStartedWidget);
exports.TheiaBlueprintGettingStartedWidget = TheiaBlueprintGettingStartedWidget;
//# sourceMappingURL=theia-blueprint-getting-started-widget.js.map