"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedPluginServerImpl = void 0;
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
const inversify_1 = require("@theia/core/shared/inversify");
const plugin_protocol_1 = require("../../common/plugin-protocol");
const hosted_plugin_1 = require("./hosted-plugin");
const core_1 = require("@theia/core");
const core_2 = require("@theia/core");
const plugin_ext_api_contribution_1 = require("../../common/plugin-ext-api-contribution");
const hosted_plugin_deployer_handler_1 = require("./hosted-plugin-deployer-handler");
const plugin_deployer_impl_1 = require("../../main/node/plugin-deployer-impl");
const localization_provider_1 = require("@theia/core/lib/node/i18n/localization-provider");
const plugin_manifest_loader_1 = require("./plugin-manifest-loader");
let HostedPluginServerImpl = class HostedPluginServerImpl {
    constructor(hostedPlugin) {
        this.hostedPlugin = hostedPlugin;
    }
    init() {
        this.deployedListener = this.pluginDeployer.onDidDeploy(() => {
            if (this.client) {
                this.client.onDidDeploy();
            }
        });
    }
    dispose() {
        this.hostedPlugin.clientClosed();
        this.deployedListener.dispose();
    }
    setClient(client) {
        this.client = client;
        this.hostedPlugin.setClient(client);
    }
    async getDeployedPluginIds() {
        const backendMetadata = await this.deployerHandler.getDeployedBackendPluginIds();
        if (backendMetadata.length > 0) {
            this.hostedPlugin.runPluginServer();
        }
        const plugins = new Set();
        for (const pluginId of await this.deployerHandler.getDeployedFrontendPluginIds()) {
            plugins.add(pluginId);
        }
        for (const pluginId of backendMetadata) {
            plugins.add(pluginId);
        }
        for (const pluginId of await this.hostedPlugin.getExtraDeployedPluginIds()) {
            plugins.add(pluginId);
        }
        return [...plugins.values()];
    }
    async getDeployedPlugins({ pluginIds }) {
        if (!pluginIds.length) {
            return [];
        }
        const locale = this.localizationProvider.getCurrentLanguage();
        const plugins = [];
        let extraDeployedPlugins;
        for (const pluginId of pluginIds) {
            let plugin = this.deployerHandler.getDeployedPlugin(pluginId);
            if (!plugin) {
                if (!extraDeployedPlugins) {
                    extraDeployedPlugins = new Map();
                    for (const extraDeployedPlugin of await this.hostedPlugin.getExtraDeployedPlugins()) {
                        extraDeployedPlugins.set(extraDeployedPlugin.metadata.model.id, extraDeployedPlugin);
                    }
                }
                plugin = extraDeployedPlugins.get(pluginId);
            }
            if (plugin) {
                plugins.push(await this.localizePlugin(plugin, locale));
            }
        }
        return plugins;
    }
    onMessage(pluginHostId, message) {
        this.hostedPlugin.onMessage(pluginHostId, message);
        return Promise.resolve();
    }
    getExtPluginAPI() {
        return Promise.resolve(this.extPluginAPIContributions.getContributions().map(p => p.provideApi()));
    }
    async localizePlugin(plugin, locale) {
        const packagePath = plugin.metadata.model.packagePath;
        const translatedManifest = await plugin_manifest_loader_1.loadManifest(packagePath, locale);
        this.mergeContributes(plugin.contributes, translatedManifest.contributes);
        return plugin;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    mergeContributes(main, other) {
        if (main && other) {
            if (Array.isArray(main) && Array.isArray(other)) {
                for (let i = 0; i < main.length && i < other.length; i++) {
                    if (typeof main[i] === 'object' && typeof other[i] === 'object') {
                        this.mergeContributes(main[i], other[i]);
                    }
                }
            }
            else {
                for (const [key, value] of Object.entries(main)) {
                    if (key in other) {
                        if (typeof value === 'string') {
                            main[key] = other[key];
                        }
                        else if (typeof value === 'object' && typeof other[key] === 'object') {
                            this.mergeContributes(main[key], other[key]);
                        }
                    }
                }
            }
        }
    }
};
__decorate([
    inversify_1.inject(core_1.ILogger),
    __metadata("design:type", Object)
], HostedPluginServerImpl.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(hosted_plugin_deployer_handler_1.HostedPluginDeployerHandler),
    __metadata("design:type", hosted_plugin_deployer_handler_1.HostedPluginDeployerHandler)
], HostedPluginServerImpl.prototype, "deployerHandler", void 0);
__decorate([
    inversify_1.inject(plugin_protocol_1.PluginDeployer),
    __metadata("design:type", plugin_deployer_impl_1.PluginDeployerImpl)
], HostedPluginServerImpl.prototype, "pluginDeployer", void 0);
__decorate([
    inversify_1.inject(localization_provider_1.LocalizationProvider),
    __metadata("design:type", localization_provider_1.LocalizationProvider)
], HostedPluginServerImpl.prototype, "localizationProvider", void 0);
__decorate([
    inversify_1.inject(core_2.ContributionProvider),
    inversify_1.named(Symbol.for(plugin_ext_api_contribution_1.ExtPluginApiProvider)),
    __metadata("design:type", Object)
], HostedPluginServerImpl.prototype, "extPluginAPIContributions", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], HostedPluginServerImpl.prototype, "init", null);
HostedPluginServerImpl = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(hosted_plugin_1.HostedPluginSupport)),
    __metadata("design:paramtypes", [hosted_plugin_1.HostedPluginSupport])
], HostedPluginServerImpl);
exports.HostedPluginServerImpl = HostedPluginServerImpl;
//# sourceMappingURL=plugin-service.js.map