/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { IQuickInputService, ItemActivation } from '../common/quickInput';
import { Disposable, DisposableStore, toDisposable } from '../../../base/common/lifecycle';
import { Extensions, DefaultQuickAccessFilterValue } from '../common/quickAccess';
import { Registry } from '../../registry/common/platform';
import { CancellationTokenSource } from '../../../base/common/cancellation';
import { IInstantiationService } from '../../instantiation/common/instantiation';
import { once } from '../../../base/common/functional';
var QuickAccessController = /** @class */ (function (_super) {
    __extends(QuickAccessController, _super);
    function QuickAccessController(quickInputService, instantiationService) {
        var _this = _super.call(this) || this;
        _this.quickInputService = quickInputService;
        _this.instantiationService = instantiationService;
        _this.registry = Registry.as(Extensions.Quickaccess);
        _this.mapProviderToDescriptor = new Map();
        _this.lastAcceptedPickerValues = new Map();
        _this.visibleQuickAccess = undefined;
        return _this;
    }
    QuickAccessController.prototype.show = function (value, options) {
        var _a;
        if (value === void 0) { value = ''; }
        // Find provider for the value to show
        var _b = __read(this.getOrInstantiateProvider(value), 2), provider = _b[0], descriptor = _b[1];
        // Return early if quick access is already showing on that same prefix
        var visibleQuickAccess = this.visibleQuickAccess;
        var visibleDescriptor = visibleQuickAccess === null || visibleQuickAccess === void 0 ? void 0 : visibleQuickAccess.descriptor;
        if (visibleQuickAccess && descriptor && visibleDescriptor === descriptor) {
            // Apply value only if it is more specific than the prefix
            // from the provider and we are not instructed to preserve
            if (value !== descriptor.prefix && !(options === null || options === void 0 ? void 0 : options.preserveValue)) {
                visibleQuickAccess.picker.value = value;
            }
            // Always adjust selection
            this.adjustValueSelection(visibleQuickAccess.picker, descriptor, options);
            return;
        }
        // Rewrite the filter value based on certain rules unless disabled
        if (descriptor && !(options === null || options === void 0 ? void 0 : options.preserveValue)) {
            var newValue = undefined;
            // If we have a visible provider with a value, take it's filter value but
            // rewrite to new provider prefix in case they differ
            if (visibleQuickAccess && visibleDescriptor && visibleDescriptor !== descriptor) {
                var newValueCandidateWithoutPrefix = visibleQuickAccess.value.substr(visibleDescriptor.prefix.length);
                if (newValueCandidateWithoutPrefix) {
                    newValue = "" + descriptor.prefix + newValueCandidateWithoutPrefix;
                }
            }
            // Otherwise, take a default value as instructed
            if (!newValue) {
                var defaultFilterValue = provider === null || provider === void 0 ? void 0 : provider.defaultFilterValue;
                if (defaultFilterValue === DefaultQuickAccessFilterValue.LAST) {
                    newValue = this.lastAcceptedPickerValues.get(descriptor);
                }
                else if (typeof defaultFilterValue === 'string') {
                    newValue = "" + descriptor.prefix + defaultFilterValue;
                }
            }
            if (typeof newValue === 'string') {
                value = newValue;
            }
        }
        // Create a picker for the provider to use with the initial value
        // and adjust the filtering to exclude the prefix from filtering
        var disposables = new DisposableStore();
        var picker = disposables.add(this.quickInputService.createQuickPick());
        picker.value = value;
        this.adjustValueSelection(picker, descriptor, options);
        picker.placeholder = descriptor === null || descriptor === void 0 ? void 0 : descriptor.placeholder;
        picker.quickNavigate = options === null || options === void 0 ? void 0 : options.quickNavigateConfiguration;
        picker.hideInput = !!picker.quickNavigate && !visibleQuickAccess; // only hide input if there was no picker opened already
        if (typeof (options === null || options === void 0 ? void 0 : options.itemActivation) === 'number' || (options === null || options === void 0 ? void 0 : options.quickNavigateConfiguration)) {
            picker.itemActivation = (_a = options === null || options === void 0 ? void 0 : options.itemActivation) !== null && _a !== void 0 ? _a : ItemActivation.SECOND /* quick nav is always second */;
        }
        picker.contextKey = descriptor === null || descriptor === void 0 ? void 0 : descriptor.contextKey;
        picker.filterValue = function (value) { return value.substring(descriptor ? descriptor.prefix.length : 0); };
        if (descriptor === null || descriptor === void 0 ? void 0 : descriptor.placeholder) {
            picker.ariaLabel = descriptor === null || descriptor === void 0 ? void 0 : descriptor.placeholder;
        }
        // Register listeners
        var cancellationToken = this.registerPickerListeners(picker, provider, descriptor, value, disposables);
        // Ask provider to fill the picker as needed if we have one
        if (provider) {
            disposables.add(provider.provide(picker, cancellationToken));
        }
        // Finally, show the picker. This is important because a provider
        // may not call this and then our disposables would leak that rely
        // on the onDidHide event.
        picker.show();
    };
    QuickAccessController.prototype.adjustValueSelection = function (picker, descriptor, options) {
        var _a;
        var valueSelection;
        // Preserve: just always put the cursor at the end
        if (options === null || options === void 0 ? void 0 : options.preserveValue) {
            valueSelection = [picker.value.length, picker.value.length];
        }
        // Otherwise: select the value up until the prefix
        else {
            valueSelection = [(_a = descriptor === null || descriptor === void 0 ? void 0 : descriptor.prefix.length) !== null && _a !== void 0 ? _a : 0, picker.value.length];
        }
        picker.valueSelection = valueSelection;
    };
    QuickAccessController.prototype.registerPickerListeners = function (picker, provider, descriptor, value, disposables) {
        var _this = this;
        // Remember as last visible picker and clean up once picker get's disposed
        var visibleQuickAccess = this.visibleQuickAccess = { picker: picker, descriptor: descriptor, value: value };
        disposables.add(toDisposable(function () {
            if (visibleQuickAccess === _this.visibleQuickAccess) {
                _this.visibleQuickAccess = undefined;
            }
        }));
        // Whenever the value changes, check if the provider has
        // changed and if so - re-create the picker from the beginning
        disposables.add(picker.onDidChangeValue(function (value) {
            var _a = __read(_this.getOrInstantiateProvider(value), 1), providerForValue = _a[0];
            if (providerForValue !== provider) {
                _this.show(value, { preserveValue: true } /* do not rewrite value from user typing! */);
            }
            else {
                visibleQuickAccess.value = value; // remember the value in our visible one
            }
        }));
        // Remember picker input for future use when accepting
        if (descriptor) {
            disposables.add(picker.onDidAccept(function () {
                _this.lastAcceptedPickerValues.set(descriptor, picker.value);
            }));
        }
        // Create a cancellation token source that is valid as long as the
        // picker has not been closed without picking an item
        var cts = disposables.add(new CancellationTokenSource());
        once(picker.onDidHide)(function () {
            if (picker.selectedItems.length === 0) {
                cts.cancel();
            }
            // Start to dispose once picker hides
            disposables.dispose();
        });
        return cts.token;
    };
    QuickAccessController.prototype.getOrInstantiateProvider = function (value) {
        var providerDescriptor = this.registry.getQuickAccessProvider(value);
        if (!providerDescriptor) {
            return [undefined, undefined];
        }
        var provider = this.mapProviderToDescriptor.get(providerDescriptor);
        if (!provider) {
            provider = this.instantiationService.createInstance(providerDescriptor.ctor);
            this.mapProviderToDescriptor.set(providerDescriptor, provider);
        }
        return [provider, providerDescriptor];
    };
    QuickAccessController = __decorate([
        __param(0, IQuickInputService),
        __param(1, IInstantiationService)
    ], QuickAccessController);
    return QuickAccessController;
}(Disposable));
export { QuickAccessController };
