/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { createDecorator } from '../../instantiation/common/instantiation';
import { basename } from '../../../base/common/resources';
import { localize } from '../../../nls';
export var IDialogService = createDecorator('dialogService');
export var IFileDialogService = createDecorator('fileDialogService');
var MAX_CONFIRM_FILES = 10;
export function getFileNamesMessage(fileNamesOrResources) {
    var message = [];
    message.push.apply(message, __spreadArray([], __read(fileNamesOrResources.slice(0, MAX_CONFIRM_FILES).map(function (fileNameOrResource) { return typeof fileNameOrResource === 'string' ? fileNameOrResource : basename(fileNameOrResource); }))));
    if (fileNamesOrResources.length > MAX_CONFIRM_FILES) {
        if (fileNamesOrResources.length - MAX_CONFIRM_FILES === 1) {
            message.push(localize('moreFile', "...1 additional file not shown"));
        }
        else {
            message.push(localize('moreFiles', "...{0} additional files not shown", fileNamesOrResources.length - MAX_CONFIRM_FILES));
        }
    }
    message.push('');
    return message.join('\n');
}
