/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { Disposable } from '../../../base/common/lifecycle';
import { IBulkEditService } from '../../browser/services/bulkEditService';
import { ICodeEditorService } from '../../browser/services/codeEditorService';
import { IEditorWorkerService } from '../../common/services/editorWorkerService';
import { EditorWorkerServiceImpl } from '../../common/services/editorWorkerServiceImpl';
import { IModeService } from '../../common/services/modeService';
import { ModeServiceImpl } from '../../common/services/modeServiceImpl';
import { IModelService } from '../../common/services/modelService';
import { ModelServiceImpl } from '../../common/services/modelServiceImpl';
import { ITextResourceConfigurationService, ITextResourcePropertiesService } from '../../common/services/textResourceConfigurationService';
import { SimpleBulkEditService, SimpleConfigurationService, SimpleDialogService, SimpleNotificationService, SimpleEditorProgressService, SimpleResourceConfigurationService, SimpleResourcePropertiesService, SimpleUriLabelService, SimpleWorkspaceContextService, StandaloneCommandService, StandaloneKeybindingService, StandaloneTelemetryService, SimpleLayoutService } from './simpleServices';
import { StandaloneCodeEditorServiceImpl } from './standaloneCodeServiceImpl';
import { StandaloneThemeServiceImpl } from './standaloneThemeServiceImpl';
import { IStandaloneThemeService } from '../common/standaloneThemeService';
import { IMenuService } from '../../../platform/actions/common/actions';
import { ICommandService } from '../../../platform/commands/common/commands';
import { IConfigurationService } from '../../../platform/configuration/common/configuration';
import { ContextKeyService } from '../../../platform/contextkey/browser/contextKeyService';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { ContextMenuService } from '../../../platform/contextview/browser/contextMenuService';
import { IContextMenuService, IContextViewService } from '../../../platform/contextview/browser/contextView';
import { ContextViewService } from '../../../platform/contextview/browser/contextViewService';
import { IDialogService } from '../../../platform/dialogs/common/dialogs';
import { IInstantiationService, createDecorator } from '../../../platform/instantiation/common/instantiation';
import { InstantiationService } from '../../../platform/instantiation/common/instantiationService';
import { ServiceCollection } from '../../../platform/instantiation/common/serviceCollection';
import { IKeybindingService } from '../../../platform/keybinding/common/keybinding';
import { ILabelService } from '../../../platform/label/common/label';
import { IListService, ListService } from '../../../platform/list/browser/listService';
import { ConsoleLogger, ILogService, LogService } from '../../../platform/log/common/log';
import { MarkerService } from '../../../platform/markers/common/markerService';
import { IMarkerService } from '../../../platform/markers/common/markers';
import { INotificationService } from '../../../platform/notification/common/notification';
import { IEditorProgressService } from '../../../platform/progress/common/progress';
import { IStorageService, InMemoryStorageService } from '../../../platform/storage/common/storage';
import { ITelemetryService } from '../../../platform/telemetry/common/telemetry';
import { IThemeService } from '../../../platform/theme/common/themeService';
import { IWorkspaceContextService } from '../../../platform/workspace/common/workspace';
import { MenuService } from '../../../platform/actions/common/menuService';
import { IMarkerDecorationsService } from '../../common/services/markersDecorationService';
import { MarkerDecorationsService } from '../../common/services/markerDecorationsServiceImpl';
import { IAccessibilityService } from '../../../platform/accessibility/common/accessibility';
import { ILayoutService } from '../../../platform/layout/browser/layoutService';
import { getSingletonServiceDescriptors } from '../../../platform/instantiation/common/extensions';
import { AccessibilityService } from '../../../platform/accessibility/common/accessibilityService';
import { IClipboardService } from '../../../platform/clipboard/common/clipboardService';
import { BrowserClipboardService } from '../../../platform/clipboard/browser/clipboardService';
import { IUndoRedoService } from '../../../platform/undoRedo/common/undoRedo';
import { UndoRedoService } from '../../../platform/undoRedo/common/undoRedoService';
import { StandaloneQuickInputServiceImpl } from './quickInput/standaloneQuickInputServiceImpl';
import { IQuickInputService } from '../../../platform/quickinput/common/quickInput';
export var StaticServices;
(function (StaticServices) {
    var _serviceCollection = new ServiceCollection();
    var LazyStaticService = /** @class */ (function () {
        function LazyStaticService(serviceId, factory) {
            this._serviceId = serviceId;
            this._factory = factory;
            this._value = null;
        }
        Object.defineProperty(LazyStaticService.prototype, "id", {
            get: function () { return this._serviceId; },
            enumerable: false,
            configurable: true
        });
        LazyStaticService.prototype.get = function (overrides) {
            if (!this._value) {
                if (overrides) {
                    this._value = overrides[this._serviceId.toString()];
                }
                if (!this._value) {
                    this._value = this._factory(overrides);
                }
                if (!this._value) {
                    throw new Error('Service ' + this._serviceId + ' is missing!');
                }
                _serviceCollection.set(this._serviceId, this._value);
            }
            return this._value;
        };
        return LazyStaticService;
    }());
    StaticServices.LazyStaticService = LazyStaticService;
    var _all = [];
    function define(serviceId, factory) {
        var r = new LazyStaticService(serviceId, factory);
        _all.push(r);
        return r;
    }
    function init(overrides) {
        var e_1, _a;
        // Create a fresh service collection
        var result = new ServiceCollection();
        try {
            // make sure to add all services that use `registerSingleton`
            for (var _b = __values(getSingletonServiceDescriptors()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), id = _d[0], descriptor = _d[1];
                result.set(id, descriptor);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        // Initialize the service collection with the overrides
        for (var serviceId in overrides) {
            if (overrides.hasOwnProperty(serviceId)) {
                result.set(createDecorator(serviceId), overrides[serviceId]);
            }
        }
        // Make sure the same static services are present in all service collections
        _all.forEach(function (service) { return result.set(service.id, service.get(overrides)); });
        // Ensure the collection gets the correct instantiation service
        var instantiationService = new InstantiationService(result, true);
        result.set(IInstantiationService, instantiationService);
        return [result, instantiationService];
    }
    StaticServices.init = init;
    StaticServices.instantiationService = define(IInstantiationService, function () { return new InstantiationService(_serviceCollection, true); });
    var configurationServiceImpl = new SimpleConfigurationService();
    StaticServices.configurationService = define(IConfigurationService, function () { return configurationServiceImpl; });
    StaticServices.resourceConfigurationService = define(ITextResourceConfigurationService, function () { return new SimpleResourceConfigurationService(configurationServiceImpl); });
    StaticServices.resourcePropertiesService = define(ITextResourcePropertiesService, function () { return new SimpleResourcePropertiesService(configurationServiceImpl); });
    StaticServices.contextService = define(IWorkspaceContextService, function () { return new SimpleWorkspaceContextService(); });
    StaticServices.labelService = define(ILabelService, function () { return new SimpleUriLabelService(); });
    StaticServices.telemetryService = define(ITelemetryService, function () { return new StandaloneTelemetryService(); });
    StaticServices.dialogService = define(IDialogService, function () { return new SimpleDialogService(); });
    StaticServices.notificationService = define(INotificationService, function () { return new SimpleNotificationService(); });
    StaticServices.markerService = define(IMarkerService, function () { return new MarkerService(); });
    StaticServices.modeService = define(IModeService, function (o) { return new ModeServiceImpl(); });
    StaticServices.standaloneThemeService = define(IStandaloneThemeService, function () { return new StandaloneThemeServiceImpl(); });
    StaticServices.logService = define(ILogService, function () { return new LogService(new ConsoleLogger()); });
    StaticServices.undoRedoService = define(IUndoRedoService, function (o) { return new UndoRedoService(StaticServices.dialogService.get(o), StaticServices.notificationService.get(o)); });
    StaticServices.modelService = define(IModelService, function (o) { return new ModelServiceImpl(StaticServices.configurationService.get(o), StaticServices.resourcePropertiesService.get(o), StaticServices.standaloneThemeService.get(o), StaticServices.logService.get(o), StaticServices.undoRedoService.get(o)); });
    StaticServices.markerDecorationsService = define(IMarkerDecorationsService, function (o) { return new MarkerDecorationsService(StaticServices.modelService.get(o), StaticServices.markerService.get(o)); });
    StaticServices.contextKeyService = define(IContextKeyService, function (o) { return new ContextKeyService(StaticServices.configurationService.get(o)); });
    StaticServices.codeEditorService = define(ICodeEditorService, function (o) { return new StandaloneCodeEditorServiceImpl(null, StaticServices.contextKeyService.get(o), StaticServices.standaloneThemeService.get(o)); });
    StaticServices.editorProgressService = define(IEditorProgressService, function () { return new SimpleEditorProgressService(); });
    StaticServices.storageService = define(IStorageService, function () { return new InMemoryStorageService(); });
    StaticServices.editorWorkerService = define(IEditorWorkerService, function (o) { return new EditorWorkerServiceImpl(StaticServices.modelService.get(o), StaticServices.resourceConfigurationService.get(o), StaticServices.logService.get(o)); });
})(StaticServices || (StaticServices = {}));
var DynamicStandaloneServices = /** @class */ (function (_super) {
    __extends(DynamicStandaloneServices, _super);
    function DynamicStandaloneServices(domElement, overrides) {
        var _this = _super.call(this) || this;
        var _a = __read(StaticServices.init(overrides), 2), _serviceCollection = _a[0], _instantiationService = _a[1];
        _this._serviceCollection = _serviceCollection;
        _this._instantiationService = _instantiationService;
        var configurationService = _this.get(IConfigurationService);
        var notificationService = _this.get(INotificationService);
        var telemetryService = _this.get(ITelemetryService);
        var themeService = _this.get(IThemeService);
        var logService = _this.get(ILogService);
        var contextKeyService = _this.get(IContextKeyService);
        var ensure = function (serviceId, factory) {
            var value = null;
            if (overrides) {
                value = overrides[serviceId.toString()];
            }
            if (!value) {
                value = factory();
            }
            _this._serviceCollection.set(serviceId, value);
            return value;
        };
        ensure(IAccessibilityService, function () { return new AccessibilityService(contextKeyService, configurationService); });
        ensure(IListService, function () { return new ListService(themeService); });
        var commandService = ensure(ICommandService, function () { return new StandaloneCommandService(_this._instantiationService); });
        var keybindingService = ensure(IKeybindingService, function () { return _this._register(new StandaloneKeybindingService(contextKeyService, commandService, telemetryService, notificationService, logService, domElement)); });
        var layoutService = ensure(ILayoutService, function () { return new SimpleLayoutService(StaticServices.codeEditorService.get(ICodeEditorService), domElement); });
        ensure(IQuickInputService, function () { return new StandaloneQuickInputServiceImpl(_instantiationService, StaticServices.codeEditorService.get(ICodeEditorService)); });
        var contextViewService = ensure(IContextViewService, function () { return _this._register(new ContextViewService(layoutService)); });
        ensure(IClipboardService, function () { return new BrowserClipboardService(); });
        ensure(IContextMenuService, function () {
            var contextMenuService = new ContextMenuService(telemetryService, notificationService, contextViewService, keybindingService, themeService);
            contextMenuService.configure({ blockMouse: false }); // we do not want that in the standalone editor
            return _this._register(contextMenuService);
        });
        ensure(IMenuService, function () { return new MenuService(commandService); });
        ensure(IBulkEditService, function () { return new SimpleBulkEditService(StaticServices.modelService.get(IModelService)); });
        return _this;
    }
    DynamicStandaloneServices.prototype.get = function (serviceId) {
        var r = this._serviceCollection.get(serviceId);
        if (!r) {
            throw new Error('Missing service ' + serviceId);
        }
        return r;
    };
    DynamicStandaloneServices.prototype.set = function (serviceId, instance) {
        this._serviceCollection.set(serviceId, instance);
    };
    DynamicStandaloneServices.prototype.has = function (serviceId) {
        return this._serviceCollection.has(serviceId);
    };
    return DynamicStandaloneServices;
}(Disposable));
export { DynamicStandaloneServices };
