/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { windowOpenNoOpener } from '../../../base/browser/dom';
import { Schemas } from '../../../base/common/network';
import { CodeEditorServiceImpl } from '../../browser/services/codeEditorServiceImpl';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { IThemeService } from '../../../platform/theme/common/themeService';
var StandaloneCodeEditorServiceImpl = /** @class */ (function (_super) {
    __extends(StandaloneCodeEditorServiceImpl, _super);
    function StandaloneCodeEditorServiceImpl(styleSheet, contextKeyService, themeService) {
        var _this = _super.call(this, styleSheet, themeService) || this;
        _this.onCodeEditorAdd(function () { return _this._checkContextKey(); });
        _this.onCodeEditorRemove(function () { return _this._checkContextKey(); });
        _this._editorIsOpen = contextKeyService.createKey('editorIsOpen', false);
        return _this;
    }
    StandaloneCodeEditorServiceImpl.prototype._checkContextKey = function () {
        var e_1, _a;
        var hasCodeEditor = false;
        try {
            for (var _b = __values(this.listCodeEditors()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var editor = _c.value;
                if (!editor.isSimpleWidget) {
                    hasCodeEditor = true;
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._editorIsOpen.set(hasCodeEditor);
    };
    StandaloneCodeEditorServiceImpl.prototype.getActiveCodeEditor = function () {
        return null; // not supported in the standalone case
    };
    StandaloneCodeEditorServiceImpl.prototype.openCodeEditor = function (input, source, sideBySide) {
        if (!source) {
            return Promise.resolve(null);
        }
        return Promise.resolve(this.doOpenEditor(source, input));
    };
    StandaloneCodeEditorServiceImpl.prototype.doOpenEditor = function (editor, input) {
        var model = this.findModel(editor, input.resource);
        if (!model) {
            if (input.resource) {
                var schema = input.resource.scheme;
                if (schema === Schemas.http || schema === Schemas.https) {
                    // This is a fully qualified http or https URL
                    windowOpenNoOpener(input.resource.toString());
                    return editor;
                }
            }
            return null;
        }
        var selection = (input.options ? input.options.selection : null);
        if (selection) {
            if (typeof selection.endLineNumber === 'number' && typeof selection.endColumn === 'number') {
                editor.setSelection(selection);
                editor.revealRangeInCenter(selection, 1 /* Immediate */);
            }
            else {
                var pos = {
                    lineNumber: selection.startLineNumber,
                    column: selection.startColumn
                };
                editor.setPosition(pos);
                editor.revealPositionInCenter(pos, 1 /* Immediate */);
            }
        }
        return editor;
    };
    StandaloneCodeEditorServiceImpl.prototype.findModel = function (editor, resource) {
        var model = editor.getModel();
        if (model && model.uri.toString() !== resource.toString()) {
            return null;
        }
        return model;
    };
    StandaloneCodeEditorServiceImpl = __decorate([
        __param(1, IContextKeyService),
        __param(2, IThemeService)
    ], StandaloneCodeEditorServiceImpl);
    return StandaloneCodeEditorServiceImpl;
}(CodeEditorServiceImpl));
export { StandaloneCodeEditorServiceImpl };
