/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { RunOnceScheduler, createCancelablePromise } from '../../../base/common/async';
import { Disposable } from '../../../base/common/lifecycle';
import { registerEditorContribution } from '../../browser/editorExtensions';
import { DocumentRangeSemanticTokensProviderRegistry } from '../../common/modes';
import { IModelService } from '../../common/services/modelService';
import { toMultilineTokens2 } from '../../common/services/semanticTokensProviderStyling';
import { IThemeService } from '../../../platform/theme/common/themeService';
import { IConfigurationService } from '../../../platform/configuration/common/configuration';
import { isSemanticColoringEnabled, SEMANTIC_HIGHLIGHTING_SETTING_ID } from '../../common/services/modelServiceImpl';
import { getDocumentRangeSemanticTokensProvider } from '../../common/services/getSemanticTokens';
var ViewportSemanticTokensContribution = /** @class */ (function (_super) {
    __extends(ViewportSemanticTokensContribution, _super);
    function ViewportSemanticTokensContribution(editor, _modelService, _themeService, _configurationService) {
        var _this = _super.call(this) || this;
        _this._modelService = _modelService;
        _this._themeService = _themeService;
        _this._configurationService = _configurationService;
        _this._editor = editor;
        _this._tokenizeViewport = new RunOnceScheduler(function () { return _this._tokenizeViewportNow(); }, 100);
        _this._outstandingRequests = [];
        _this._register(_this._editor.onDidScrollChange(function () {
            _this._tokenizeViewport.schedule();
        }));
        _this._register(_this._editor.onDidChangeModel(function () {
            _this._cancelAll();
            _this._tokenizeViewport.schedule();
        }));
        _this._register(_this._editor.onDidChangeModelContent(function (e) {
            _this._cancelAll();
            _this._tokenizeViewport.schedule();
        }));
        _this._register(DocumentRangeSemanticTokensProviderRegistry.onDidChange(function () {
            _this._cancelAll();
            _this._tokenizeViewport.schedule();
        }));
        _this._register(_this._configurationService.onDidChangeConfiguration(function (e) {
            if (e.affectsConfiguration(SEMANTIC_HIGHLIGHTING_SETTING_ID)) {
                _this._cancelAll();
                _this._tokenizeViewport.schedule();
            }
        }));
        _this._register(_this._themeService.onDidColorThemeChange(function () {
            _this._cancelAll();
            _this._tokenizeViewport.schedule();
        }));
        return _this;
    }
    ViewportSemanticTokensContribution.get = function (editor) {
        return editor.getContribution(ViewportSemanticTokensContribution.ID);
    };
    ViewportSemanticTokensContribution.prototype._cancelAll = function () {
        var e_1, _a;
        try {
            for (var _b = __values(this._outstandingRequests), _c = _b.next(); !_c.done; _c = _b.next()) {
                var request = _c.value;
                request.cancel();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._outstandingRequests = [];
    };
    ViewportSemanticTokensContribution.prototype._removeOutstandingRequest = function (req) {
        for (var i = 0, len = this._outstandingRequests.length; i < len; i++) {
            if (this._outstandingRequests[i] === req) {
                this._outstandingRequests.splice(i, 1);
                return;
            }
        }
    };
    ViewportSemanticTokensContribution.prototype._tokenizeViewportNow = function () {
        var _this = this;
        if (!this._editor.hasModel()) {
            return;
        }
        var model = this._editor.getModel();
        if (model.hasCompleteSemanticTokens()) {
            return;
        }
        if (!isSemanticColoringEnabled(model, this._themeService, this._configurationService)) {
            if (model.hasSomeSemanticTokens()) {
                model.setSemanticTokens(null, false);
            }
            return;
        }
        var provider = getDocumentRangeSemanticTokensProvider(model);
        if (!provider) {
            if (model.hasSomeSemanticTokens()) {
                model.setSemanticTokens(null, false);
            }
            return;
        }
        var styling = this._modelService.getSemanticTokensProviderStyling(provider);
        var visibleRanges = this._editor.getVisibleRangesPlusViewportAboveBelow();
        this._outstandingRequests = this._outstandingRequests.concat(visibleRanges.map(function (range) { return _this._requestRange(model, range, provider, styling); }));
    };
    ViewportSemanticTokensContribution.prototype._requestRange = function (model, range, provider, styling) {
        var _this = this;
        var requestVersionId = model.getVersionId();
        var request = createCancelablePromise(function (token) { return Promise.resolve(provider.provideDocumentRangeSemanticTokens(model, range, token)); });
        request.then(function (r) {
            if (!r || model.isDisposed() || model.getVersionId() !== requestVersionId) {
                return;
            }
            model.setPartialSemanticTokens(range, toMultilineTokens2(r, styling, model.getLanguageIdentifier()));
        }).then(function () { return _this._removeOutstandingRequest(request); }, function () { return _this._removeOutstandingRequest(request); });
        return request;
    };
    ViewportSemanticTokensContribution.ID = 'editor.contrib.viewportSemanticTokens';
    ViewportSemanticTokensContribution = __decorate([
        __param(1, IModelService),
        __param(2, IThemeService),
        __param(3, IConfigurationService)
    ], ViewportSemanticTokensContribution);
    return ViewportSemanticTokensContribution;
}(Disposable));
registerEditorContribution(ViewportSemanticTokensContribution.ID, ViewportSemanticTokensContribution);
