/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { LRUCache, TernarySearchTree } from '../../../base/common/map';
import { IStorageService, WillSaveStateReason } from '../../../platform/storage/common/storage';
import { completionKindFromString } from '../../common/modes';
import { DisposableStore } from '../../../base/common/lifecycle';
import { RunOnceScheduler } from '../../../base/common/async';
import { createDecorator } from '../../../platform/instantiation/common/instantiation';
import { IConfigurationService } from '../../../platform/configuration/common/configuration';
import { registerSingleton } from '../../../platform/instantiation/common/extensions';
import { IModeService } from '../../common/services/modeService';
var Memory = /** @class */ (function () {
    function Memory(name) {
        this.name = name;
    }
    Memory.prototype.select = function (model, pos, items) {
        if (items.length === 0) {
            return 0;
        }
        var topScore = items[0].score[0];
        for (var i = 0; i < items.length; i++) {
            var _a = items[i], score = _a.score, suggestion = _a.completion;
            if (score[0] !== topScore) {
                // stop when leaving the group of top matches
                break;
            }
            if (suggestion.preselect) {
                // stop when seeing an auto-select-item
                return i;
            }
        }
        return 0;
    };
    return Memory;
}());
export { Memory };
var NoMemory = /** @class */ (function (_super) {
    __extends(NoMemory, _super);
    function NoMemory() {
        return _super.call(this, 'first') || this;
    }
    NoMemory.prototype.memorize = function (model, pos, item) {
        // no-op
    };
    NoMemory.prototype.toJSON = function () {
        return undefined;
    };
    NoMemory.prototype.fromJSON = function () {
        //
    };
    return NoMemory;
}(Memory));
export { NoMemory };
var LRUMemory = /** @class */ (function (_super) {
    __extends(LRUMemory, _super);
    function LRUMemory() {
        var _this = _super.call(this, 'recentlyUsed') || this;
        _this._cache = new LRUCache(300, 0.66);
        _this._seq = 0;
        return _this;
    }
    LRUMemory.prototype.memorize = function (model, pos, item) {
        var key = model.getLanguageIdentifier().language + "/" + item.textLabel;
        this._cache.set(key, {
            touch: this._seq++,
            type: item.completion.kind,
            insertText: item.completion.insertText
        });
    };
    LRUMemory.prototype.select = function (model, pos, items) {
        if (items.length === 0) {
            return 0;
        }
        var lineSuffix = model.getLineContent(pos.lineNumber).substr(pos.column - 10, pos.column - 1);
        if (/\s$/.test(lineSuffix)) {
            return _super.prototype.select.call(this, model, pos, items);
        }
        var topScore = items[0].score[0];
        var indexPreselect = -1;
        var indexRecency = -1;
        var seq = -1;
        for (var i = 0; i < items.length; i++) {
            if (items[i].score[0] !== topScore) {
                // consider only top items
                break;
            }
            var key = model.getLanguageIdentifier().language + "/" + items[i].textLabel;
            var item = this._cache.peek(key);
            if (item && item.touch > seq && item.type === items[i].completion.kind && item.insertText === items[i].completion.insertText) {
                seq = item.touch;
                indexRecency = i;
            }
            if (items[i].completion.preselect && indexPreselect === -1) {
                // stop when seeing an auto-select-item
                return indexPreselect = i;
            }
        }
        if (indexRecency !== -1) {
            return indexRecency;
        }
        else if (indexPreselect !== -1) {
            return indexPreselect;
        }
        else {
            return 0;
        }
    };
    LRUMemory.prototype.toJSON = function () {
        return this._cache.toJSON();
    };
    LRUMemory.prototype.fromJSON = function (data) {
        var e_1, _a;
        this._cache.clear();
        var seq = 0;
        try {
            for (var data_1 = __values(data), data_1_1 = data_1.next(); !data_1_1.done; data_1_1 = data_1.next()) {
                var _b = __read(data_1_1.value, 2), key = _b[0], value = _b[1];
                value.touch = seq;
                value.type = typeof value.type === 'number' ? value.type : completionKindFromString(value.type);
                this._cache.set(key, value);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (data_1_1 && !data_1_1.done && (_a = data_1.return)) _a.call(data_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._seq = this._cache.size;
    };
    return LRUMemory;
}(Memory));
export { LRUMemory };
var PrefixMemory = /** @class */ (function (_super) {
    __extends(PrefixMemory, _super);
    function PrefixMemory() {
        var _this = _super.call(this, 'recentlyUsedByPrefix') || this;
        _this._trie = TernarySearchTree.forStrings();
        _this._seq = 0;
        return _this;
    }
    PrefixMemory.prototype.memorize = function (model, pos, item) {
        var word = model.getWordUntilPosition(pos).word;
        var key = model.getLanguageIdentifier().language + "/" + word;
        this._trie.set(key, {
            type: item.completion.kind,
            insertText: item.completion.insertText,
            touch: this._seq++
        });
    };
    PrefixMemory.prototype.select = function (model, pos, items) {
        var word = model.getWordUntilPosition(pos).word;
        if (!word) {
            return _super.prototype.select.call(this, model, pos, items);
        }
        var key = model.getLanguageIdentifier().language + "/" + word;
        var item = this._trie.get(key);
        if (!item) {
            item = this._trie.findSubstr(key);
        }
        if (item) {
            for (var i = 0; i < items.length; i++) {
                var _a = items[i].completion, kind = _a.kind, insertText = _a.insertText;
                if (kind === item.type && insertText === item.insertText) {
                    return i;
                }
            }
        }
        return _super.prototype.select.call(this, model, pos, items);
    };
    PrefixMemory.prototype.toJSON = function () {
        var entries = [];
        this._trie.forEach(function (value, key) { return entries.push([key, value]); });
        // sort by last recently used (touch), then
        // take the top 200 item and normalize their
        // touch
        entries
            .sort(function (a, b) { return -(a[1].touch - b[1].touch); })
            .forEach(function (value, i) { return value[1].touch = i; });
        return entries.slice(0, 200);
    };
    PrefixMemory.prototype.fromJSON = function (data) {
        var e_2, _a;
        this._trie.clear();
        if (data.length > 0) {
            this._seq = data[0][1].touch + 1;
            try {
                for (var data_2 = __values(data), data_2_1 = data_2.next(); !data_2_1.done; data_2_1 = data_2.next()) {
                    var _b = __read(data_2_1.value, 2), key = _b[0], value = _b[1];
                    value.type = typeof value.type === 'number' ? value.type : completionKindFromString(value.type);
                    this._trie.set(key, value);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (data_2_1 && !data_2_1.done && (_a = data_2.return)) _a.call(data_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    };
    return PrefixMemory;
}(Memory));
export { PrefixMemory };
var SuggestMemoryService = /** @class */ (function () {
    function SuggestMemoryService(_storageService, _modeService, _configService) {
        var _this = this;
        this._storageService = _storageService;
        this._modeService = _modeService;
        this._configService = _configService;
        this._disposables = new DisposableStore();
        this._persistSoon = new RunOnceScheduler(function () { return _this._saveState(); }, 500);
        this._disposables.add(_storageService.onWillSaveState(function (e) {
            if (e.reason === WillSaveStateReason.SHUTDOWN) {
                _this._saveState();
            }
        }));
    }
    SuggestMemoryService.prototype.dispose = function () {
        this._disposables.dispose();
        this._persistSoon.dispose();
    };
    SuggestMemoryService.prototype.memorize = function (model, pos, item) {
        this._withStrategy(model, pos).memorize(model, pos, item);
        this._persistSoon.schedule();
    };
    SuggestMemoryService.prototype.select = function (model, pos, items) {
        return this._withStrategy(model, pos).select(model, pos, items);
    };
    SuggestMemoryService.prototype._withStrategy = function (model, pos) {
        var _a, _b;
        var mode = this._configService.getValue('editor.suggestSelection', {
            overrideIdentifier: (_a = this._modeService.getLanguageIdentifier(model.getLanguageIdAtPosition(pos.lineNumber, pos.column))) === null || _a === void 0 ? void 0 : _a.language,
            resource: model.uri
        });
        if (((_b = this._strategy) === null || _b === void 0 ? void 0 : _b.name) !== mode) {
            this._saveState();
            var ctor = SuggestMemoryService._strategyCtors.get(mode) || NoMemory;
            this._strategy = new ctor();
            try {
                var share = this._configService.getValue('editor.suggest.shareSuggestSelections');
                var scope = share ? 0 /* GLOBAL */ : 1 /* WORKSPACE */;
                var raw = this._storageService.get(SuggestMemoryService._storagePrefix + "/" + mode, scope);
                if (raw) {
                    this._strategy.fromJSON(JSON.parse(raw));
                }
            }
            catch (e) {
                // things can go wrong with JSON...
            }
        }
        return this._strategy;
    };
    SuggestMemoryService.prototype._saveState = function () {
        if (this._strategy) {
            var share = this._configService.getValue('editor.suggest.shareSuggestSelections');
            var scope = share ? 0 /* GLOBAL */ : 1 /* WORKSPACE */;
            var raw = JSON.stringify(this._strategy);
            this._storageService.store(SuggestMemoryService._storagePrefix + "/" + this._strategy.name, raw, scope, 1 /* MACHINE */);
        }
    };
    SuggestMemoryService._strategyCtors = new Map([
        ['recentlyUsedByPrefix', PrefixMemory],
        ['recentlyUsed', LRUMemory],
        ['first', NoMemory]
    ]);
    SuggestMemoryService._storagePrefix = 'suggest/memories';
    SuggestMemoryService = __decorate([
        __param(0, IStorageService),
        __param(1, IModeService),
        __param(2, IConfigurationService)
    ], SuggestMemoryService);
    return SuggestMemoryService;
}());
export { SuggestMemoryService };
export var ISuggestMemoryService = createDecorator('ISuggestMemories');
registerSingleton(ISuggestMemoryService, SuggestMemoryService, true);
