/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { IMarkerService, MarkerSeverity } from '../../../platform/markers/common/markers';
import { URI } from '../../../base/common/uri';
import { Emitter } from '../../../base/common/event';
import { DisposableStore, toDisposable } from '../../../base/common/lifecycle';
import { Range } from '../../common/core/range';
import { compare } from '../../../base/common/strings';
import { binarySearch } from '../../../base/common/arrays';
import { createDecorator } from '../../../platform/instantiation/common/instantiation';
import { registerSingleton } from '../../../platform/instantiation/common/extensions';
import { LinkedList } from '../../../base/common/linkedList';
var MarkerCoordinate = /** @class */ (function () {
    function MarkerCoordinate(marker, index, total) {
        this.marker = marker;
        this.index = index;
        this.total = total;
    }
    return MarkerCoordinate;
}());
export { MarkerCoordinate };
var MarkerList = /** @class */ (function () {
    function MarkerList(resourceFilter, _markerService) {
        var _this = this;
        this._markerService = _markerService;
        this._onDidChange = new Emitter();
        this.onDidChange = this._onDidChange.event;
        this._dispoables = new DisposableStore();
        this._markers = [];
        this._nextIdx = -1;
        if (URI.isUri(resourceFilter)) {
            this._resourceFilter = function (uri) { return uri.toString() === resourceFilter.toString(); };
        }
        else if (resourceFilter) {
            this._resourceFilter = resourceFilter;
        }
        var updateMarker = function () {
            _this._markers = _this._markerService.read({
                resource: URI.isUri(resourceFilter) ? resourceFilter : undefined,
                severities: MarkerSeverity.Error | MarkerSeverity.Warning | MarkerSeverity.Info
            });
            if (typeof resourceFilter === 'function') {
                _this._markers = _this._markers.filter(function (m) { return _this._resourceFilter(m.resource); });
            }
            _this._markers.sort(MarkerList._compareMarker);
        };
        updateMarker();
        this._dispoables.add(_markerService.onMarkerChanged(function (uris) {
            if (!_this._resourceFilter || uris.some(function (uri) { return _this._resourceFilter(uri); })) {
                updateMarker();
                _this._nextIdx = -1;
                _this._onDidChange.fire();
            }
        }));
    }
    MarkerList.prototype.dispose = function () {
        this._dispoables.dispose();
        this._onDidChange.dispose();
    };
    MarkerList.prototype.matches = function (uri) {
        if (!this._resourceFilter && !uri) {
            return true;
        }
        if (!this._resourceFilter || !uri) {
            return false;
        }
        return this._resourceFilter(uri);
    };
    Object.defineProperty(MarkerList.prototype, "selected", {
        get: function () {
            var marker = this._markers[this._nextIdx];
            return marker && new MarkerCoordinate(marker, this._nextIdx + 1, this._markers.length);
        },
        enumerable: false,
        configurable: true
    });
    MarkerList.prototype._initIdx = function (model, position, fwd) {
        var found = false;
        var idx = this._markers.findIndex(function (marker) { return marker.resource.toString() === model.uri.toString(); });
        if (idx < 0) {
            idx = binarySearch(this._markers, { resource: model.uri }, function (a, b) { return compare(a.resource.toString(), b.resource.toString()); });
            if (idx < 0) {
                idx = ~idx;
            }
        }
        for (var i = idx; i < this._markers.length; i++) {
            var range = Range.lift(this._markers[i]);
            if (range.isEmpty()) {
                var word = model.getWordAtPosition(range.getStartPosition());
                if (word) {
                    range = new Range(range.startLineNumber, word.startColumn, range.startLineNumber, word.endColumn);
                }
            }
            if (position && (range.containsPosition(position) || position.isBeforeOrEqual(range.getStartPosition()))) {
                this._nextIdx = i;
                found = true;
                break;
            }
            if (this._markers[i].resource.toString() !== model.uri.toString()) {
                break;
            }
        }
        if (!found) {
            // after the last change
            this._nextIdx = fwd ? 0 : this._markers.length - 1;
        }
        if (this._nextIdx < 0) {
            this._nextIdx = this._markers.length - 1;
        }
    };
    MarkerList.prototype.resetIndex = function () {
        this._nextIdx = -1;
    };
    MarkerList.prototype.move = function (fwd, model, position) {
        if (this._markers.length === 0) {
            return false;
        }
        var oldIdx = this._nextIdx;
        if (this._nextIdx === -1) {
            this._initIdx(model, position, fwd);
        }
        else if (fwd) {
            this._nextIdx = (this._nextIdx + 1) % this._markers.length;
        }
        else if (!fwd) {
            this._nextIdx = (this._nextIdx - 1 + this._markers.length) % this._markers.length;
        }
        if (oldIdx !== this._nextIdx) {
            return true;
        }
        return false;
    };
    MarkerList.prototype.find = function (uri, position) {
        var idx = this._markers.findIndex(function (marker) { return marker.resource.toString() === uri.toString(); });
        if (idx < 0) {
            return undefined;
        }
        for (; idx < this._markers.length; idx++) {
            if (Range.containsPosition(this._markers[idx], position)) {
                return new MarkerCoordinate(this._markers[idx], idx + 1, this._markers.length);
            }
        }
        return undefined;
    };
    MarkerList._compareMarker = function (a, b) {
        var res = compare(a.resource.toString(), b.resource.toString());
        if (res === 0) {
            res = MarkerSeverity.compare(a.severity, b.severity);
        }
        if (res === 0) {
            res = Range.compareRangesUsingStarts(a, b);
        }
        return res;
    };
    MarkerList = __decorate([
        __param(1, IMarkerService)
    ], MarkerList);
    return MarkerList;
}());
export { MarkerList };
export var IMarkerNavigationService = createDecorator('IMarkerNavigationService');
var MarkerNavigationService = /** @class */ (function () {
    function MarkerNavigationService(_markerService) {
        this._markerService = _markerService;
        this._provider = new LinkedList();
    }
    MarkerNavigationService.prototype.registerProvider = function (provider) {
        var remove = this._provider.unshift(provider);
        return toDisposable(function () { return remove(); });
    };
    MarkerNavigationService.prototype.getMarkerList = function (resource) {
        var e_1, _a;
        try {
            for (var _b = __values(this._provider), _c = _b.next(); !_c.done; _c = _b.next()) {
                var provider = _c.value;
                var result = provider.getMarkerList(resource);
                if (result) {
                    return result;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        // default
        return new MarkerList(resource, this._markerService);
    };
    MarkerNavigationService = __decorate([
        __param(0, IMarkerService)
    ], MarkerNavigationService);
    return MarkerNavigationService;
}());
registerSingleton(IMarkerNavigationService, MarkerNavigationService, true);
