/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as nls from '../../../nls';
import { EditorAction, registerEditorAction } from '../../browser/editorExtensions';
import { ReplaceCommand } from '../../common/commands/replaceCommand';
import { Range } from '../../common/core/range';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { MoveOperations } from '../../common/controller/cursorMoveOperations';
var TransposeLettersAction = /** @class */ (function (_super) {
    __extends(TransposeLettersAction, _super);
    function TransposeLettersAction() {
        return _super.call(this, {
            id: 'editor.action.transposeLetters',
            label: nls.localize('transposeLetters.label', "Transpose Letters"),
            alias: 'Transpose Letters',
            precondition: EditorContextKeys.writable,
            kbOpts: {
                kbExpr: EditorContextKeys.textInputFocus,
                primary: 0,
                mac: {
                    primary: 256 /* WinCtrl */ | 50 /* KEY_T */
                },
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    TransposeLettersAction.prototype.run = function (accessor, editor) {
        var e_1, _a;
        if (!editor.hasModel()) {
            return;
        }
        var model = editor.getModel();
        var commands = [];
        var selections = editor.getSelections();
        try {
            for (var selections_1 = __values(selections), selections_1_1 = selections_1.next(); !selections_1_1.done; selections_1_1 = selections_1.next()) {
                var selection = selections_1_1.value;
                if (!selection.isEmpty()) {
                    continue;
                }
                var lineNumber = selection.startLineNumber;
                var column = selection.startColumn;
                var lastColumn = model.getLineMaxColumn(lineNumber);
                if (lineNumber === 1 && (column === 1 || (column === 2 && lastColumn === 2))) {
                    // at beginning of file, nothing to do
                    continue;
                }
                // handle special case: when at end of line, transpose left two chars
                // otherwise, transpose left and right chars
                var endPosition = (column === lastColumn) ?
                    selection.getPosition() :
                    MoveOperations.rightPosition(model, selection.getPosition().lineNumber, selection.getPosition().column);
                var middlePosition = MoveOperations.leftPosition(model, endPosition.lineNumber, endPosition.column);
                var beginPosition = MoveOperations.leftPosition(model, middlePosition.lineNumber, middlePosition.column);
                var leftChar = model.getValueInRange(Range.fromPositions(beginPosition, middlePosition));
                var rightChar = model.getValueInRange(Range.fromPositions(middlePosition, endPosition));
                var replaceRange = Range.fromPositions(beginPosition, endPosition);
                commands.push(new ReplaceCommand(replaceRange, rightChar + leftChar));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (selections_1_1 && !selections_1_1.done && (_a = selections_1.return)) _a.call(selections_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (commands.length > 0) {
            editor.pushUndoStop();
            editor.executeCommands(this.id, commands);
            editor.pushUndoStop();
        }
    };
    return TransposeLettersAction;
}(EditorAction));
registerEditorAction(TransposeLettersAction);
