/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import './media/quickInput.css';
import * as dom from '../../../browser/dom';
import { IdGenerator } from '../../../common/idGenerator';
var iconPathToClass = {};
var iconClassGenerator = new IdGenerator('quick-input-button-icon-');
export function getIconClass(iconPath) {
    if (!iconPath) {
        return undefined;
    }
    var iconClass;
    var key = iconPath.dark.toString();
    if (iconPathToClass[key]) {
        iconClass = iconPathToClass[key];
    }
    else {
        iconClass = iconClassGenerator.nextId();
        dom.createCSSRule("." + iconClass, "background-image: " + dom.asCSSUrl(iconPath.light || iconPath.dark));
        dom.createCSSRule(".vs-dark ." + iconClass + ", .hc-black ." + iconClass, "background-image: " + dom.asCSSUrl(iconPath.dark));
        iconPathToClass[key] = iconClass;
    }
    return iconClass;
}
