/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { isWindows, isMacintosh, setImmediate, globals } from './platform';
var safeProcess;
// Native node.js environment
if (typeof process !== 'undefined') {
    safeProcess = process;
}
// Native sandbox environment
else if (typeof globals.vscode !== 'undefined') {
    safeProcess = {
        // Supported
        get platform() { return globals.vscode.process.platform; },
        get env() { return globals.vscode.process.env; },
        nextTick: function (callback) { return setImmediate(callback); },
        // Unsupported
        cwd: function () { return globals.vscode.process.env['VSCODE_CWD'] || globals.vscode.process.execPath.substr(0, globals.vscode.process.execPath.lastIndexOf(globals.vscode.process.platform === 'win32' ? '\\' : '/')); }
    };
}
// Web environment
else {
    safeProcess = {
        // Supported
        get platform() { return isWindows ? 'win32' : isMacintosh ? 'darwin' : 'linux'; },
        nextTick: function (callback) { return setImmediate(callback); },
        // Unsupported
        get env() { return Object.create(null); },
        cwd: function () { return '/'; }
    };
}
export var cwd = safeProcess.cwd;
export var env = safeProcess.env;
export var platform = safeProcess.platform;
export var nextTick = safeProcess.nextTick;
