"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorPreviewContribution = exports.EditorPreviewCommands = void 0;
const browser_1 = require("@theia/core/lib/browser");
const inversify_1 = require("@theia/core/shared/inversify");
const editor_preview_widget_1 = require("./editor-preview-widget");
var EditorPreviewCommands;
(function (EditorPreviewCommands) {
    EditorPreviewCommands.PIN_PREVIEW_COMMAND = {
        id: 'workbench.action.keepEditor',
        category: 'View',
        label: 'Keep Editor',
    };
})(EditorPreviewCommands = exports.EditorPreviewCommands || (exports.EditorPreviewCommands = {}));
let EditorPreviewContribution = class EditorPreviewContribution {
    registerCommands(registry) {
        registry.registerCommand(EditorPreviewCommands.PIN_PREVIEW_COMMAND, {
            execute: async (event) => {
                const widget = this.getTargetWidget(event);
                if (widget instanceof editor_preview_widget_1.EditorPreviewWidget) {
                    widget.convertToNonPreview();
                    await this.shell.activateWidget(widget.id);
                }
            },
            isEnabled: (event) => {
                const widget = this.getTargetWidget(event);
                return widget instanceof editor_preview_widget_1.EditorPreviewWidget && widget.isPreview;
            },
            isVisible: (event) => {
                const widget = this.getTargetWidget(event);
                return widget instanceof editor_preview_widget_1.EditorPreviewWidget;
            }
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: EditorPreviewCommands.PIN_PREVIEW_COMMAND.id,
            keybinding: 'ctrlcmd+k enter'
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(browser_1.SHELL_TABBAR_CONTEXT_MENU, {
            commandId: EditorPreviewCommands.PIN_PREVIEW_COMMAND.id,
            label: 'Keep Open',
            order: '6',
        });
    }
    getTargetWidget(event) {
        return event ? this.shell.findTargetedWidget(event) : this.shell.activeWidget;
    }
};
__decorate([
    inversify_1.inject(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], EditorPreviewContribution.prototype, "shell", void 0);
EditorPreviewContribution = __decorate([
    inversify_1.injectable()
], EditorPreviewContribution);
exports.EditorPreviewContribution = EditorPreviewContribution;
//# sourceMappingURL=editor-preview-contribution.js.map