/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.RuntimeEnvironment;
import org.eclipse.jdt.ls.core.internal.handlers.MapFlattener;
import org.eclipse.lsp4j.MessageType;

public class Preferences {
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_REFERENCES_INCLUDE_ACCESSORS = "java.references.includeAccessors";
    public static final String JAVA_CONFIGURATION_RUNTIMES = "java.configuration.runtimes";
    public static final List<String> JAVA_CONFIGURATION_RUNTIMES_DEFAULT;
    public static final String JAVA_FORMATTER_URL = "java.format.settings.url";
    public static final String JAVA_FORMATTER_PROFILE_NAME = "java.format.settings.profile";
    public static final String JAVA_FORMAT_COMMENTS = "java.format.comments.enabled";
    public static final String JAVA_RESOURCE_FILTERS = "java.project.resourceFilters";
    public static final List<String> JAVA_RESOURCE_FILTERS_DEFAULT;
    public static final String IMPORT_GRADLE_ENABLED = "java.import.gradle.enabled";
    public static final String IMPORT_GRADLE_OFFLINE_ENABLED = "java.import.gradle.offline.enabled";
    public static final String GRADLE_WRAPPER_ENABLED = "java.import.gradle.wrapper.enabled";
    public static final String GRADLE_VERSION = "java.import.gradle.version";
    public static final String GRADLE_ARGUMENTS = "java.import.gradle.arguments";
    public static final String GRADLE_JVM_ARGUMENTS = "java.import.gradle.jvmArguments";
    public static final String GRADLE_HOME = "java.import.gradle.home";
    public static final String GRADLE_JAVA_HOME = "java.import.gradle.java.home";
    public static final String GRADLE_USER_HOME = "java.import.gradle.user.home";
    public static final String IMPORT_MAVEN_ENABLED = "java.import.maven.enabled";
    public static final String MAVEN_DOWNLOAD_SOURCES = "java.maven.downloadSources";
    public static final String MAVEN_UPDATE_SNAPSHOTS = "java.maven.updateSnapshots";
    public static final String REFERENCES_CODE_LENS_ENABLED_KEY = "java.referencesCodeLens.enabled";
    public static final String IMPLEMENTATIONS_CODE_LENS_ENABLED_KEY = "java.implementationsCodeLens.enabled";
    public static final String JAVA_FORMAT_ENABLED_KEY = "java.format.enabled";
    public static final String JAVA_FORMAT_ON_TYPE_ENABLED_KEY = "java.format.onType.enabled";
    public static final String JAVA_SAVE_ACTIONS_ORGANIZE_IMPORTS_KEY = "java.saveActions.organizeImports";
    public static final String SIGNATURE_HELP_ENABLED_KEY = "java.signatureHelp.enabled";
    public static final String RENAME_ENABLED_KEY = "java.rename.enabled";
    public static final String EXECUTE_COMMAND_ENABLED_KEY = "java.executeCommand.enabled";
    public static final String AUTOBUILD_ENABLED_KEY = "java.autobuild.enabled";
    public static final String JAVA_MAX_CONCURRENT_BUILDS = "java.maxConcurrentBuilds";
    public static final String JAVA_IMPORT_EXCLUSIONS_KEY = "java.import.exclusions";
    public static final List<String> JAVA_IMPORT_EXCLUSIONS_DEFAULT;
    public static final String JAVA_PROJECT_REFERENCED_LIBRARIES_KEY = "java.project.referencedLibraries";
    public static final ReferencedLibraries JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT;
    public static final String CONFIGURATION_UPDATE_BUILD_CONFIGURATION_KEY = "java.configuration.updateBuildConfiguration";
    public static final String ERRORS_INCOMPLETE_CLASSPATH_SEVERITY_KEY = "java.errors.incompleteClasspath.severity";
    public static final String MAVEN_USER_SETTINGS_KEY = "java.configuration.maven.userSettings";
    public static final String MAVEN_GLOBAL_SETTINGS_KEY = "java.configuration.maven.globalSettings";
    public static final String COMPLETION_ENABLED_KEY = "java.completion.enabled";
    public static final String FOLDINGRANGE_ENABLED_KEY = "java.foldingRange.enabled";
    public static final String SELECTIONRANGE_ENABLED_KEY = "java.selectionRange.enabled";
    public static final String JAVA_GRADLE_WRAPPER_SHA256_KEY = "java.imports.gradle.wrapper.checksums";
    public static final List<String> JAVA_GRADLE_WRAPPER_SHA256_DEFAULT;
    public static final String JAVA_COMPLETION_FAVORITE_MEMBERS_KEY = "java.completion.favoriteStaticMembers";
    public static final List<String> JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT;
    public static final String JAVA_COMPLETION_MAX_RESULTS_KEY = "java.completion.maxResults";
    public static final int JAVA_COMPLETION_MAX_RESULTS_DEFAULT = 50;
    public static final String JAVA_COMPLETION_OVERWRITE_KEY = "java.completion.overwrite";
    public static final String JAVA_COMPLETION_GUESS_METHOD_ARGUMENTS_KEY = "java.completion.guessMethodArguments";
    public static final String MEMBER_SORT_ORDER = "java.memberSortOrder";
    public static final String IMPORTS_ONDEMANDTHRESHOLD = "java.sources.organizeImports.starThreshold";
    public static final String IMPORTS_STATIC_ONDEMANDTHRESHOLD = "java.sources.organizeImports.staticStarThreshold";
    public static final int IMPORTS_ONDEMANDTHRESHOLD_DEFAULT = 99;
    public static final int IMPORTS_STATIC_ONDEMANDTHRESHOLD_DEFAULT = 99;
    public static final String PREFERRED_CONTENT_PROVIDER_KEY = "java.contentProvider.preferred";
    public static final String JAVA_IMPORT_ORDER_KEY = "java.completion.importOrder";
    public static final List<String> JAVA_IMPORT_ORDER_DEFAULT;
    public static final String JAVA_COMPLETION_FILTERED_TYPES_KEY = "java.completion.filteredTypes";
    public static final List<String> JAVA_COMPLETION_FILTERED_TYPES_DEFAULT;
    public static final String JAVA_CODEGENERATION_HASHCODEEQUALS_USEJAVA7OBJECTS = "java.codeGeneration.hashCodeEquals.useJava7Objects";
    public static final String JAVA_CODEGENERATION_HASHCODEEQUALS_USEINSTANCEOF = "java.codeGeneration.hashCodeEquals.useInstanceof";
    public static final String JAVA_CODEGENERATION_USEBLOCKS = "java.codeGeneration.useBlocks";
    public static final String JAVA_CODEGENERATION_GENERATECOMMENTS = "java.codeGeneration.generateComments";
    public static final String JAVA_TEMPLATES_FILEHEADER = "java.templates.fileHeader";
    public static final String JAVA_TEMPLATES_TYPECOMMENT = "java.templates.typeComment";
    public static final String JAVA_CODEGENERATION_TOSTRING_TEMPLATE = "java.codeGeneration.toString.template";
    public static final String JAVA_CODEGENERATION_TOSTRING_CODESTYLE = "java.codeGeneration.toString.codeStyle";
    public static final String JAVA_CODEGENERATION_TOSTRING_SKIPNULLVALUES = "java.codeGeneration.toString.skipNullValues";
    public static final String JAVA_CODEGENERATION_TOSTRING_LISTARRAYCONTENTS = "java.codeGeneration.toString.listArrayContents";
    public static final String JAVA_CODEGENERATION_TOSTRING_LIMITELEMENTS = "java.codeGeneration.toString.limitElements";
    public static final String TEXT_DOCUMENT_FORMATTING = "textDocument/formatting";
    public static final String TEXT_DOCUMENT_RANGE_FORMATTING = "textDocument/rangeFormatting";
    public static final String TEXT_DOCUMENT_ON_TYPE_FORMATTING = "textDocument/onTypeFormatting";
    public static final String TEXT_DOCUMENT_CODE_LENS = "textDocument/codeLens";
    public static final String TEXT_DOCUMENT_SIGNATURE_HELP = "textDocument/signatureHelp";
    public static final String TEXT_DOCUMENT_RENAME = "textDocument/rename";
    public static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    public static final String WORKSPACE_SYMBOL = "workspace/symbol";
    public static final String WORKSPACE_WATCHED_FILES = "workspace/didChangeWatchedFiles";
    public static final String DOCUMENT_SYMBOL = "textDocument/documentSymbol";
    public static final String COMPLETION = "textDocument/completion";
    public static final String CODE_ACTION = "textDocument/codeAction";
    public static final String DEFINITION = "textDocument/definition";
    public static final String TYPEDEFINITION = "textDocument/typeDefinition";
    public static final String HOVER = "textDocument/hover";
    public static final String REFERENCES = "textDocument/references";
    public static final String DOCUMENT_HIGHLIGHT = "textDocument/documentHighlight";
    public static final String FOLDINGRANGE = "textDocument/foldingRange";
    public static final String WORKSPACE_CHANGE_FOLDERS = "workspace/didChangeWorkspaceFolders";
    public static final String IMPLEMENTATION = "textDocument/implementation";
    public static final String SELECTION_RANGE = "textDocument/selectionRange";
    public static final String FORMATTING_ID;
    public static final String FORMATTING_ON_TYPE_ID;
    public static final String FORMATTING_RANGE_ID;
    public static final String CODE_LENS_ID;
    public static final String SIGNATURE_HELP_ID;
    public static final String RENAME_ID;
    public static final String EXECUTE_COMMAND_ID;
    public static final String WORKSPACE_SYMBOL_ID;
    public static final String DOCUMENT_SYMBOL_ID;
    public static final String COMPLETION_ID;
    public static final String CODE_ACTION_ID;
    public static final String DEFINITION_ID;
    public static final String TYPEDEFINITION_ID;
    public static final String HOVER_ID;
    public static final String REFERENCES_ID;
    public static final String DOCUMENT_HIGHLIGHT_ID;
    public static final String FOLDINGRANGE_ID;
    public static final String WORKSPACE_CHANGE_FOLDERS_ID;
    public static final String WORKSPACE_WATCHED_FILES_ID;
    public static final String IMPLEMENTATION_ID;
    public static final String SELECTION_RANGE_ID;
    private static final String GRADLE_OFFLINE_MODE = "gradle.offline.mode";
    private Map<String, Object> configuration = null;
    private Severity incompleteClasspathSeverity;
    private FeatureStatus updateBuildConfigurationStatus;
    private boolean referencesCodeLensEnabled = true;
    private boolean importGradleEnabled = true;
    private boolean importGradleOfflineEnabled = false;
    private boolean gradleWrapperEnabled = true;
    private String gradleVersion = null;
    private List<String> gradleArguments;
    private List<String> gradleJvmArguments;
    private String gradleHome = null;
    private String gradleJavaHome = null;
    private String gradleUserHome = null;
    private boolean importMavenEnabled = true;
    private boolean mavenDownloadSources = false;
    private boolean mavenUpdateSnapshots = false;
    private boolean implementationsCodeLensEnabled = false;
    private boolean javaFormatEnabled = true;
    private boolean javaFormatOnTypeEnabled = false;
    private boolean javaSaveActionsOrganizeImportsEnabled = false;
    private boolean signatureHelpEnabled = false;
    private boolean renameEnabled = true;
    private boolean executeCommandEnabled = true;
    private boolean autobuildEnabled = true;
    private boolean completionEnabled = true;
    private boolean completionOverwrite = true;
    private boolean foldingRangeEnabled = true;
    private boolean selectionRangeEnabled = true;
    private boolean guessMethodArguments = false;
    private boolean javaFormatComments = true;
    private boolean hashCodeEqualsTemplateUseJava7Objects = false;
    private boolean hashCodeEqualsTemplateUseInstanceof = false;
    private boolean codeGenerationTemplateUseBlocks = false;
    private boolean codeGenerationTemplateGenerateComments = false;
    private String generateToStringTemplate;
    private String generateToStringCodeStyle;
    private boolean generateToStringSkipNullValues = false;
    private boolean generateToStringListArrayContents = true;
    private int generateToStringLimitElements = 0;
    private List<String> preferredContentProviderIds = null;
    private boolean includeAccessors = true;
    private String mavenUserSettings;
    private String mavenGlobalSettings;
    private List<String> javaCompletionFavoriteMembers;
    private List<?> gradleWrapperList;
    private List<String> javaImportExclusions = new LinkedList<String>();
    private ReferencedLibraries referencedLibraries;
    private String javaHome = null;
    private List<String> importOrder;
    private List<String> filteredTypes;
    private String formatterUrl = null;
    private String formatterProfileName = null;
    private Collection<IPath> rootPaths;
    private Collection<IPath> triggerFiles;
    private int parallelBuildsCount = 1;
    private int maxCompletionResults = 50;
    private int importOnDemandThreshold = 99;
    private int staticImportOnDemandThreshold = 99;
    private Set<RuntimeEnvironment> runtimes = new HashSet<RuntimeEnvironment>();
    private List<String> resourceFilters;
    private List<String> fileHeaderTemplate = new LinkedList<String>();
    private List<String> typeCommentTemplate = new LinkedList<String>();

    static {
        FORMATTING_ID = UUID.randomUUID().toString();
        FORMATTING_ON_TYPE_ID = UUID.randomUUID().toString();
        FORMATTING_RANGE_ID = UUID.randomUUID().toString();
        CODE_LENS_ID = UUID.randomUUID().toString();
        SIGNATURE_HELP_ID = UUID.randomUUID().toString();
        RENAME_ID = UUID.randomUUID().toString();
        EXECUTE_COMMAND_ID = UUID.randomUUID().toString();
        WORKSPACE_SYMBOL_ID = UUID.randomUUID().toString();
        DOCUMENT_SYMBOL_ID = UUID.randomUUID().toString();
        COMPLETION_ID = UUID.randomUUID().toString();
        CODE_ACTION_ID = UUID.randomUUID().toString();
        DEFINITION_ID = UUID.randomUUID().toString();
        TYPEDEFINITION_ID = UUID.randomUUID().toString();
        HOVER_ID = UUID.randomUUID().toString();
        REFERENCES_ID = UUID.randomUUID().toString();
        DOCUMENT_HIGHLIGHT_ID = UUID.randomUUID().toString();
        FOLDINGRANGE_ID = UUID.randomUUID().toString();
        WORKSPACE_CHANGE_FOLDERS_ID = UUID.randomUUID().toString();
        WORKSPACE_WATCHED_FILES_ID = UUID.randomUUID().toString();
        IMPLEMENTATION_ID = UUID.randomUUID().toString();
        SELECTION_RANGE_ID = UUID.randomUUID().toString();
        JAVA_IMPORT_EXCLUSIONS_DEFAULT = new LinkedList<String>();
        JAVA_CONFIGURATION_RUNTIMES_DEFAULT = new ArrayList<String>();
        JAVA_GRADLE_WRAPPER_SHA256_DEFAULT = new ArrayList<String>();
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/node_modules/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/.metadata/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/archetype-resources/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/META-INF/maven/**");
        JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT = new ReferencedLibraries();
        JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT.getInclude().add("lib/**");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT = new ArrayList<String>();
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.Assert.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.Assume.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.Assertions.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.Assumptions.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.DynamicContainer.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.DynamicTest.*");
        JAVA_IMPORT_ORDER_DEFAULT = new ArrayList<String>();
        JAVA_IMPORT_ORDER_DEFAULT.add("java");
        JAVA_IMPORT_ORDER_DEFAULT.add("javax");
        JAVA_IMPORT_ORDER_DEFAULT.add("com");
        JAVA_IMPORT_ORDER_DEFAULT.add("org");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT = new ArrayList<String>();
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("java.awt.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("com.sun.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("sun.*");
        JAVA_RESOURCE_FILTERS_DEFAULT = Arrays.asList("node_modules", ".git");
    }

    public Preferences() {
        this.incompleteClasspathSeverity = Severity.warning;
        this.updateBuildConfigurationStatus = FeatureStatus.interactive;
        this.gradleArguments = new ArrayList<String>();
        this.gradleJvmArguments = new ArrayList<String>();
        this.javaImportExclusions = JAVA_IMPORT_EXCLUSIONS_DEFAULT;
        this.javaCompletionFavoriteMembers = JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT;
        this.importOrder = JAVA_IMPORT_ORDER_DEFAULT;
        this.filteredTypes = JAVA_COMPLETION_FILTERED_TYPES_DEFAULT;
        this.referencedLibraries = JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT;
        this.resourceFilters = JAVA_RESOURCE_FILTERS_DEFAULT;
    }

    public static Preferences createFrom(Map<String, Object> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration can not be null");
        }
        Preferences prefs = new Preferences();
        prefs.configuration = configuration;
        String incompleteClasspathSeverity = MapFlattener.getString(configuration, ERRORS_INCOMPLETE_CLASSPATH_SEVERITY_KEY, null);
        prefs.setIncompleteClasspathSeverity(Severity.fromString(incompleteClasspathSeverity, Severity.warning));
        String updateBuildConfiguration = MapFlattener.getString(configuration, CONFIGURATION_UPDATE_BUILD_CONFIGURATION_KEY, null);
        prefs.setUpdateBuildConfigurationStatus(FeatureStatus.fromString(updateBuildConfiguration, FeatureStatus.interactive));
        boolean importGradleEnabled = MapFlattener.getBoolean(configuration, IMPORT_GRADLE_ENABLED, true);
        prefs.setImportGradleEnabled(importGradleEnabled);
        boolean importGradleOfflineEnabled = MapFlattener.getBoolean(configuration, IMPORT_GRADLE_OFFLINE_ENABLED, false);
        prefs.setImportGradleOfflineEnabled(importGradleOfflineEnabled);
        boolean gradleWrapperEnabled = MapFlattener.getBoolean(configuration, GRADLE_WRAPPER_ENABLED, true);
        prefs.setGradleWrapperEnabled(gradleWrapperEnabled);
        String gradleVersion = MapFlattener.getString(configuration, GRADLE_VERSION);
        prefs.setGradleVersion(gradleVersion);
        List<String> gradleArguments = MapFlattener.getList(configuration, GRADLE_ARGUMENTS);
        prefs.setGradleArguments(gradleArguments);
        List<String> gradleJvmArguments = MapFlattener.getList(configuration, GRADLE_JVM_ARGUMENTS);
        prefs.setGradleJvmArguments(gradleJvmArguments);
        String gradleHome = MapFlattener.getString(configuration, GRADLE_HOME);
        prefs.setGradleHome(gradleHome);
        String gradleJavaHome = MapFlattener.getString(configuration, GRADLE_JAVA_HOME);
        prefs.setGradleJavaHome(gradleJavaHome);
        String gradleUserHome = MapFlattener.getString(configuration, GRADLE_USER_HOME);
        prefs.setGradleUserHome(gradleUserHome);
        boolean importMavenEnabled = MapFlattener.getBoolean(configuration, IMPORT_MAVEN_ENABLED, true);
        prefs.setImportMavenEnabled(importMavenEnabled);
        boolean downloadSources = MapFlattener.getBoolean(configuration, MAVEN_DOWNLOAD_SOURCES, false);
        prefs.setMavenDownloadSources(downloadSources);
        boolean updateSnapshots = MapFlattener.getBoolean(configuration, MAVEN_UPDATE_SNAPSHOTS, false);
        prefs.setMavenUpdateSnapshots(updateSnapshots);
        boolean referenceCodelensEnabled = MapFlattener.getBoolean(configuration, REFERENCES_CODE_LENS_ENABLED_KEY, true);
        prefs.setReferencesCodelensEnabled(referenceCodelensEnabled);
        boolean implementationCodeLensEnabled = MapFlattener.getBoolean(configuration, IMPLEMENTATIONS_CODE_LENS_ENABLED_KEY, false);
        prefs.setImplementationCodelensEnabled(implementationCodeLensEnabled);
        boolean javaFormatEnabled = MapFlattener.getBoolean(configuration, JAVA_FORMAT_ENABLED_KEY, true);
        prefs.setJavaFormatEnabled(javaFormatEnabled);
        boolean javaFormatOnTypeEnabled = MapFlattener.getBoolean(configuration, JAVA_FORMAT_ON_TYPE_ENABLED_KEY, false);
        prefs.setJavaFormatOnTypeEnabled(javaFormatOnTypeEnabled);
        boolean javaSaveActionAutoOrganizeImportsEnabled = MapFlattener.getBoolean(configuration, JAVA_SAVE_ACTIONS_ORGANIZE_IMPORTS_KEY, false);
        prefs.setJavaSaveActionAutoOrganizeImportsEnabled(javaSaveActionAutoOrganizeImportsEnabled);
        boolean signatureHelpEnabled = MapFlattener.getBoolean(configuration, SIGNATURE_HELP_ENABLED_KEY, true);
        prefs.setSignatureHelpEnabled(signatureHelpEnabled);
        boolean renameEnabled = MapFlattener.getBoolean(configuration, RENAME_ENABLED_KEY, true);
        prefs.setRenameEnabled(renameEnabled);
        boolean executeCommandEnable = MapFlattener.getBoolean(configuration, EXECUTE_COMMAND_ENABLED_KEY, true);
        prefs.setExecuteCommandEnabled(executeCommandEnable);
        boolean autobuildEnable = MapFlattener.getBoolean(configuration, AUTOBUILD_ENABLED_KEY, true);
        prefs.setAutobuildEnabled(autobuildEnable);
        boolean completionEnable = MapFlattener.getBoolean(configuration, COMPLETION_ENABLED_KEY, true);
        prefs.setCompletionEnabled(completionEnable);
        boolean completionOverwrite = MapFlattener.getBoolean(configuration, JAVA_COMPLETION_OVERWRITE_KEY, true);
        prefs.setCompletionOverwrite(completionOverwrite);
        boolean foldingRangeEnable = MapFlattener.getBoolean(configuration, FOLDINGRANGE_ENABLED_KEY, true);
        prefs.setFoldingRangeEnabled(foldingRangeEnable);
        boolean selectionRangeEnabled = MapFlattener.getBoolean(configuration, SELECTIONRANGE_ENABLED_KEY, true);
        prefs.setSelectionRangeEnabled(selectionRangeEnabled);
        boolean guessMethodArguments = MapFlattener.getBoolean(configuration, JAVA_COMPLETION_GUESS_METHOD_ARGUMENTS_KEY, false);
        prefs.setGuessMethodArguments(guessMethodArguments);
        boolean hashCodeEqualsTemplateUseJava7Objects = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_HASHCODEEQUALS_USEJAVA7OBJECTS, false);
        prefs.setHashCodeEqualsTemplateUseJava7Objects(hashCodeEqualsTemplateUseJava7Objects);
        boolean hashCodeEqualsTemplateUseInstanceof = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_HASHCODEEQUALS_USEINSTANCEOF, false);
        prefs.setHashCodeEqualsTemplateUseInstanceof(hashCodeEqualsTemplateUseInstanceof);
        boolean codeGenerationTemplateUseBlocks = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_USEBLOCKS, false);
        prefs.setCodeGenerationTemplateUseBlocks(codeGenerationTemplateUseBlocks);
        boolean codeGenerationTemplateGenerateComments = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_GENERATECOMMENTS, false);
        prefs.setCodeGenerationTemplateGenerateComments(codeGenerationTemplateGenerateComments);
        String generateToStringTemplate = MapFlattener.getString(configuration, JAVA_CODEGENERATION_TOSTRING_TEMPLATE);
        prefs.setGenerateToStringTemplate(generateToStringTemplate);
        String generateToStringCodeStyle = MapFlattener.getString(configuration, JAVA_CODEGENERATION_TOSTRING_CODESTYLE, "STRING_CONCATENATION");
        prefs.setGenerateToStringCodeStyle(generateToStringCodeStyle);
        boolean generateToStringSkipNullValues = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_TOSTRING_SKIPNULLVALUES, false);
        prefs.setGenerateToStringSkipNullValues(generateToStringSkipNullValues);
        boolean generateToStringListArrayContents = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_TOSTRING_LISTARRAYCONTENTS, true);
        prefs.setGenerateToStringListArrayContents(generateToStringListArrayContents);
        int generateToStringLimitElements = MapFlattener.getInt(configuration, JAVA_CODEGENERATION_TOSTRING_LIMITELEMENTS, 0);
        prefs.setGenerateToStringLimitElements(generateToStringLimitElements);
        List<String> javaImportExclusions = MapFlattener.getList(configuration, JAVA_IMPORT_EXCLUSIONS_KEY, JAVA_IMPORT_EXCLUSIONS_DEFAULT);
        if (javaImportExclusions instanceof LinkedList) {
            prefs.setJavaImportExclusions(javaImportExclusions);
        } else {
            LinkedList<String> copy = new LinkedList<String>(javaImportExclusions);
            prefs.setJavaImportExclusions(copy);
        }
        Object referencedLibraries = MapFlattener.getValue(configuration, JAVA_PROJECT_REFERENCED_LIBRARIES_KEY);
        if (referencedLibraries == null) {
            prefs.setReferencedLibraries(JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT);
        } else if (referencedLibraries instanceof Map) {
            try {
                Map config = (Map)referencedLibraries;
                HashSet<String> include = new HashSet<String>(config.getOrDefault("include", new ArrayList()));
                HashSet<String> exclude = new HashSet<String>(config.getOrDefault("exclude", new ArrayList()));
                Map sources = config.getOrDefault("sources", new HashMap());
                prefs.setReferencedLibraries(new ReferencedLibraries(include, exclude, sources));
            }
            catch (Exception e) {
                prefs.setReferencedLibraries(JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT);
            }
        } else {
            try {
                HashSet<String> include = new HashSet<String>((List)referencedLibraries);
                prefs.setReferencedLibraries(new ReferencedLibraries(include));
            }
            catch (Exception e) {
                prefs.setReferencedLibraries(JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT);
            }
        }
        List<String> javaCompletionFavoriteMembers = MapFlattener.getList(configuration, JAVA_COMPLETION_FAVORITE_MEMBERS_KEY, JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT);
        prefs.setJavaCompletionFavoriteMembers(javaCompletionFavoriteMembers);
        List<String> gradleWrapperList = MapFlattener.getList(configuration, JAVA_GRADLE_WRAPPER_SHA256_KEY, JAVA_GRADLE_WRAPPER_SHA256_DEFAULT);
        prefs.setGradleWrapperList(gradleWrapperList);
        String mavenUserSettings = MapFlattener.getString(configuration, MAVEN_USER_SETTINGS_KEY, null);
        prefs.setMavenUserSettings(mavenUserSettings);
        String mavenGlobalSettings = MapFlattener.getString(configuration, MAVEN_GLOBAL_SETTINGS_KEY, null);
        prefs.setMavenGlobalSettings(mavenGlobalSettings);
        String sortOrder = MapFlattener.getString(configuration, MEMBER_SORT_ORDER, null);
        prefs.setMembersSortOrder(sortOrder);
        List<String> preferredContentProviders = MapFlattener.getList(configuration, PREFERRED_CONTENT_PROVIDER_KEY);
        prefs.setPreferredContentProviderIds(preferredContentProviders);
        String javaHome = MapFlattener.getString(configuration, JAVA_HOME);
        prefs.setJavaHome(javaHome);
        String formatterUrl = MapFlattener.getString(configuration, JAVA_FORMATTER_URL);
        prefs.setFormatterUrl(formatterUrl);
        List<String> resourceFilters = MapFlattener.getList(configuration, JAVA_RESOURCE_FILTERS);
        prefs.setResourceFilters(resourceFilters);
        String formatterProfileName = MapFlattener.getString(configuration, JAVA_FORMATTER_PROFILE_NAME);
        prefs.setFormatterProfileName(formatterProfileName);
        boolean javaFormatComments = MapFlattener.getBoolean(configuration, JAVA_FORMAT_COMMENTS, true);
        prefs.setJavaFormatComments(javaFormatComments);
        List<String> javaImportOrder = MapFlattener.getList(configuration, JAVA_IMPORT_ORDER_KEY, JAVA_IMPORT_ORDER_DEFAULT);
        prefs.setImportOrder(javaImportOrder);
        List<String> javaFilteredTypes = MapFlattener.getList(configuration, JAVA_COMPLETION_FILTERED_TYPES_KEY, JAVA_COMPLETION_FILTERED_TYPES_DEFAULT);
        prefs.setFilteredTypes(javaFilteredTypes);
        int maxConcurrentBuilds = MapFlattener.getInt(configuration, JAVA_MAX_CONCURRENT_BUILDS, 1);
        maxConcurrentBuilds = maxConcurrentBuilds >= 1 ? maxConcurrentBuilds : 1;
        prefs.setMaxBuildCount(maxConcurrentBuilds);
        int maxCompletions = MapFlattener.getInt(configuration, JAVA_COMPLETION_MAX_RESULTS_KEY, 50);
        prefs.setMaxCompletionResults(maxCompletions);
        int onDemandThreshold = MapFlattener.getInt(configuration, IMPORTS_ONDEMANDTHRESHOLD, 99);
        prefs.setImportOnDemandThreshold(onDemandThreshold);
        int staticOnDemandThreshold = MapFlattener.getInt(configuration, IMPORTS_STATIC_ONDEMANDTHRESHOLD, 99);
        prefs.setStaticImportOnDemandThreshold(staticOnDemandThreshold);
        List<String> runtimeList = MapFlattener.getList(configuration, JAVA_CONFIGURATION_RUNTIMES, JAVA_CONFIGURATION_RUNTIMES_DEFAULT);
        HashSet<RuntimeEnvironment> runtimes = new HashSet<RuntimeEnvironment>();
        boolean[] hasDefault = new boolean[1];
        for (String object : runtimeList) {
            if (!(object instanceof Map)) continue;
            RuntimeEnvironment runtime = new RuntimeEnvironment();
            Map map = (Map)((Object)object);
            map.forEach((k, v) -> {
                block20: {
                    if (!(k instanceof String)) break block20;
                    switch ((String)k) {
                        case "name": {
                            if (!(v instanceof String)) break;
                            runtime.setName((String)v);
                            break;
                        }
                        case "path": {
                            if (!(v instanceof String)) break;
                            runtime.setPath((String)v);
                            break;
                        }
                        case "javadoc": {
                            if (!(v instanceof String)) break;
                            runtime.setJavadoc((String)v);
                            break;
                        }
                        case "sources": {
                            if (!(v instanceof String)) break;
                            runtime.setSources((String)v);
                            break;
                        }
                        case "default": {
                            if (hasDefault[0]) break;
                            if (v instanceof Boolean) {
                                runtime.setDefault((Boolean)v);
                            }
                            blArray[0] = true;
                            break;
                        }
                    }
                }
            });
            if (!runtimes.contains(runtime)) {
                if (runtime.isValid()) {
                    runtimes.add(runtime);
                    continue;
                }
                JavaLanguageServerPlugin.logInfo("Runtime " + runtime + " is not valid.");
                continue;
            }
            JavaLanguageServerPlugin.logInfo("Multiple runtimes with name " + runtime.getName());
        }
        prefs.setRuntimes(runtimes);
        List<String> fileHeader = MapFlattener.getList(configuration, JAVA_TEMPLATES_FILEHEADER);
        prefs.setFileHeaderTemplate(fileHeader);
        List<String> typeComment = MapFlattener.getList(configuration, JAVA_TEMPLATES_TYPECOMMENT);
        prefs.setTypeCommentTemplate(typeComment);
        boolean includeAccessors = MapFlattener.getBoolean(configuration, JAVA_REFERENCES_INCLUDE_ACCESSORS, true);
        prefs.setIncludeAccessors(includeAccessors);
        return prefs;
    }

    public Preferences setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public Preferences setGradleVersion(String gradleVersion) {
        this.gradleVersion = gradleVersion == null || gradleVersion.isEmpty() ? null : gradleVersion;
        return this;
    }

    public Preferences setGradleArguments(List<String> arguments) {
        this.gradleArguments = arguments == null ? new ArrayList() : arguments;
        return this;
    }

    public Preferences setGradleJvmArguments(List<String> jvmArguments) {
        this.gradleJvmArguments = jvmArguments == null ? new ArrayList() : jvmArguments;
        return this;
    }

    public Preferences setGradleHome(String gradleHome) {
        this.gradleHome = gradleHome;
        return this;
    }

    public Preferences setGradleJavaHome(String gradleJavaHome) {
        this.gradleJavaHome = gradleJavaHome;
        return this;
    }

    public Preferences setGradleUserHome(String gradleUserHome) {
        this.gradleUserHome = gradleUserHome;
        return this;
    }

    public Preferences setFormatterUrl(String formatterUrl) {
        this.formatterUrl = formatterUrl;
        return this;
    }

    public Preferences setResourceFilters(List<String> resourceFilters) {
        this.resourceFilters = resourceFilters == null ? new ArrayList() : resourceFilters;
        return this;
    }

    public Preferences setJavaFormatComments(boolean javaFormatComments) {
        this.javaFormatComments = javaFormatComments;
        return this;
    }

    public boolean isJavaFormatComments() {
        return this.javaFormatComments;
    }

    public Preferences setFormatterProfileName(String formatterProfileName) {
        this.formatterProfileName = formatterProfileName;
        return this;
    }

    public Preferences setJavaImportExclusions(List<String> javaImportExclusions) {
        this.javaImportExclusions = javaImportExclusions;
        return this;
    }

    public Preferences setJavaCompletionFavoriteMembers(List<String> javaCompletionFavoriteMembers) {
        this.javaCompletionFavoriteMembers = javaCompletionFavoriteMembers == null || javaCompletionFavoriteMembers.isEmpty() ? JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT : javaCompletionFavoriteMembers;
        return this;
    }

    private Preferences setMembersSortOrder(String sortOrder) {
        if (sortOrder != null) {
            IEclipsePreferences fPreferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
            fPreferenceStore.put("outlinesortoption", sortOrder);
        }
        return this;
    }

    private Preferences setPreferredContentProviderIds(List<String> preferredContentProviderIds) {
        this.preferredContentProviderIds = preferredContentProviderIds;
        return this;
    }

    private Preferences setReferencesCodelensEnabled(boolean enabled) {
        this.referencesCodeLensEnabled = enabled;
        return this;
    }

    public Preferences setImportGradleEnabled(boolean enabled) {
        this.importGradleEnabled = enabled;
        return this;
    }

    public Preferences setImportGradleOfflineEnabled(boolean enabled) {
        this.importGradleOfflineEnabled = enabled;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.buildship.core");
        boolean offlineMode = prefs.getBoolean(GRADLE_OFFLINE_MODE, false);
        if (offlineMode != enabled) {
            prefs.putBoolean(GRADLE_OFFLINE_MODE, enabled);
        }
        return this;
    }

    public Preferences setGradleWrapperEnabled(boolean enabled) {
        this.gradleWrapperEnabled = enabled;
        return this;
    }

    public Preferences setImportMavenEnabled(boolean enabled) {
        this.importMavenEnabled = enabled;
        return this;
    }

    public Preferences setMavenDownloadSources(boolean enabled) {
        this.mavenDownloadSources = enabled;
        return this;
    }

    public Preferences setMavenUpdateSnapshots(boolean enabled) {
        this.mavenUpdateSnapshots = enabled;
        return this;
    }

    private Preferences setSignatureHelpEnabled(boolean enabled) {
        this.signatureHelpEnabled = enabled;
        return this;
    }

    private Preferences setImplementationCodelensEnabled(boolean enabled) {
        this.implementationsCodeLensEnabled = enabled;
        return this;
    }

    private Preferences setRenameEnabled(boolean enabled) {
        this.renameEnabled = enabled;
        return this;
    }

    private Preferences setExecuteCommandEnabled(boolean enabled) {
        this.executeCommandEnabled = enabled;
        return this;
    }

    public Preferences setAutobuildEnabled(boolean enabled) {
        this.autobuildEnabled = enabled;
        return this;
    }

    public Preferences setCompletionEnabled(boolean enabled) {
        this.completionEnabled = enabled;
        return this;
    }

    public Preferences setCompletionOverwrite(boolean completionOverwrite) {
        this.completionOverwrite = completionOverwrite;
        return this;
    }

    public Preferences setFoldingRangeEnabled(boolean enabled) {
        this.foldingRangeEnabled = enabled;
        return this;
    }

    public Preferences setSelectionRangeEnabled(boolean enabled) {
        this.selectionRangeEnabled = enabled;
        return this;
    }

    public Preferences setGuessMethodArguments(boolean guessMethodArguments) {
        this.guessMethodArguments = guessMethodArguments;
        return this;
    }

    public Preferences setJavaFormatEnabled(boolean enabled) {
        this.javaFormatEnabled = enabled;
        return this;
    }

    public Preferences setJavaSaveActionAutoOrganizeImportsEnabled(boolean javaSaveActionAutoOrganizeImportsEnabled) {
        this.javaSaveActionsOrganizeImportsEnabled = javaSaveActionAutoOrganizeImportsEnabled;
        return this;
    }

    public Preferences setHashCodeEqualsTemplateUseJava7Objects(boolean hashCodeEqualsTemplateUseJ7Objects) {
        this.hashCodeEqualsTemplateUseJava7Objects = hashCodeEqualsTemplateUseJ7Objects;
        return this;
    }

    public Preferences setHashCodeEqualsTemplateUseInstanceof(boolean hashCodeEqualsTemplateUseInstanceof) {
        this.hashCodeEqualsTemplateUseInstanceof = hashCodeEqualsTemplateUseInstanceof;
        return this;
    }

    public Preferences setCodeGenerationTemplateUseBlocks(boolean codeGenerationTemplateUseBlocks) {
        this.codeGenerationTemplateUseBlocks = codeGenerationTemplateUseBlocks;
        return this;
    }

    public Preferences setCodeGenerationTemplateGenerateComments(boolean codeGenerationTemplateGenerateComments) {
        this.codeGenerationTemplateGenerateComments = codeGenerationTemplateGenerateComments;
        return this;
    }

    public Preferences setGenerateToStringTemplate(String generateToStringTemplate) {
        this.generateToStringTemplate = generateToStringTemplate;
        return this;
    }

    public Preferences setGenerateToStringCodeStyle(String generateToStringCodeStyle) {
        this.generateToStringCodeStyle = generateToStringCodeStyle;
        return this;
    }

    public Preferences setGenerateToStringSkipNullValues(boolean generateToStringSkipNullValues) {
        this.generateToStringSkipNullValues = generateToStringSkipNullValues;
        return this;
    }

    public Preferences setGenerateToStringListArrayContents(boolean generateToStringListArrayContents) {
        this.generateToStringListArrayContents = generateToStringListArrayContents;
        return this;
    }

    public Preferences setGenerateToStringLimitElements(int generateToStringLimitElements) {
        this.generateToStringLimitElements = generateToStringLimitElements;
        return this;
    }

    public Preferences setUpdateBuildConfigurationStatus(FeatureStatus status) {
        this.updateBuildConfigurationStatus = status;
        return this;
    }

    private Preferences setIncompleteClasspathSeverity(Severity severity) {
        this.incompleteClasspathSeverity = severity;
        return this;
    }

    public Preferences setImportOrder(List<String> importOrder) {
        this.importOrder = importOrder == null || importOrder.size() == 0 ? JAVA_IMPORT_ORDER_DEFAULT : importOrder;
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        pref.put("org.eclipse.jdt.ui.importorder", String.join((CharSequence)";", importOrder));
        return this;
    }

    public Preferences setFilteredTypes(List<String> filteredTypes) {
        this.filteredTypes = filteredTypes == null ? Collections.emptyList() : filteredTypes;
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        pref.put("org.eclipse.jdt.ui.typefilter.enabled", String.join((CharSequence)";", filteredTypes));
        JavaLanguageServerPlugin.getInstance().getTypeFilter().dispose();
        return this;
    }

    public Preferences setMaxBuildCount(int maxConcurrentBuilds) {
        this.parallelBuildsCount = maxConcurrentBuilds;
        return this;
    }

    public Severity getIncompleteClasspathSeverity() {
        return this.incompleteClasspathSeverity;
    }

    public FeatureStatus getUpdateBuildConfigurationStatus() {
        return this.updateBuildConfigurationStatus;
    }

    public List<String> getJavaImportExclusions() {
        return this.javaImportExclusions;
    }

    public String[] getJavaCompletionFavoriteMembers() {
        return this.javaCompletionFavoriteMembers.toArray(new String[0]);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getGradleVersion() {
        return this.gradleVersion;
    }

    public List<String> getGradleArguments() {
        return this.gradleArguments == null ? new ArrayList() : this.gradleArguments;
    }

    public List<String> getGradleJvmArguments() {
        return this.gradleJvmArguments == null ? new ArrayList() : this.gradleJvmArguments;
    }

    public String getGradleHome() {
        return this.gradleHome;
    }

    public String getGradleJavaHome() {
        return this.gradleJavaHome;
    }

    public String getGradleUserHome() {
        return this.gradleUserHome;
    }

    public String getFormatterUrl() {
        return this.formatterUrl;
    }

    public List<String> getResourceFilters() {
        return this.resourceFilters;
    }

    public String getFormatterProfileName() {
        return this.formatterProfileName;
    }

    public List<String> getPreferredContentProviderIds() {
        return this.preferredContentProviderIds;
    }

    public boolean isReferencesCodeLensEnabled() {
        return this.referencesCodeLensEnabled;
    }

    public boolean isImportGradleEnabled() {
        return this.importGradleEnabled;
    }

    public boolean isImportGradleOfflineEnabled() {
        return this.importGradleOfflineEnabled;
    }

    public boolean isGradleWrapperEnabled() {
        return this.gradleWrapperEnabled;
    }

    public boolean isImportMavenEnabled() {
        return this.importMavenEnabled;
    }

    public boolean isMavenDownloadSources() {
        return this.mavenDownloadSources;
    }

    public boolean isMavenUpdateSnapshots() {
        return this.mavenUpdateSnapshots;
    }

    public boolean isImplementationsCodeLensEnabled() {
        return this.implementationsCodeLensEnabled;
    }

    public boolean isCodeLensEnabled() {
        return this.referencesCodeLensEnabled || this.implementationsCodeLensEnabled;
    }

    public boolean isJavaFormatEnabled() {
        return this.javaFormatEnabled;
    }

    public boolean isJavaSaveActionsOrganizeImportsEnabled() {
        return this.javaSaveActionsOrganizeImportsEnabled;
    }

    public boolean isSignatureHelpEnabled() {
        return this.signatureHelpEnabled;
    }

    public boolean isRenameEnabled() {
        return this.renameEnabled;
    }

    public boolean isExecuteCommandEnabled() {
        return this.executeCommandEnabled;
    }

    public boolean isAutobuildEnabled() {
        return this.autobuildEnabled;
    }

    public boolean isCompletionEnabled() {
        return this.completionEnabled;
    }

    public boolean isCompletionOverwrite() {
        return this.completionOverwrite;
    }

    public boolean isFoldingRangeEnabled() {
        return this.foldingRangeEnabled;
    }

    public boolean isSelectionRangeEnabled() {
        return this.selectionRangeEnabled;
    }

    public boolean isGuessMethodArguments() {
        return this.guessMethodArguments;
    }

    public boolean isHashCodeEqualsTemplateUseJava7Objects() {
        return this.hashCodeEqualsTemplateUseJava7Objects;
    }

    public boolean isHashCodeEqualsTemplateUseInstanceof() {
        return this.hashCodeEqualsTemplateUseInstanceof;
    }

    public boolean isCodeGenerationTemplateUseBlocks() {
        return this.codeGenerationTemplateUseBlocks;
    }

    public boolean isCodeGenerationTemplateGenerateComments() {
        return this.codeGenerationTemplateGenerateComments;
    }

    public String getGenerateToStringTemplate() {
        return this.generateToStringTemplate;
    }

    public String getGenerateToStringCodeStyle() {
        return this.generateToStringCodeStyle;
    }

    public boolean isGenerateToStringSkipNullValues() {
        return this.generateToStringSkipNullValues;
    }

    public boolean isGenerateToStringListArrayContents() {
        return this.generateToStringListArrayContents;
    }

    public int getGenerateToStringLimitElements() {
        return this.generateToStringLimitElements;
    }

    public Preferences setMavenUserSettings(String mavenUserSettings) {
        this.mavenUserSettings = ResourceUtils.expandPath(mavenUserSettings);
        return this;
    }

    public String getMavenUserSettings() {
        return this.mavenUserSettings;
    }

    public Preferences setMavenGlobalSettings(String mavenGlobalSettings) {
        this.mavenGlobalSettings = ResourceUtils.expandPath(mavenGlobalSettings);
        return this;
    }

    public String getMavenGlobalSettings() {
        return this.mavenGlobalSettings;
    }

    public String[] getImportOrder() {
        return this.importOrder == null ? new String[]{} : this.importOrder.toArray(new String[this.importOrder.size()]);
    }

    public String[] getFilteredTypes() {
        return this.filteredTypes == null ? new String[]{} : this.filteredTypes.toArray(new String[this.filteredTypes.size()]);
    }

    public int getMaxConcurrentBuilds() {
        return this.parallelBuildsCount;
    }

    public Map<String, Object> asMap() {
        if (this.configuration == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.configuration);
    }

    public Preferences setRootPaths(Collection<IPath> rootPaths) {
        this.rootPaths = rootPaths;
        return this;
    }

    public Collection<IPath> getRootPaths() {
        return this.rootPaths;
    }

    public Preferences setTriggerFiles(Collection<IPath> triggerFiles) {
        this.triggerFiles = triggerFiles;
        return this;
    }

    public Collection<IPath> getTriggerFiles() {
        return this.triggerFiles;
    }

    public boolean isJavaFormatOnTypeEnabled() {
        return this.javaFormatOnTypeEnabled;
    }

    public Preferences setJavaFormatOnTypeEnabled(boolean javaFormatOnTypeEnabled) {
        this.javaFormatOnTypeEnabled = javaFormatOnTypeEnabled;
        return this;
    }

    public int getMaxCompletionResults() {
        return this.maxCompletionResults;
    }

    public Preferences setMaxCompletionResults(int maxCompletions) {
        this.maxCompletionResults = maxCompletions < 1 ? Integer.MAX_VALUE : maxCompletions;
        return this;
    }

    public ReferencedLibraries getReferencedLibraries() {
        return this.referencedLibraries;
    }

    public Preferences setReferencedLibraries(ReferencedLibraries referencedLibraries) {
        this.referencedLibraries = referencedLibraries;
        return this;
    }

    public Set<RuntimeEnvironment> getRuntimes() {
        return this.runtimes;
    }

    public Preferences setRuntimes(Set<RuntimeEnvironment> runtimes) {
        this.runtimes = runtimes;
        return this;
    }

    public int getImportOnDemandThreshold() {
        return this.importOnDemandThreshold;
    }

    public Preferences setImportOnDemandThreshold(int importOnDemandThreshold) {
        this.importOnDemandThreshold = importOnDemandThreshold < 0 ? 99 : importOnDemandThreshold;
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        defEclipsePrefs.put("org.eclipse.jdt.ui.ondemandthreshold", String.valueOf(this.importOnDemandThreshold));
        return this;
    }

    public int getStaticImportOnDemandThreshold() {
        return this.staticImportOnDemandThreshold;
    }

    public Preferences setStaticImportOnDemandThreshold(int staticImportOnDemandThreshold) {
        this.staticImportOnDemandThreshold = staticImportOnDemandThreshold < 0 ? 99 : staticImportOnDemandThreshold;
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        defEclipsePrefs.put("org.eclipse.jdt.ui.staticondemandthreshold", String.valueOf(this.staticImportOnDemandThreshold));
        return this;
    }

    public Preferences setGradleWrapperList(List<?> gradleWrapperList) {
        this.gradleWrapperList = gradleWrapperList;
        return this;
    }

    public List<?> getGradleWrapperList() {
        return this.gradleWrapperList == null ? Collections.emptyList() : this.gradleWrapperList;
    }

    public List<String> getFileHeaderTemplate() {
        return this.fileHeaderTemplate;
    }

    public Preferences setFileHeaderTemplate(List<String> fileHeaderTemplate) {
        this.fileHeaderTemplate = fileHeaderTemplate;
        return this;
    }

    public List<String> getTypeCommentTemplate() {
        return this.typeCommentTemplate;
    }

    public Preferences setTypeCommentTemplate(List<String> typeCommentTemplate) {
        this.typeCommentTemplate = typeCommentTemplate;
        return this;
    }

    public Preferences setIncludeAccessors(boolean includeAccessors) {
        this.includeAccessors = includeAccessors;
        return this;
    }

    public boolean isIncludeAccessors() {
        return this.includeAccessors;
    }

    public static enum FeatureStatus {
        disabled,
        interactive,
        automatic;


        static FeatureStatus fromString(String value, FeatureStatus defaultStatus) {
            if (value != null) {
                String val = value.toLowerCase();
                try {
                    return FeatureStatus.valueOf(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defaultStatus;
        }
    }

    public static class ReferencedLibraries {
        private Set<String> include;
        private Set<String> exclude;
        private Map<String, String> sources;

        public ReferencedLibraries() {
            this(new HashSet<String>(), new HashSet<String>(), new HashMap<String, String>());
        }

        public ReferencedLibraries(Set<String> include) {
            this(include, new HashSet<String>(), new HashMap<String, String>());
        }

        public ReferencedLibraries(Set<String> include, Set<String> exclude, Map<String, String> sources) {
            this.include = include;
            this.exclude = exclude;
            this.sources = sources;
        }

        public Set<String> getInclude() {
            return this.include;
        }

        public Set<String> getExclude() {
            return this.exclude;
        }

        public Map<String, String> getSources() {
            return this.sources;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferencedLibraries other = (ReferencedLibraries)obj;
            return Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.sources, other.sources);
        }
    }

    public static enum Severity {
        ignore,
        log,
        info,
        warning,
        error;


        static Severity fromString(String value, Severity defaultSeverity) {
            if (value != null) {
                String val = value.toLowerCase();
                try {
                    return Severity.valueOf(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defaultSeverity;
        }

        public MessageType toMessageType() {
            MessageType[] messageTypeArray = MessageType.values();
            int n = messageTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageType type = messageTypeArray[n2];
                if (this.name().equalsIgnoreCase(type.name())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

