/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.internal.gradle.checksums.ValidationResult;
import org.eclipse.jdt.ls.internal.gradle.checksums.WrapperValidator;

public class GradlePreferenceChangeListener
implements IPreferencesChangeListener {
    @Override
    public void preferencesChange(Preferences oldPreferences, Preferences newPreferences) {
        ProjectsManager projectsManager = JavaLanguageServerPlugin.getProjectsManager();
        if (projectsManager != null) {
            boolean gradleJavaHomeChanged;
            boolean bl = gradleJavaHomeChanged = !Objects.equals(oldPreferences.getGradleJavaHome(), newPreferences.getGradleJavaHome());
            if (gradleJavaHomeChanged || this.hasAllowedChecksumsChanged(oldPreferences, newPreferences)) {
                for (IProject project : ProjectUtils.getGradleProjects()) {
                    if (!newPreferences.isGradleWrapperEnabled() && !gradleJavaHomeChanged) continue;
                    this.updateProject(projectsManager, project, gradleJavaHomeChanged);
                }
            }
        }
    }

    private void updateProject(ProjectsManager projectsManager, IProject project, boolean gradleJavaHomeChanged) {
        String projectDir = project.getLocation().toFile().getAbsolutePath();
        Path projectPath = Paths.get(projectDir, new String[0]);
        if (gradleJavaHomeChanged || Files.exists(projectPath.resolve("gradlew"), new LinkOption[0])) {
            ProjectConfiguration configuration = CorePlugin.configurationManager().loadProjectConfiguration(project);
            GradleDistribution distribution = configuration.getBuildConfiguration().getGradleDistribution();
            if (gradleJavaHomeChanged || !(distribution instanceof WrapperGradleDistribution)) {
                projectsManager.updateProject(project, true);
            } else {
                try {
                    ValidationResult result = new WrapperValidator().checkWrapper(projectDir);
                    if (!result.isValid()) {
                        projectsManager.updateProject(project, true);
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
    }

    private boolean hasAllowedChecksumsChanged(Preferences oldPreferences, Preferences newPreferences) {
        if (!Objects.equals(oldPreferences.getGradleWrapperList(), newPreferences.getGradleWrapperList())) {
            this.putSha256(newPreferences.getGradleWrapperList());
            return true;
        }
        return false;
    }

    private void putSha256(List<?> gradleWrapperList) {
        ArrayList<String> sha256Allowed = new ArrayList<String>();
        ArrayList<String> sha256Disallowed = new ArrayList<String>();
        for (Object object : gradleWrapperList) {
            if (!(object instanceof Map)) continue;
            Map map = (Map)object;
            ChecksumWrapper sha256 = new ChecksumWrapper();
            sha256.allowed = true;
            map.forEach((k, v) -> {
                block10: {
                    if (!(k instanceof String)) break block10;
                    switch ((String)k) {
                        case "sha256": {
                            if (!(v instanceof String)) break;
                            checksumWrapper.checksum = (String)v;
                            break;
                        }
                        case "allowed": {
                            if (!(v instanceof Boolean)) break;
                            checksumWrapper.allowed = (Boolean)v;
                            break;
                        }
                    }
                }
            });
            if (sha256.checksum == null) continue;
            if (sha256.allowed) {
                sha256Allowed.add(sha256.checksum);
                continue;
            }
            sha256Disallowed.add(sha256.checksum);
        }
        WrapperValidator.clear();
        if (sha256Allowed != null) {
            WrapperValidator.allow(sha256Allowed);
        }
        if (sha256Disallowed != null) {
            WrapperValidator.disallow(sha256Disallowed);
        }
    }

    class ChecksumWrapper {
        private String checksum;
        private boolean allowed;

        ChecksumWrapper() {
        }
    }
}

