/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.nls.Language;

public interface ITranslation
extends Comparable<ITranslation> {
    public static final String KEY_ALLOWED_CHARACTER_SET = "\\w.\\-";
    public static final Pattern KEY_REGEX = Pattern.compile("[A-Za-z][\\w.\\-]{0,200}");
    public static final Comparator<ITranslation> TRANSLATION_COMPARATOR = Comparator.comparing(ITranslation::key).thenComparing(t -> t.text(Language.LANGUAGE_DEFAULT).orElse("")).thenComparing(t -> String.join((CharSequence)"", t.texts().values()));

    public String key();

    public ITranslation merged(ITranslation var1);

    public Optional<String> text(Language var1);

    public Optional<String> bestText(Language var1);

    public Map<Language, String> texts();

    public Stream<Language> languages();

    @Override
    default public int compareTo(ITranslation o) {
        return TRANSLATION_COMPARATOR.compare(this, o);
    }
}

