/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;

public class AstValueFieldBuilder<INSTANCE extends AstValueFieldBuilder<INSTANCE>>
extends AstTypeBuilder<INSTANCE> {
    public static final Set<String> PROPOSAL_VALUE_DATA_TYPES = new ConcurrentSkipListSet<String>();

    protected AstValueFieldBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public INSTANCE insert() {
        ParameterizedType parameterizedType = this.getFactory().getAst().newParameterizedType(this.getSuperType());
        Type typeArg = this.getFactory().newTypeReference("java.lang.Long");
        parameterizedType.typeArguments().add(typeArg);
        this.withSuperType((Type)parameterizedType);
        super.insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            String[] proposalTypes;
            if (typeArg != null) {
                ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)typeArg);
                links.addLinkedPosition(dataTypeTracker, true, "VALUE_TYPE");
            }
            for (String fqn : proposalTypes = PROPOSAL_VALUE_DATA_TYPES.toArray(new String[0])) {
                ITypeBinding typeBinding = this.getFactory().resolveTypeBinding(fqn);
                if (typeBinding == null) continue;
                links.addLinkedPositionProposal("VALUE_TYPE", typeBinding);
            }
        }
        return (INSTANCE)this;
    }

    static {
        PROPOSAL_VALUE_DATA_TYPES.add("java.lang.Long");
        PROPOSAL_VALUE_DATA_TYPES.add("java.lang.Boolean");
        PROPOSAL_VALUE_DATA_TYPES.add(BigDecimal.class.getName());
        PROPOSAL_VALUE_DATA_TYPES.add(String.class.getName());
    }
}

