/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.services.extensions.AbstractDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLReferencesDefinitionParticipant
extends AbstractDefinitionParticipant {
    private final XMLReferencesPlugin plugin;

    public XMLReferencesDefinitionParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    protected boolean match(DOMDocument document) {
        return true;
    }

    @Override
    protected void doFindDefinition(IDefinitionRequest request, List<LocationLink> locations, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createFromQuery(request.getNode(), request.getOffset(), this.plugin.getReferencesSettings());
        if (query == null) {
            return;
        }
        query.setMatchNode(true);
        query.setSearchInIncludedFiles(true);
        SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> {
            LocationLink location = XMLPositionUtility.createLocationLink(XMLPositionUtility.createRange(fromSearchNode), (DOMRange)toSearchNode);
            locations.add(location);
        }, cancelChecker);
    }
}

